/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.noteReceivable.util;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.business.util.CacheQueryPayStorage;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import kd.ebg.note.common.framework.services.NoteReceivableInfoService;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.slf4j.MDC;

public class BankQueryNoteReceivableTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankQueryNoteReceivableTask.class);
    private BankNoteReceivableRequest request;
    private EBContext context;
    private static final int QUERY_PAY_INTERVAL_MINUTES = 1;

    public BankQueryNoteReceivableTask(BankNoteReceivableRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBBankNoteReceivableResponse response = this.submitQueryNotePayable(this.request, this.context);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankNoteReceivableResponse submitQueryNotePayable(BankNoteReceivableRequest request, EBContext context) {
        String bizSeqID = Sequence.gen18Sequence();
        if (StringUtils.isEmpty((String)request.getHeader().getBizSeqID())) {
            request.getHeader().setBizSeqID(bizSeqID);
        }
        String customId = request.getHeader().getCustomerID();
        String batchSeqID = request.getBankBatchSeqID();
        String key = customId + batchSeqID + "queryNoteReceivable";
        try {
            FEPAccess access;
            List result;
            block22: {
                LocalDateTime lastQueryTime;
                if (CacheQueryPayStorage.checkRepeatQuery((String)key)) {
                    this.logger.info("\u5f53\u524d\u6279\u6b21\u6b63\u5728\u5411\u94f6\u884c\u53d1\u8d77\u540c\u6b65\uff0c\u672c\u6b21\u540c\u6b65\u4e0d\u751f\u6548");
                    EBBankNoteReceivableResponse response = new EBBankNoteReceivableResponse();
                    response.setHeader(request.getHeader());
                    response.setNoteReceivableInfos(request.getNoteReceivableInfos());
                    response.setBankBatchSeqID(request.getBankBatchSeqID());
                    EBBankNoteReceivableResponse eBBankNoteReceivableResponse = response;
                    return eBBankNoteReceivableResponse;
                }
                context.setBizName("queryNoteReceivable");
                MDCUtil.clearBussinessMDC();
                MDCUtil.initMDC((EBContext)context);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                this.logger.infoIndex("\u5e94\u6536\u7968\u636e\u540c\u6b65\u5f00\u59cb\u5904\u7406");
                this.logger.info("\u5e94\u6536\u7968\u636e\u540c\u6b65\u5f00\u59cb\u5904\u7406");
                EBContext.setContext((EBContext)context);
                List noteReceivableInfos = request.getNoteReceivableInfos();
                if (noteReceivableInfos.isEmpty()) {
                    EBBankNoteReceivableResponse eBBankNoteReceivableResponse = null;
                    return eBBankNoteReceivableResponse;
                }
                PaymentState state = PaymentState.getEnumById((int)((NoteReceivableInfo)noteReceivableInfos.get(0)).getStatus());
                if (PaymentState.PACKAGED == state || PaymentState.INITIAL == state) {
                    this.logger.info("\u5f53\u524d\u4fe1\u606f\u8fd8\u672a\u63d0\u4ea4\u5230\u94f6\u884c\uff0c\u4e0d\u5141\u8bb8\u4ece\u94f6\u884c\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001");
                    EBBankNoteReceivableResponse eBBankNoteReceivableResponse = null;
                    return eBBankNoteReceivableResponse;
                }
                String reserved1 = request.getReserved1();
                if (!"unittest".equals(reserved1) && !"forceQuery".equals(reserved1) && Objects.nonNull(lastQueryTime = ((NoteReceivableInfo)noteReceivableInfos.get(0)).getLastSyncTime()) && LocalDateTime.now().plusMinutes(-1L).isBefore(lastQueryTime)) {
                    this.logger.info("1\u5206\u949f\u5185\u5df2\u7ecf\u4ece\u94f6\u884c\u540c\u6b65\u8fc7\u4e86,\u672c\u6b21\u4e0d\u518d\u4ece\u94f6\u884c\u67e5\u8be2");
                    EBBankNoteReceivableResponse eBBankNoteReceivableResponse = null;
                    return eBBankNoteReceivableResponse;
                }
                result = null;
                String bankVersionID = context.getBankVersionID();
                String implClassName = ((NoteReceivableInfo)noteReceivableInfos.get(0)).getQueryImplClassName();
                EBGNoteReceivableUtils.setPaymentUpdateTimeAndStatus((List)noteReceivableInfos, (LocalDateTime)LocalDateTime.now());
                result = noteReceivableInfos;
                request.setNoteReceivableInfos(noteReceivableInfos);
                access = null;
                try {
                    IQueryNoteReceivable queryNotePayable = (IQueryNoteReceivable)BankBundleManager.getInstance().getImplByClassName(bankVersionID, IQueryNoteReceivable.class, implClassName);
                    EBContext.initParameter();
                    MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                    access = FEPAccessUtil.access((String)bankVersionID, (String)context.getBankLoginID());
                    EBBankNoteReceivableResponse response = queryNotePayable.queryPay(request);
                    if (Objects.nonNull(EBContext.getContext().getThrowableAfterSend())) {
                        EBGNoteReceivableUtils.setPaymentState((List)request.getNoteReceivableInfos(), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u7ed3\u679c\u3002", (String)"BankQueryNoteReceivableTask_0", (String)"ebg-note-business", (Object[])new Object[0]), (String)"", (String)"");
                        break block22;
                    }
                    Preconditions.checkState((boolean)Objects.nonNull(response), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankQueryNoteReceivableTask_1", (String)"ebg-note-business", (Object[])new Object[0]));
                    if (response == null) break block22;
                    Preconditions.checkState((boolean)Objects.nonNull(response.getNoteReceivableInfos()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684 \u5e94\u4ed8\u7968\u636e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankQueryNoteReceivableTask_2", (String)"ebg-note-business", (Object[])new Object[0]));
                    result = response.getNoteReceivableInfos();
                }
                catch (Exception e) {
                    try {
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        EBGNoteReceivableUtils.setPaymentState((List)request.getNoteReceivableInfos(), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u7ed3\u679c\u3002", (String)"BankQueryNoteReceivableTask_0", (String)"ebg-note-business", (Object[])new Object[0]), (String)"", (String)"");
                        this.logger.error("\u540c\u6b65\u5e94\u4ed8\u7968\u636e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", new Object[]{e.getMessage()});
                        this.logger.error(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
                    }
                    catch (Throwable throwable) {
                        FEPAccessUtil.release(access);
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        throw throwable;
                    }
                    FEPAccessUtil.release((FEPAccess)access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                }
            }
            FEPAccessUtil.release((FEPAccess)access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            LocalDateTime queryTime = LocalDateTime.now();
            if (request != null) {
                result.forEach(info -> {
                    info.setLastSyncTime(queryTime);
                    info.setLastSyncRequestSeq(context.getRequestSeqID());
                    info.setSyncCount(Integer.valueOf(Integer.parseInt(Objects.toString(info.getSyncCount(), "0")) + 1));
                    info.setUpdateTime(LocalDateTime.now());
                    if (info.getStatus().intValue() == PaymentState.SUCCESS.getId() || info.getStatus().intValue() == PaymentState.FAIL.getId()) {
                        info.setPayFinishTime(LocalDateTime.now());
                    }
                });
            }
            NoteReceivableInfoService service = NoteReceivableInfoService.getInstance();
            if (result != null) {
                service.save(result);
            } else {
                result = request.getNoteReceivableInfos();
                service.save(result);
            }
            EBBankNoteReceivableResponse response = new EBBankNoteReceivableResponse();
            response.setHeader(request.getHeader());
            response.setNoteReceivableInfos(result);
            response.setBankBatchSeqID(request.getBankBatchSeqID());
            EBBankNoteReceivableResponse eBBankNoteReceivableResponse = response;
            return eBBankNoteReceivableResponse;
        }
        catch (Throwable e) {
            this.logger.error("BankQueryNoteReceivableTask error", e);
            EBBankNoteReceivableResponse eBBankNoteReceivableResponse = null;
            return eBBankNoteReceivableResponse;
        }
        finally {
            CacheQueryPayStorage.releaseKey((String)key);
        }
    }
}

