/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABCErrCodeDataBase;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class NewNoteParser {
    public static BankResponse parseHeader(Element root) {
        String respCode = root.getChildTextTrim("RespCode");
        String RespSource = root.getChildTextTrim("RespSource");
        String respInfo = root.getChildTextTrim("RespInfo");
        String rxtInfo = root.getChildTextTrim("RxtInfo");
        BankResponse rsp = new BankResponse();
        rsp.setResponseCode(respCode);
        if (!"0".equals(RespSource)) {
            if (!StringUtils.isEmpty((String)rxtInfo)) {
                rsp.setResponseMessage(rxtInfo);
            } else {
                rsp.setResponseCode(RespSource);
            }
        } else if (ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"NewNoteParser_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(respInfo)) {
            rsp.setResponseMessage("");
        } else if (!StringUtils.isEmpty((String)rxtInfo)) {
            rsp.setResponseMessage(rxtInfo);
        } else if (!StringUtils.isEmpty((String)respInfo)) {
            rsp.setResponseMessage(respInfo);
        } else {
            rsp.setResponseMessage(ABCErrCodeDataBase.getValue((String)respCode));
        }
        return rsp;
    }

    public static List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        Element root = ABC_DC_Parser.parseString2Root((String)rspStr);
        BankResponse rsponse = NewNoteParser.parseHeader(root);
        String RespSource = root.getChildTextTrim("RespSource");
        if (StringUtils.isEmpty((String)rsponse.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsponse.getResponseCode(), (String)rsponse.getResponseMessage());
        } else if ("ECCBFI0011".equals(rsponse.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)rsponse.getResponseCode(), (String)rsponse.getResponseMessage());
        } else if (!"0000".equals(rsponse.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsponse.getResponseCode(), (String)rsponse.getResponseMessage());
        } else {
            Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
            String BusiNo = JDomUtils.getChildText((Element)hermes, (String)"BusiNo");
            String BusiType = JDomUtils.getChildText((Element)hermes, (String)"BusiType");
            if (StringUtils.isEmpty((String)BusiNo)) {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"");
            } else {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"");
                ((NotePayableInfo)notePayableInfos.get(0)).setReserved1(BusiNo);
                ((NotePayableInfo)notePayableInfos.get(0)).setReserved2(BusiType);
            }
        }
        return notePayableInfos;
    }

    public static void parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        Element root = ABC_DC_Parser.parseString2Root((String)rsp);
        BankResponse rsponse = NewNoteParser.parseHeader(root);
        String RespSource = root.getChildTextTrim("RespSource");
        if (StringUtils.isEmpty((String)rsponse.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsponse.getResponseCode(), (String)rsponse.getResponseMessage());
        } else if (!"0000".equals(rsponse.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsponse.getResponseCode(), (String)rsponse.getResponseMessage());
        } else {
            Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
            String BusiNo = JDomUtils.getChildText((Element)hermes, (String)"BusiNo");
            if (StringUtils.isEmpty((String)BusiNo)) {
                BusiNo = JDomUtils.getChildText((Element)hermes, (String)"BtNo");
            }
            String BusiType = JDomUtils.getChildText((Element)hermes, (String)"BusiType");
            if (StringUtils.isEmpty((String)BusiNo)) {
                EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsponse.getResponseMessage());
            } else {
                EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsponse.getResponseMessage());
                ((NoteReceivableInfo)receivableInfos.get(0)).setReserved1(BusiNo);
                ((NoteReceivableInfo)receivableInfos.get(0)).setReserved2(BusiType);
            }
        }
    }

    public static void parseDiscount(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        Element root = ABC_DC_Parser.parseString2Root((String)rsp);
        BankResponse rsponse = NewNoteParser.parseHeader(root);
        if (StringUtils.isEmpty((String)rsponse.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsponse.getResponseCode(), (String)rsponse.getResponseMessage());
        } else {
            Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
            String BusiNo = JDomUtils.getChildText((Element)hermes, (String)"BtNo");
            String BusiType = JDomUtils.getChildText((Element)hermes, (String)"BusiType");
            if (StringUtils.isEmpty((String)BusiNo)) {
                EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"");
            } else {
                EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"");
                ((NoteReceivableInfo)receivableInfos.get(0)).setReserved1(BusiNo);
                ((NoteReceivableInfo)receivableInfos.get(0)).setReserved2(BusiType);
            }
        }
    }
}

