/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.payable.register;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.NewNoteParser;
import kd.ebg.note.banks.abc.dc.service.newnote.payable.register.QueryRegisterPayableNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RegisterNoteImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterPayableNoteImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CFRC49";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u7533\u8bf7", (String)"RegisterNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        NotePayableInfo info = (NotePayableInfo)bankNotePayableRequest.getNotePayableInfoList().get(0);
        BankAcnt acnt = bankNotePayableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New((String)"CFRC49", (String)info.getBankBatchSeqId());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19((String)acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt((BankAcnt)acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        Element hermes = CommNotePacker.packHermes((Element)root, (String)"CH1003", (String)"SPIN1060", (String)"");
        Element BusiInf = JDomUtils.addChild((Element)hermes, (String)"BusiInf");
        JDomUtils.addChild((Element)BusiInf, (String)"AppDt", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)BusiInf, (String)"BnedMtmrk", (String)info.getTransferFlag());
        JDomUtils.addChild((Element)BusiInf, (String)"BtNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)BusiInf, (String)"CdSplit", (String)(info.getGrdBag() == null ? "0" : info.getGrdBag()));
        JDomUtils.addChild((Element)BusiInf, (String)"CdAmt", (String)info.getAmount().setScale(2).toString());
        JDomUtils.addChild((Element)BusiInf, (String)"CdType", (String)info.getDraftType());
        JDomUtils.addChild((Element)BusiInf, (String)"IssDt", (String)(info.getIssueDate() != null ? LocalDateUtil.formatDate((LocalDate)info.getIssueDate(), (String)"yyyyMMdd") : LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"yyyyMMdd")));
        JDomUtils.addChild((Element)BusiInf, (String)"DueDt", (String)(info.getDueDate() != null ? LocalDateUtil.formatDate((LocalDate)info.getDueDate(), (String)"yyyyMMdd") : ""));
        JDomUtils.addChild((Element)BusiInf, (String)"Note", (String)info.getExplanation());
        Element AcptPsnInf = JDomUtils.addChild((Element)hermes, (String)"AcptPsnInf");
        if ("AC01".equals(info.getDraftType())) {
            JDomUtils.addChild((Element)AcptPsnInf, (String)"DistTp", (String)"");
            JDomUtils.addChild((Element)AcptPsnInf, (String)"Name", (String)"");
        } else {
            JDomUtils.addChild((Element)AcptPsnInf, (String)"DistTp", (String)"DT02");
            JDomUtils.addChild((Element)AcptPsnInf, (String)"Name", (String)info.getAcceptorAccName());
        }
        JDomUtils.addChild((Element)AcptPsnInf, (String)"Acct", (String)NewNoteUtil.getAcceptorAccNo((NotePayableInfo)info));
        JDomUtils.addChild((Element)AcptPsnInf, (String)"AcctSvcr", (String)info.getAcceptorBankCnaps());
        JDomUtils.addChild((Element)AcptPsnInf, (String)"IsDependRoster", (String)"0");
        Element PyeeInf = JDomUtils.addChild((Element)hermes, (String)"PyeeInf");
        JDomUtils.addChild((Element)PyeeInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)PyeeInf, (String)"Acct", (String)NewNoteUtil.getPayeeAccNo((NotePayableInfo)info));
        JDomUtils.addChild((Element)PyeeInf, (String)"Name", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)PyeeInf, (String)"AcctSvcr", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)hermes, (String)"IsAutoRecvBill", (String)info.getAutoReceive());
        JDomUtils.addChild((Element)PyeeInf, (String)"IsDependRoster", (String)"0");
        Element CustInf = JDomUtils.addChild((Element)hermes, (String)"CustInf");
        JDomUtils.addChild((Element)CustInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CustInf, (String)"AcctSvcr", (String)acnt.getCnaps());
        info.setAutoAccept("1");
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        return NewNoteParser.parse(bankNotePayableRequest, rspStr);
    }
}

