/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.receivable.cancel;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.DetailNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.NewNoteParser;
import kd.ebg.note.banks.abc.dc.service.newnote.receivable.QueryReceivableNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.banks.abc.dc.service.newnote.util.TypeConvertUtils;
import kd.ebg.note.banks.abc.dc.utils.TypeInfo;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivableCancelNoteImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceivableCancelNoteImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceivableNoteImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CFRC51";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u7968\u901a\u7528\u64a4\u9500", (String)"ReceivableCancelNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        BankAcnt acnt = bankNoteReceivableRequest.getAcnt();
        NoteReceivableInfo info = (NoteReceivableInfo)bankNoteReceivableRequest.getNoteReceivableInfos().get(0);
        String subBizType = info.getSubBizType();
        String code = info.getOperationCode();
        String typeCode = subBizType + code;
        TypeInfo typeInfo = TypeConvertUtils.getReplayPackerTypeInfo((String)typeCode);
        if (null == typeInfo) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b: %1$s\u7684\u4e1a\u52a1\u79cd\u7c7b\uff1a%2$s\u65e0\u6cd5\u64a4\u9500\u3002\u4e0d\u652f\u6301\u8be5\u64a4\u9500\u7c7b\u578b\u4e1a\u52a1\u3002", (String)"ReceivableCancelNoteImpl_5", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), subBizType, code));
        }
        Element root = ABC_DC_Packer.createABCRoot4New((String)"CFRC51", (String)info.getBankBatchSeqId());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19((String)acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt((BankAcnt)acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        Element hermes = CommNotePacker.packHermes((Element)root, (String)"CH1003", (String)"SPIN1017", (String)"");
        JDomUtils.addChild((Element)hermes, (String)"BusiType", (String)typeInfo.getABCNoteType());
        RequestContextUtils.setRunningParam((String)"BusiType", (String)typeInfo.getABCNoteType());
        String busCode = new DetailNoteImpl().getDetail(info, acnt);
        if (StringUtils.isEmpty((String)busCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a\u7a7a", (String)"ReceivableCancelNoteImpl_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        this.logger.info("\u4e1a\u52a1\u7f16\u7801(BusCode)=" + busCode);
        JDomUtils.addChild((Element)hermes, (String)"BusiNo", (String)busCode);
        JDomUtils.addChild((Element)hermes, (String)"Note", (String)info.getExplanation());
        Element CancelResPsnInf = JDomUtils.addChild((Element)hermes, (String)"CancelResPsnInf");
        JDomUtils.addChild((Element)CancelResPsnInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CancelResPsnInf, (String)"Acct", (String)NewNoteUtil.getPayeeAccNo((NoteReceivableInfo)info));
        JDomUtils.addChild((Element)CancelResPsnInf, (String)"Name", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)CancelResPsnInf, (String)"AcctSvcr", (String)info.getPayeeBankCnaps());
        Element CustInf = JDomUtils.addChild((Element)hermes, (String)"CustInf");
        JDomUtils.addChild((Element)CustInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CustInf, (String)"AcctSvcr", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)CustInf, (String)"ConAcctSvcr", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)info.getBillNo());
        JDomUtils.addChild((Element)hermes, (String)"CdRangeStart", (String)NewNoteUtil.getBankNoteSubrange((String)info.getStartNo()));
        JDomUtils.addChild((Element)hermes, (String)"CdRangeEnd", (String)NewNoteUtil.getBankNoteSubrange((String)info.getEndNo()));
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NewNoteParser.parse(bankNoteReceivableRequest, s);
        return bankNoteReceivableRequest.getNoteReceivableInfos();
    }
}

