/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.simulator.business;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.banks.simulator.business.model.NoteHold;

public class NoteHoldRepository {
    EBGLogger log = EBGLogger.getInstance().getLogger(NoteHoldRepository.class);
    private static NoteHoldRepository instance;
    private final String PAYABLE_ENTITY = "note_sim_hold";
    private final String SELECT_ALL_PROPERTIES = "number,name,bankname,billno,startno,endno,amount,notestatus,cirstatus";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NoteHoldRepository getInstance() {
        Class<NoteHoldRepository> clazz = NoteHoldRepository.class;
        synchronized (NoteHoldRepository.class) {
            if (instance == null) {
                instance = new NoteHoldRepository();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<NoteHold> getListByAccno(String accno) {
        QFilter filter = QFilter.of((String)"number = ?", (Object[])new Object[]{accno});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"note_sim_hold", (String)"number,name,bankname,billno,startno,endno,amount,notestatus,cirstatus", (QFilter[])filter.toArray());
        return this.getModel(dynamicObjects);
    }

    public boolean deleteModel(NoteHold noteRelies) {
        QFilter filter = QFilter.of((String)"number = ? and billno = ? and startno = ? and endno = ? ", (Object[])new Object[]{noteRelies.getNumber(), noteRelies.getBillno(), noteRelies.getStartno(), noteRelies.getEndno()});
        DeleteServiceHelper.delete((String)"note_sim_hold", (QFilter[])filter.toArray());
        return true;
    }

    public boolean insertModel(NoteHold noteRelie) {
        if (noteRelie != null) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
            dynamicObjectList.add(this.transModel(noteRelie));
            DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[1]);
            try {
                Object[] objs = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                this.log.info("\u6301\u7968\u8bb0\u5f55\u63d2\u5165\u5b8c\u6210");
                return true;
            }
            catch (Exception e) {
                this.log.error("\u6301\u7968\u8bb0\u5f55\u63d2\u5165\u5931\u8d25");
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return false;
    }

    public DynamicObject transModel(NoteHold noteRely) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"note_sim_hold");
        dynamicObject.set("number", (Object)noteRely.getNumber());
        dynamicObject.set("name", (Object)noteRely.getName());
        dynamicObject.set("bankname", (Object)noteRely.getCreator());
        dynamicObject.set("billno", (Object)noteRely.getBillno());
        dynamicObject.set("startno", (Object)noteRely.getStartno());
        dynamicObject.set("endno", (Object)noteRely.getEndno());
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("amount", (Object)noteRely.getAmount());
        dynamicObject.set("notestatus", (Object)noteRely.getNotestatus());
        dynamicObject.set("cirstatus", (Object)noteRely.getCirstatus());
        return dynamicObject;
    }

    public List<NoteHold> getModel(DynamicObject[] dynamicObjects) {
        ArrayList<NoteHold> noteRelies = new ArrayList<NoteHold>(1);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return noteRelies;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            NoteHold noteRely = new NoteHold();
            noteRely.setNumber(dynamicObject.getString("number"));
            noteRely.setCreator(dynamicObject.getString("bankname"));
            noteRely.setName(dynamicObject.getString("name"));
            noteRely.setBillno(dynamicObject.getString("billno"));
            noteRely.setStartno(dynamicObject.getString("startno"));
            noteRely.setEndno(dynamicObject.getString("endno"));
            noteRely.setId(dynamicObject.getLong("id"));
            noteRely.setAmount(dynamicObject.getBigDecimal("amount"));
            noteRely.setNotestatus(dynamicObject.getString("notestatus"));
            noteRely.setCirstatus(dynamicObject.getString("cirstatus"));
            noteRelies.add(noteRely);
        }
        return noteRelies;
    }
}

