/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.simulator.business;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.banks.simulator.business.model.NoteRely;

public class NoteRelyRepository {
    EBGLogger log = EBGLogger.getInstance().getLogger(NoteRelyRepository.class);
    private static NoteRelyRepository instance;
    private final String PAYABLE_ENTITY = "note_sim_reply";
    private final String SELECT_ALL_PROPERTIES = "number,name,bankname,billno,startno,endno,accno,bankrefkey,type,amount";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NoteRelyRepository getInstance() {
        Class<NoteRelyRepository> clazz = NoteRelyRepository.class;
        synchronized (NoteRelyRepository.class) {
            if (instance == null) {
                instance = new NoteRelyRepository();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<NoteRely> getListByAccno(String accno, String type) {
        QFilter filter = QFilter.of((String)"accno = ? and type = ?", (Object[])new Object[]{accno, type});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"note_sim_reply", (String)"number,name,bankname,billno,startno,endno,accno,bankrefkey,type,amount", (QFilter[])filter.toArray());
        return this.getModel(dynamicObjects);
    }

    public boolean deleteModel(NoteRely noteRelies) {
        QFilter filter = QFilter.of((String)"accno = ? and billno = ? and startno = ? and endno = ?  and type = ?", (Object[])new Object[]{noteRelies.getAccno(), noteRelies.getBillno(), noteRelies.getStartno(), noteRelies.getEndno(), noteRelies.getType()});
        DeleteServiceHelper.delete((String)"note_sim_reply", (QFilter[])filter.toArray());
        return true;
    }

    public boolean insertModel(NoteRely noteRelies) {
        if (noteRelies != null) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
            dynamicObjectList.add(this.transModel(noteRelies));
            DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[1]);
            try {
                Object[] objs = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                this.log.info("\u5f85\u7b7e\u6536\u8bb0\u5f55\u63d2\u5165\u5b8c\u6210");
                return true;
            }
            catch (Exception e) {
                this.log.error("\u5f85\u7b7e\u6536\u8bb0\u5f55\u63d2\u5165\u5931\u8d25");
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return false;
    }

    public DynamicObject transModel(NoteRely noteRely) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"note_sim_reply");
        dynamicObject.set("accno", (Object)noteRely.getAccno());
        dynamicObject.set("number", (Object)noteRely.getNumber());
        dynamicObject.set("name", (Object)noteRely.getName());
        dynamicObject.set("bankname", (Object)noteRely.getCreator());
        dynamicObject.set("billno", (Object)noteRely.getBillno());
        dynamicObject.set("startno", (Object)noteRely.getStartno());
        dynamicObject.set("endno", (Object)noteRely.getEndno());
        dynamicObject.set("bankrefkey", (Object)noteRely.getBankrefkey());
        dynamicObject.set("amount", (Object)noteRely.getAmount());
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("type", (Object)noteRely.getType());
        return dynamicObject;
    }

    public List<NoteRely> getModel(DynamicObject[] dynamicObjects) {
        ArrayList<NoteRely> noteRelies = new ArrayList<NoteRely>(1);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return noteRelies;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            NoteRely noteRely = new NoteRely();
            noteRely.setAccno(dynamicObject.getString("accno"));
            noteRely.setNumber(dynamicObject.getString("number"));
            noteRely.setCreator(dynamicObject.getString("bankname"));
            noteRely.setName(dynamicObject.getString("name"));
            noteRely.setBillno(dynamicObject.getString("billno"));
            noteRely.setStartno(dynamicObject.getString("startno"));
            noteRely.setEndno(dynamicObject.getString("endno"));
            noteRely.setBankrefkey(dynamicObject.getString("bankrefkey"));
            noteRely.setId(dynamicObject.getLong("id"));
            noteRely.setAmount(dynamicObject.getBigDecimal("amount"));
            noteRelies.add(noteRely);
        }
        return noteRelies;
    }
}

