/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ksql.util.Base64;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Parser {
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    public static BankResponse parseHeader(Element pub) {
        BankResponse rsp = new BankResponse();
        String retCode = pub.getChildTextTrim("RetCode");
        String retMsg = pub.getChildTextTrim("RetMsg");
        String errMsg = pub.getChildText("ErrMsg");
        rsp.setResponseCode(retCode);
        rsp.setResponseMessage(retMsg + errMsg);
        return rsp;
    }

    public static Date parseICBCTransTime(String timeStampStr) throws EBServiceException {
        try {
            Date timeStamp = DateTimeUtils.parseDate((String)timeStampStr, (String)"yyyy-MM-dd-HH.mm.ss");
            String timeStr = DateTimeUtils.format((Date)timeStamp, (String)"HHmmss");
            String dateStr = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
            return DateUtil.String2Date((String)(dateStr + timeStr));
        }
        catch (ParseException e) {
            throw new EBServiceException((Throwable)e);
        }
    }

    public static Date convertICBCTransTime(String dateStr, String timeStampStr) throws EBServiceException {
        try {
            Date timeStamp = DateTimeUtils.parseDate((String)timeStampStr, (String)"yyyy-MM-dd-HH.mm.ss");
            String timeStr = DateTimeUtils.format((Date)timeStamp, (String)"HHmmss");
            return DateUtil.String2Date((String)(dateStr + timeStr));
        }
        catch (ParseException e) {
            throw new EBServiceException((Throwable)e);
        }
    }

    public static String decodeRsp(String content, boolean logContent) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance();
        if (StringUtils.isEmpty((String)content)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"Parser_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
        }
        int sep = content.indexOf("=");
        if (sep == -1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u7801\u5931\u8d25\uff0c\u94f6\u884c\u54cd\u5e94\u683c\u5f0f\u9519\u8bef\uff0c\u4e0d\u542b\u201c=\u201d\u3002", (String)"Parser_1", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
        }
        String temp = content.substring(0, sep);
        String result = content.substring(1 + sep);
        if ("reqData".equals(temp)) {
            String reqData = Base64.decodeToString((String)result);
            logger.info("\u94f6\u884c\u54cd\u5e94\u89e3\u7801\u540e\u5f97\u5230\u660e\u6587\u662f: \n" + reqData);
            return reqData;
        }
        if ("errorCode".equals(temp)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u9519\u8bef%s\u3002", (String)"Parser_4", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]), content));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u7801\u5931\u8d25\uff0c\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u9519\u8bef\uff1a\u94f6\u884c\u8fd4\u56de\u7684\u5bc6\u6587\u4e2d\u4e0d\u542breqData\u3002", (String)"Parser_3", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
    }

    public static BankResponse parseNoteHeader(Element root) throws EBServiceException {
        BankResponse rsp = new BankResponse();
        Namespace ns = root.getNamespace();
        Element transContent = JDomUtils.getChildElement((Element)root, (String)"TransContent", (Namespace)ns);
        if (transContent == null) {
            rsp.setResponseCode(JDomUtils.getChildText((Element)root, (String)"ReturnCode", (Namespace)ns));
            rsp.setResponseMessage(JDomUtils.getChildText((Element)root, (String)"ReturnMsg", (Namespace)ns));
        } else {
            rsp.setResponseCode(JDomUtils.getChildText((Element)transContent, (String)"ReturnCode", (Namespace)ns));
            rsp.setResponseMessage(JDomUtils.getChildText((Element)transContent, (String)"ReturnMsg", (Namespace)ns));
        }
        return rsp;
    }
}

