/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.codeless.detail;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.codeless.detail.CodelessBackInfo;
import kd.ebg.note.business.noteDetail.atomic.codeless.CodeLessAbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CodelessHoldImpl
extends CodeLessAbstractNoteDetailImpl {
    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "b2e016058";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6301\u6709\u7968\u636e\u67e5\u8be2", (String)"CodelessHoldImpl_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]);
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        int i = Integer.parseInt(pageTag);
        return (i += 20) + "";
    }

    public void configFactory(ConnectionFactory factory) {
        CEBHelper.configFactory((ConnectionFactory)factory, (String)this.getBizCode());
        super.configFactory(factory);
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Namespace ns = root.getNamespace();
        Element transContent = root.getChild("TransContent", ns);
        String sumnum = transContent.getChildTextTrim("SUMNUM", ns);
        int sum = Integer.parseInt(sumnum);
        int i = Integer.parseInt(pageTag);
        return i > sum;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getDateStr() {
        return "yyyy-MM-dd";
    }

    public List<Detail> getSideImpl(List<Detail> details) {
        BankNoteDetailRequest request = new BankNoteDetailRequest();
        CodelessBackInfo impl = new CodelessBackInfo();
        BankHeader header = new BankHeader();
        header.setAcnt(EBContext.getContext().getAcnt());
        header.setSubBizType("reply");
        request.setHeader(header);
        for (Detail detail : details) {
            try {
                BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
                body.setStartNo(detail.getStartNo());
                body.setEndNo(detail.getEndNo());
                body.setNoteNo(detail.getNoteNo());
                body.setDraftType(detail.getDraftType());
                request.setBody(body);
                EBBankDetailResponse response = impl.doBiz(request);
                List noteSidesInfo = ((Detail)response.getDetails().get(0)).getNoteSidesInfo();
                detail.setNoteSidesInfo(noteSidesInfo);
            }
            catch (Exception e) {
                detail.setIsNoteSidesError("Y");
            }
        }
        return details;
    }
}

