/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.detail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.codeless.detail.EndorseImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Check;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class CodelssNoteDetailImpl
extends AbstractNoteDetailImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ25";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u65b0\u7968\u5f85\u7b7e\u6536\u7968\u636e\u83b7\u53d6", (String)"CodelssNoteDetailImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return false;
    }

    public String pack(BankNoteDetailRequest request, String pagetag) {
        String transCode = "";
        BankNoteDetailRequestBody body = request.getBody();
        if (body.getTranType().equals("03")) {
            transCode = "BC03";
        } else if (body.getTranType().equals("02")) {
            transCode = "BC02";
        } else if (body.getTranType().equals("10")) {
            transCode = "BC07";
        } else if (body.getTranType().equals("20")) {
            transCode = "BC13";
        } else if (body.getTranType().equals("18")) {
            transCode = "BC11";
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e0\u6cd5\u5904\u7406\u7684\u56de\u590d\u7c7b\u578b\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"CodelssNoteDetailImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
        }
        Element root = new Element("body");
        JDomUtils.addChild((Element)root, (String)"signerAcct", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)root, (String)"eBillBusessType", (String)transCode);
        JDomUtils.addChild((Element)root, (String)"eBillType", (String)body.getDraftType());
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID((String)request.getAcnt().getAccNo()));
        JDomUtils.addChild((Element)root, (String)"beginNumber", (String)pagetag);
        JDomUtils.addChild((Element)root, (String)"queryNumber", (String)"20");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"PJ25", (String)signedMsg);
    }

    public List<Detail> parse(BankNoteDetailRequest rqst, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            String errorMsg = StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()});
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalNumber = body.getChildTextTrim("totalNumber");
        Element lists = Check.checkNoNullChildElement(body, "lists");
        List localList = lists.getChildren("list");
        ArrayList<Detail> result = new ArrayList<Detail>(16);
        for (Element element : localList) {
            Detail detailInfo = new Detail();
            result.add(detailInfo);
            String transJnlNo = element.getChildTextTrim("transJnlNo");
            detailInfo.setBankRefKey(transJnlNo);
            String billPackageNo = element.getChildTextTrim("billPackageNo");
            detailInfo.setNoteNo(billPackageNo);
            String sonBillRngLow = element.getChildTextTrim("sonBillRngLow");
            detailInfo.setStartNo(sonBillRngLow);
            String sonBillRngHight = element.getChildTextTrim("sonBillRngHight");
            detailInfo.setEndNo(sonBillRngHight);
            String voteDate = element.getChildTextTrim("voteDate");
            detailInfo.setIssueDate(voteDate);
            String expiryDate = element.getChildTextTrim("expiryDate");
            detailInfo.setDueDate(expiryDate);
            String unpackFlag = element.getChildTextTrim("unpackFlag");
            detailInfo.setGrdBag(unpackFlag);
            String eBillType = element.getChildTextTrim("eBillType");
            detailInfo.setDraftType(eBillType);
            String eBillAmount = element.getChildTextTrim("eBillAmount");
            detailInfo.setAmount(eBillAmount);
            String canTransferFlag = element.getChildTextTrim("canTransferFlag");
            detailInfo.setTransferFlag(canTransferFlag);
            String eBillStatus = element.getChildTextTrim("eBillStatus");
            detailInfo.setNoteStatus(eBillStatus);
            String billCirulateFlag = element.getChildTextTrim("billCirulateFlag");
            detailInfo.setIsNewECDS("0");
            detailInfo.setCirStatus(billCirulateFlag);
            String applyDate = element.getChildTextTrim("applyDate");
            detailInfo.setApplicationDate(applyDate);
            String applyName = element.getChildTextTrim("applyName");
            String applyAcctNo = element.getChildTextTrim("applyAcctNo");
            String applyBankNo = element.getChildTextTrim("applyBankNo");
            String applyBankName = element.getChildTextTrim("applyBankName");
            detailInfo.setApplicantAcName(applyName);
            detailInfo.setApplicantAcNo(applyAcctNo);
            detailInfo.setApplicantBankCnaps(applyBankNo);
            detailInfo.setApplicantBankName(applyBankName);
            detailInfo.setHolderBankName(applyBankName);
            detailInfo.setHolderCnapsCode(applyBankNo);
            detailInfo.setHolderAccNo(applyAcctNo);
            detailInfo.setPreHolderName(applyName);
            String eDrawerName = element.getChildTextTrim("eDrawerName");
            String eDrawerAcctNo = element.getChildTextTrim("eDrawerAcctNo");
            String eDrawerBankNo = element.getChildTextTrim("eDrawerBankNo");
            String eDrawerBankName = element.getChildTextTrim("eDrawerBankName");
            detailInfo.setDrawerAccName(eDrawerName);
            detailInfo.setDrawerAccNo(eDrawerAcctNo);
            detailInfo.setDrawerCnapsCode(eDrawerBankNo);
            detailInfo.setDrawerBankName(eDrawerBankName);
            String acceptorName = element.getChildTextTrim("acceptorName");
            String acceptorAcctNo = element.getChildTextTrim("acceptorAcctNo");
            String acceptorBankNo = element.getChildTextTrim("acceptorBankNo");
            String acceptorBankName = element.getChildTextTrim("acceptorBankName");
            detailInfo.setAcceptorAccName(acceptorName);
            detailInfo.setAcceptorAccNo(acceptorAcctNo);
            detailInfo.setAcceptorCnapsCode(acceptorBankNo);
            detailInfo.setAcceptorBankName(acceptorBankName);
            String takerName = element.getChildTextTrim("takerName");
            String takerAcctNo = element.getChildTextTrim("takerAcctNo");
            String takerBankNo = element.getChildTextTrim("takerBankNo");
            String takerBankName = element.getChildTextTrim("takerBankName");
            detailInfo.setPayeeAccName(takerName);
            detailInfo.setPayeeAccNo(takerAcctNo);
            detailInfo.setPayeeCnapsCode(takerBankNo);
            detailInfo.setPayeeBankName(takerBankName);
            String settleType = element.getChildTextTrim("settleType");
            detailInfo.setSettleWay(settleType);
            String liquidityType = element.getChildTextTrim("liquidityType");
            detailInfo.setClearType(liquidityType);
            if (!"10".equals(rqst.getBody().getTranType())) continue;
            try {
                EndorseImpl impl = new EndorseImpl();
                List<NoteSidesInfo> sides = impl.getMessage(billPackageNo, sonBillRngLow, sonBillRngHight);
                detailInfo.setNoteSidesInfo(sides);
            }
            catch (Exception e) {
                detailInfo.setIsNoteSidesError("Y");
            }
        }
        return result;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            return null;
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalNumber = body.getChildTextTrim("totalNumber");
        Integer totalNo = Integer.parseInt(totalNumber);
        Integer page = Integer.parseInt(pageTag);
        if (page + 20 - 1 >= totalNo) {
            return null;
        }
        return page + 20 + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        return StringUtils.isEmpty((String)pageTag);
    }
}

