/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.receivable.signin;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.codeless.receivable.QueryReceivableImpl;
import kd.ebg.note.banks.spdb.dc.services.codeless.receivable.QueryResultUtil;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CodelessSigninImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceivableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ06";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u65b0\u7968\u7b7e\u6536\u63a5\u53e3", (String)"CodelessSigninImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest request, String s) {
        NoteReceivableInfo[] infos = request.getNotePayableInfosAsArray();
        String code = infos[0].getOperationCode();
        String busSty = "";
        if ("10".equals(code)) {
            busSty = "BC07";
        } else if ("03".equals(code)) {
            busSty = "BC03";
        } else if ("02".equals(code)) {
            busSty = "BC02";
        } else if ("20".equals(code)) {
            busSty = "BC13";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7b7e\u6536\u7c7b\u578b\uff1a%s", (String)"CodelessSigninImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]), code));
        }
        Element root = new Element("body");
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID((String)request.getAcnt().getAccNo()));
        JDomUtils.addChild((Element)root, (String)"totalNumber", (String)(infos.length + ""));
        JDomUtils.addChild((Element)root, (String)"totalAmount", (String)infos[0].getAmount().toPlainString());
        JDomUtils.addChild((Element)root, (String)"signEBillBusinessType", (String)busSty);
        JDomUtils.addChild((Element)root, (String)"signatureDate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)root, (String)"signResult", (String)infos[0].getOtherInfo());
        JDomUtils.addChild((Element)root, (String)"signerType", (String)"RC01");
        JDomUtils.addChild((Element)root, (String)"signerAcctName", (String)infos[0].getDrawerAccName());
        JDomUtils.addChild((Element)root, (String)"acctNo", (String)infos[0].getDrawerAccNo());
        JDomUtils.addChild((Element)root, (String)"signerAddress", (String)infos[0].getDrawerAccCity());
        if ("SU01".equals(infos[0].getOtherInfo())) {
            JDomUtils.addChild((Element)root, (String)"noPayReason", (String)"CP06");
            if (StringUtils.isEmpty((String)infos[0].getExplanation())) {
                JDomUtils.addChild((Element)root, (String)"noPayRemark", (String)ResManager.loadKDString((String)"\u62d2\u7b7e", (String)"CodelessSigninImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            } else {
                JDomUtils.addChild((Element)root, (String)"noPayRemark", (String)infos[0].getExplanation());
            }
        }
        JDomUtils.addChild((Element)root, (String)"signerRemake", (String)infos[0].getExplanation());
        Element lists = new Element("lists");
        lists.setAttribute("name", "edraftList");
        JDomUtils.addChild((Element)root, (Element)lists);
        for (int i = 0; i < infos.length; ++i) {
            Element list = new Element("list");
            JDomUtils.addChild((Element)lists, (Element)list);
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)"0001");
            JDomUtils.addChild((Element)list, (String)"eBillBusinessId", (String)infos[i].getBankRefKey());
            JDomUtils.addChild((Element)list, (String)"billPackageNo", (String)infos[i].getBillNo());
            String startNo = infos[i].getStartNo();
            String endNo = infos[i].getEndNo();
            JDomUtils.addChild((Element)list, (String)"sonBillRngLow", (String)startNo);
            JDomUtils.addChild((Element)list, (String)"sonBillRngHight", (String)endNo);
            JDomUtils.addChild((Element)list, (String)"eBillAmount", (String)infos[i].getAmount().toString());
            JDomUtils.addChild((Element)list, (String)"unconditionalPayConsign", (String)"CC00");
        }
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg((String)"PJ06", (String)signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String rspStr) {
        List infos = request.getNoteReceivableInfos();
        QueryResultUtil.parserCommon(infos, rspStr);
        return infos;
    }
}

