/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.news.detail.endorsInfo;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.news.detail.endorsInfo.NoteInfoParser;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_Parser;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class ZLNoteInfoParser
extends NoteInfoParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ZLNoteInfoParser.class);

    public List<NoteSidesInfo> parseNoteInfoResponse(String rspStr) {
        ArrayList<NoteSidesInfo> result = new ArrayList<NoteSidesInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)ap);
        if (!rsp.getResponseCode().equals("0000")) {
            throw EBExceiptionUtil.serviceException((String)rsp.getResponseMessage());
        }
        Element body = ap.getChild("body");
        Element tran = body.getChild("tran");
        List rcd = tran.getChildren("rcd");
        int i = 1;
        for (Element cd : rcd) {
            NoteSidesInfo infoDetail = new NoteSidesInfo();
            String bankHisBizType = cd.getChildTextTrim("bankHisBizType");
            if ("BZ0401".equals(bankHisBizType)) {
                infoDetail.setBusinessCode("10");
            } else if ("BZ0101".equals(bankHisBizType)) {
                infoDetail.setBusinessCode("02");
            } else if ("BZ0301".equals(bankHisBizType)) {
                infoDetail.setBusinessCode("03");
            } else if ("BZ0501".equals(bankHisBizType)) {
                infoDetail.setBusinessCode("18");
            }
            String reqName = cd.getChildTextTrim("reqName");
            String reqAcctNo = cd.getChildTextTrim("reqAcctNo");
            infoDetail.setInitiatorName(reqName);
            infoDetail.setInitiatorAcNo(reqAcctNo);
            String rspName = cd.getChildTextTrim("rspName");
            String rspAcctNo = cd.getChildTextTrim("rspAcctNo");
            infoDetail.setOpponentName(rspName);
            infoDetail.setOpponentAcNo(rspAcctNo);
            String dt = cd.getChildTextTrim("dt");
            if (StringUtils.isNotEmpty((String)dt)) {
                LocalDate date = LocalDateUtil.parserDate((String)dt);
                infoDetail.setSignDate(LocalDateUtil.formatDate((LocalDate)date));
            }
            infoDetail.setResv1(i + "");
            result.add(infoDetail);
            ++i;
        }
        this.logger.info("\u83b7\u53d6\u5230\u7684\u80cc\u9762\u6570\u91cf\uff1a" + result.size());
        return result;
    }
}

