/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.szsrcb.cmp.service.receipt.download;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.szsrcb.cmp.service.receipt.api.BatchReceiptDownloadApplyImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        DownloadListDetail zipRecord = downloadListDetails.stream().filter(detail -> detail.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".zip")).findFirst().get();
        String fileName = zipRecord.getFileName();
        LocalDate transDate = request.getTransDate();
        String accNo = request.getAccNo();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        if (Objects.equals("EBG_FIRST_ZIP.zip", fileName)) {
            BatchReceiptDownloadApplyImpl bankReceiptDownloadPre = new BatchReceiptDownloadApplyImpl();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
            BankReceiptResponseEB receiptResponseEB = bankReceiptDownloadPre.doBiz(bankReceiptRequest);
            String receiptFileName = (String)receiptResponseEB.getData();
            if (EBGStringUtils.isEmpty((String)receiptFileName)) {
                logger.info("download-\u6ca1\u6709\u62ff\u5230\u6587\u4ef6\u540d-\u4e0b\u6b21\u91cd\u8bd5\u4f1a\u91cd\u65b0\u83b7\u53d6\u4e00\u6b21\u6587\u4ef6\u540d\uff0c\u5982\u679c\u4e00\u76f4\u83b7\u53d6\u4e0d\u5230\u6587\u4ef6\u540d\u8054\u7cfb\u94f6\u884c\u6392\u67e5\u3002");
            } else {
                result.addAll(this.downloadZip(request, receiptFileName));
            }
        } else {
            result.addAll(this.downloadZip(request, fileName));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> downloadZip(BankReceiptHandleRequest request, String zipName) {
        File zipFile;
        BankFtpProperties bankFtpProperties;
        LocalDate transDate;
        String transDateStr;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        String accNo = request.getAccNo();
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)(transDateStr = LocalDateUtil.formatDate((LocalDate)(transDate = request.getTransDate()))));
        boolean isSuccess = this.download(request, zipName, bakFilePath, bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, request.getBankLoginId()));
        if (isSuccess && (zipFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + zipName))).exists() && GZFileUtils.unZipFiles((String)zipFile.getPath(), (String)bakFilePath)) {
            File receiptFiles = FileCommonUtils.getFileByPath((String)bakFilePath);
            for (File receiptFile : receiptFiles.listFiles()) {
                String fileName = receiptFile.getName();
                if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".pdf") || !FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)fileName)) continue;
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileName(fileName);
                downloadListDetail.setFileLink(zipName);
                result.add(downloadListDetail);
            }
            FileCommonUtils.deleteFile((File)receiptFiles);
            FileCommonUtils.deleteFile((File)zipFile);
        }
        return result;
    }

    public boolean download(BankReceiptHandleRequest request, String zipName, String destFolder, BankFtpProperties bankFtpProperties) {
        String ftpPath = bankFtpProperties.getFtpPath();
        ftpPath = EBGStringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath;
        boolean result = false;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            result = this.ftpDownload(destFolder, zipName, ftpPath);
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            result = this.frontProxyDownload(zipName, request.getAccNo(), request.getTransDate());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ftpDownload(String destFolder, String orgFileName, String ftpPath) {
        boolean result;
        ChannelSftp sftp = null;
        try {
            sftp = SFTPUtils.getInstance().getSftp();
            result = SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
        }
        catch (Exception e) {
            result = false;
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u540d\uff1a" + orgFileName, (Throwable)e);
        }
        finally {
            SFTPUtils.getInstance().close(sftp);
        }
        return result;
    }

    private boolean frontProxyDownload(String orgFileName, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.downloadReceiptFile(orgFileName);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "SZSRCB_CMP_BankReceiptDownload";
    }

    public String getBizDesc() {
        return null;
    }
}

