/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.remote;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeBuildTreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.receipt.business.receipt.atom.impl.BankFrontProxyRequestImpl;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.formplugin.pojo.receipt.FilterTypeUtils;
import kd.ebg.receipt.formplugin.pojo.receipt.ReceiptFileInfo;
import kd.ebg.receipt.formplugin.pojo.receipt.ReceiptFileListResponseBody;
import kd.ebg.receipt.formplugin.util.StringUtils;

public class BankLoginProxyLeftTreePlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankLoginProxyLeftTreePlugin.class);
    public static final String KEY_TREEVIEW = "treeview";
    public static final String ROOT_ID = "01";
    public static final String SELECT_ID = "selectNodeId";
    public static final String ROOT_PATH = "/";
    public static final String ROOT_PATH_KEY = "rootPath";
    public static final String BANK_KEY = "bankVersionID";
    public static final String BANK_LOGIN_KEY = "bankLoginID";
    public static final String RECEIPT_REMOTE_BANK_LOGIN_FILE_KEY = "receipt_remote_bank_login";
    public static final String VIEW_MD5_KEY = "view_md5";
    private LinkedList<QFilter> rowQFilter = new LinkedList();
    private int dataCount = 0;

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        this.rowQFilter.clear();
        if (CollectionUtil.isNotEmpty((Collection)qFilters)) {
            for (QFilter qFilter : qFilters) {
                if ("enable".equalsIgnoreCase(qFilter.getProperty()) || !"file_name".equalsIgnoreCase(qFilter.getProperty())) continue;
                this.rowQFilter.add(qFilter);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final IPageCache iPageCache = this.getPageCache();
        final String dataCountCacheKey = "data_count";
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return Integer.parseInt(iPageCache.get(dataCountCacheKey));
            }

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit + 1;
                int pageSize = limit;
                String nodeId = iPageCache.get(BankLoginProxyLeftTreePlugin.SELECT_ID);
                String path = iPageCache.get(nodeId);
                if (StringUtils.isEmpty((String)path)) {
                    path = BankLoginProxyLeftTreePlugin.this.getRootPath();
                }
                DynamicObjectCollection dObjectCollection = this.getCollection(path, currentPage, pageSize);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(BankLoginProxyLeftTreePlugin.this.dataCount);
                iPageCache.put(dataCountCacheKey, BankLoginProxyLeftTreePlugin.this.dataCount + "");
                return dObjectCollection;
            }

            private DynamicObjectCollection getCollection(String path, int pageNo, int pageSize) {
                List<ReceiptFileInfo> fileList;
                String selectFields = "name,number,file_path,file_name,enable,modifytime,file_size";
                DynamicObjectCollection dCollection = QueryServiceHelper.query((String)BankLoginProxyLeftTreePlugin.RECEIPT_REMOTE_BANK_LOGIN_FILE_KEY, (String)selectFields, null);
                if (!BankLoginProxyLeftTreePlugin.this.rowQFilter.isEmpty()) {
                    FilterTypeUtils filterTypeUtils = new FilterTypeUtils();
                    QFilter qFilter = (QFilter)BankLoginProxyLeftTreePlugin.this.rowQFilter.getFirst();
                    String filterName = null;
                    int filterType = filterTypeUtils.getFilterType(qFilter);
                    if (qFilter.getOriginValue() != null && qFilter.getOriginValue() instanceof String) {
                        filterName = (String)qFilter.getOriginValue();
                    }
                    fileList = BankLoginProxyLeftTreePlugin.this.filterFileByTypeAndName(path, pageNo, pageSize, filterType, filterName);
                } else {
                    fileList = BankLoginProxyLeftTreePlugin.this.getFileListByParentPath(path, pageNo, pageSize);
                }
                for (ReceiptFileInfo receiptFileInfo : fileList) {
                    DynamicObject data = dCollection.addNew();
                    data.set("file_path", (Object)receiptFileInfo.getParentPath());
                    data.set("file_name", (Object)receiptFileInfo.getFileName());
                    data.set("name", (Object)receiptFileInfo.getFileName());
                    data.set("number", (Object)receiptFileInfo.getPath());
                    data.set("file_size", (Object)receiptFileInfo.getSize());
                    if (receiptFileInfo.getEditTime() != null) {
                        data.set("modifytime", (Object)receiptFileInfo.getEditTime());
                    }
                    data.set("enable", (Object)"1");
                }
                return dCollection;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (VIEW_MD5_KEY.equals(operateKey) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            StringBuilder message = new StringBuilder();
            String filePath = "";
            try {
                String bankLoginID = this.getBankLoginID();
                String bankVersionID = this.getBankVersionID();
                EBContext ebContext = EBContext.builder().bankLoginID(bankLoginID).bankVersionID(bankVersionID).customID(RequestContext.get().getTenantId()).build();
                EBContext.setContext((EBContext)ebContext);
                EBContext.initParameter();
                for (ListSelectedRow selectedRow : listSelectedRowCollection) {
                    String fileName = selectedRow.getName();
                    String path = selectedRow.getNumber();
                    String parentPath = path.replace(fileName, "");
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("type", (Object)"listMD5ByPath");
                    jsonObject.put("path", (Object)parentPath);
                    jsonObject.put("name", (Object)fileName);
                    ReceiptFileListResponseBody receiptFileListResponseBody = this.requestReceiptFileApi(jsonObject.toJSONString());
                    List receiptFileInfos = receiptFileListResponseBody.getFiles();
                    if (receiptFileInfos.size() <= 0) continue;
                    ReceiptFileInfo receiptFileInfo = (ReceiptFileInfo)receiptFileInfos.get(0);
                    filePath = path;
                    message.append("MD5:").append(receiptFileInfo.getMD5());
                }
                this.getView().showMessage(message.toString(), filePath, MessageTypes.Default);
                args.setCancel(true);
            }
            catch (Throwable e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6MD5\u503c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"BankLoginProxyLeftTreePlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), e.getMessage()));
                args.setCancel(true);
            }
            finally {
                EBContext.destroy();
            }
        }
        if ("search".equals(operateKey)) {
            IListView iListView = (IListView)this.getView();
            iListView.refresh();
        }
        if ("download".equals(operateKey) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            try {
                String bankLoginID = this.getBankLoginID();
                String bankVersionID = this.getBankVersionID();
                EBContext ebContext = EBContext.builder().bankLoginID(bankLoginID).bankVersionID(bankVersionID).customID(RequestContext.get().getTenantId()).build();
                EBContext.setContext((EBContext)ebContext);
                EBContext.initParameter();
                for (ListSelectedRow selectedRow : listSelectedRowCollection) {
                    String fileName = selectedRow.getName();
                    String path = selectedRow.getNumber();
                    String parentPath = path.replace(fileName, "");
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("type", (Object)"listMD5ByPath");
                    jsonObject.put("path", (Object)parentPath);
                    jsonObject.put("name", (Object)fileName);
                    ReceiptFileListResponseBody receiptFileListResponseBody = this.requestReceiptFileApi(jsonObject.toJSONString());
                    List receiptFileInfos = receiptFileListResponseBody.getFiles();
                    if (receiptFileInfos.size() <= 0) continue;
                    ReceiptFileInfo receiptFileInfo = (ReceiptFileInfo)receiptFileInfos.get(0);
                    String size = receiptFileInfo.getSize();
                    if (Long.parseLong(size) > (long)(1024 * this.getFileMaxLength())) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6587\u4ef6\u5927\u4e8e100M,\u4e0d\u652f\u6301\u5728\u7ebf\u4e0b\u8f7d\uff0c\u8bf7\u5230%s\u670d\u52a1\u5668\u5bf9\u5e94\u76ee\u5f55\u4e0b\u67e5\u770b\u3002", (String)"BankLoginProxyLeftTreePlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), this.getIp()));
                        args.setCancel(true);
                        return;
                    }
                    String savePath = FileStorageUtil.getFileBatchBakPathByTransDate((String)bankVersionID, (String)"sftp");
                    File receiptFile = FileCommonUtils.getFileByPath((String)(savePath + File.separator + fileName));
                    boolean isDelete = true;
                    if (receiptFile.exists()) {
                        isDelete = receiptFile.delete();
                    }
                    if (!isDelete) continue;
                    BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil("", LocalDate.now());
                    bankReceiptApiUtil.downloadReceiptFileWithPath(parentPath, fileName, savePath);
                    try {
                        byte[] bytes = Files.readAllBytes(FileCommonUtils.getFileByPath((String)(savePath + File.separator + fileName)).toPath());
                        TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
                        String url = tfc.saveAsUrl(fileName, bytes, 120);
                        this.getView().download(url);
                        FileCommonUtils.getFileByPath((String)(savePath + File.separator + fileName)).delete();
                    }
                    catch (Throwable e) {
                        logger.monitorError("ebg#download#receipt#error" + e.getMessage(), e);
                        this.getView().showErrorNotification(kd.ebg.egf.common.utils.string.StringUtils.norm((String)String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u4ece\u4ee3\u7406\u7a0b\u5e8f\u4e0b\u8f7d\u6210\u529f\uff0c\u8f6c\u6362\u4e3a\u5e73\u53f0\u7684\u4e0b\u8f7d\u94fe\u63a5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"BankLoginProxyLeftTreePlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[]{e.getMessage()}), new Object[0])));
                        args.setCancel(true);
                        EBContext.destroy();
                        return;
                    }
                }
                args.setCancel(true);
            }
            catch (Throwable e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"BankLoginProxyLeftTreePlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), e.getMessage()));
                args.setCancel(true);
            }
            finally {
                EBContext.destroy();
            }
        }
    }

    private int getFileMaxLength() {
        String fileMaxSize = ConfigurationUtil.getString((String)"receipt_file_download_max_size", (String)"100");
        return Integer.parseInt(fileMaxSize);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
    }

    public void beforeBuildTreeNode(BeforeBuildTreeNodeEvent e) {
        super.beforeBuildTreeNode(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.setMulti(false);
        TreeNode root = this.buildRootNode();
        String parentPath = root.getText();
        List<TreeNode> childNodes = this.loadChildNode(root.getId(), parentPath);
        for (TreeNode node1 : childNodes) {
            this.getView().getPageCache().put(node1.getId(), node1.getLongText());
        }
        root.setChildren(childNodes);
        treeView.addNode(root);
        if (childNodes.size() > 0) {
            treeView.expand(root.getId());
        }
        treeView.setRootVisible(false);
        treeView.setDraggable(false);
        treeView.setDroppable(false);
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        String nodeId = (String)arg0.getNodeId();
        TreeNode node = this.getTreeNodeById(nodeId);
        if (node != null) {
            String parentPath = node.getText();
            List<TreeNode> childNodes = this.loadChildNode(nodeId, parentPath);
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            for (TreeNode node1 : childNodes) {
                this.getView().getPageCache().put(node1.getId(), node1.getLongText());
                this.getView().getPageCache().put(node1.getLongText(), node1.getId());
            }
            treeView.addNodes(childNodes);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getView().getPageCache().put(SELECT_ID, (String)evt.getNodeId());
    }

    public TreeNode getTreeNodeById(String nodeId) {
        if (Objects.equals(nodeId, ROOT_ID)) {
            return this.buildRootNode();
        }
        String value = this.getView().getPageCache().get(nodeId);
        if (StringUtils.isNotEmpty((String)value)) {
            return new TreeNode("", nodeId, value);
        }
        return null;
    }

    public TreeNode buildRootNode() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        TreeNode treeNodes = ((TreeListView)((ListView)treeView.getView()).getTreeListView()).getRoot();
        TreeNode node = new TreeNode(treeNodes.getId(), ROOT_ID, this.getRootPath());
        treeNodes.setChildren((List)Lists.newArrayList((Object[])new TreeNode[]{node}));
        this.getView().getPageCache().put(ROOT_ID, this.getRootPath());
        return node;
    }

    public String getRootPath() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String path = (String)paramMap.get(ROOT_PATH_KEY);
        if (!paramMap.containsKey(ROOT_PATH_KEY)) {
            return ROOT_PATH;
        }
        return path;
    }

    public String getBankVersionID() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey(BANK_KEY)) {
            return "";
        }
        String path = (String)paramMap.get(BANK_KEY);
        return path;
    }

    public String getIp() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey("front_proxy_ip")) {
            return "";
        }
        String path = (String)paramMap.get("front_proxy_ip");
        return path;
    }

    public String getPort() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey("front_proxy_port")) {
            return "";
        }
        String path = (String)paramMap.get("front_proxy_port");
        return path;
    }

    public String getBankLoginID() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey(BANK_KEY)) {
            return "";
        }
        String path = (String)paramMap.get(BANK_LOGIN_KEY);
        return path;
    }

    private List<TreeNode> loadChildNode(String parentId, String parentPath) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(1);
        List<ReceiptFileInfo> paths = this.getPathByParentPath(parentPath);
        if (!paths.isEmpty()) {
            for (int i = 0; i < paths.size(); ++i) {
                ReceiptFileInfo receiptFileInfo = paths.get(i);
                String path = receiptFileInfo.getFileName();
                String id1 = parentId + i;
                TreeNode node1 = new TreeNode(parentId, id1, path);
                if (Objects.equals(parentPath, ROOT_PATH)) {
                    node1.setLongText(ROOT_PATH + path);
                } else {
                    node1.setLongText(parentPath + ROOT_PATH + path);
                }
                node1.setChildren(new ArrayList(1));
                childNodes.add(node1);
            }
        }
        return childNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReceiptFileInfo> getPathByParentPath(String parentPath) {
        String bankLoginID = this.getBankLoginID();
        String bankVersionID = this.getBankVersionID();
        ArrayList<ReceiptFileInfo> paths = new ArrayList<ReceiptFileInfo>(1);
        try {
            EBContext ebContext = EBContext.builder().bankLoginID(bankLoginID).bankVersionID(bankVersionID).customID(RequestContext.get().getTenantId()).build();
            EBContext.setContext((EBContext)ebContext);
            EBContext.initParameter();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)"listByPath");
            jsonObject.put("path", (Object)parentPath);
            jsonObject.put("fileType", (Object)"path");
            ReceiptFileListResponseBody receiptFileListResponseBody = this.requestReceiptFileApi(jsonObject.toJSONString());
            List receiptFileInfos = receiptFileListResponseBody.getFiles();
            if (receiptFileInfos.size() > 0) {
                for (ReceiptFileInfo receiptFileInfo : receiptFileInfos) {
                    paths.add(receiptFileInfo);
                }
            }
        }
        catch (Throwable e) {
            logger.monitorError("getFileListByParentPath error" + e.getMessage(), e);
        }
        finally {
            EBContext.destroy();
        }
        return paths;
    }

    public ReceiptFileListResponseBody requestReceiptFileApi(String jsonStr) {
        HashMap runningParam = Maps.newHashMapWithExpectedSize((int)2);
        runningParam.put("front_proxy_ip", this.getIp());
        runningParam.put("front_proxy_port", this.getPort());
        EBContext.getContext().setRunningParams((Map)runningParam);
        EBContext.getContext().setCharsetName("UTF-8");
        BankFrontProxyRequestImpl bankFrontProxyRequest = new BankFrontProxyRequestImpl();
        BankReceiptRequest request = BankReceiptRequest.builder().requestStr(jsonStr).build();
        BankReceiptResponseEB receiptResponseEB = bankFrontProxyRequest.doBiz(request);
        String response = (String)receiptResponseEB.getData();
        ReceiptFileListResponseBody receiptFileListResponseBody = (ReceiptFileListResponseBody)JSONObject.parseObject((String)response, ReceiptFileListResponseBody.class);
        if (Objects.equals(receiptFileListResponseBody.getCode(), "001")) {
            String message = receiptFileListResponseBody.getMessage();
            throw new ReceiptException(message);
        }
        return receiptFileListResponseBody;
    }

    public List<ReceiptFileInfo> getFileListByParentPath(String parentPath, Integer pageNo, Integer pageSize) {
        return this.getFileListByParentPath(parentPath, pageNo, pageSize, null, null);
    }

    public List<ReceiptFileInfo> filterFileByTypeAndName(String parentPath, Integer pageNo, Integer pageSize, Integer filterType, String filterName) {
        return this.getFileListByParentPath(parentPath, pageNo, pageSize, filterType, filterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReceiptFileInfo> getFileListByParentPath(String parentPath, Integer pageNo, Integer pageSize, Integer filterType, String filterName) {
        String bankLoginID = this.getBankLoginID();
        String bankVersionID = this.getBankVersionID();
        ArrayList<ReceiptFileInfo> paths = new ArrayList<ReceiptFileInfo>(1);
        try {
            EBContext ebContext = EBContext.builder().bankLoginID(bankLoginID).bankVersionID(bankVersionID).customID(RequestContext.get().getTenantId()).build();
            EBContext.setContext((EBContext)ebContext);
            EBContext.initParameter();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)"listByPath");
            jsonObject.put("path", (Object)parentPath);
            jsonObject.put("fileType", (Object)"file");
            if (pageSize != null && pageNo != null) {
                jsonObject.put("pageSize", (Object)pageSize);
                jsonObject.put("pageNo", (Object)pageNo);
            }
            if (filterType != null) {
                jsonObject.put("filterType", (Object)filterType);
                if (StringUtils.isNotEmpty((String)filterName)) {
                    jsonObject.put("filterName", (Object)filterName);
                }
            }
            ReceiptFileListResponseBody receiptFileListResponseBody = this.requestReceiptFileApi(jsonObject.toJSONString());
            List receiptFileInfos = receiptFileListResponseBody.getFiles();
            this.dataCount = receiptFileListResponseBody.getNum();
            if ((receiptFileInfos = receiptFileInfos.stream().sorted(Comparator.comparing(ReceiptFileInfo::getEditTimeLong).reversed()).collect(Collectors.toList())).size() > 0) {
                for (ReceiptFileInfo receiptFileInfo : receiptFileInfos) {
                    paths.add(receiptFileInfo);
                }
            }
        }
        catch (Throwable e) {
            logger.monitorError("getFileListByParentPath error" + e.getMessage(), e);
        }
        finally {
            EBContext.destroy();
        }
        return paths;
    }
}

