/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hxb.dc.service.receipt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.HxbDcFileParser;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.api.HxbDcReceiptDetailQuery;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadTaskService downloadTaskService;
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HxbDcFileParser dcFileParser = new HxbDcFileParser();
        ArrayList<Long> deleteIds = new ArrayList<Long>(1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            dcFileParser.setFileName(downloadListDetail.getFileName());
            if (dcFileParser.getFileSplitLength() != 6) continue;
            deleteIds.add(downloadListDetail.getId());
        }
        if (deleteIds.size() > 0) {
            this.downloadListDetailService.deleteById(deleteIds);
        }
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List receiptDetail = HxbDcReceiptDetailQuery.queryReceiptDetail((String)accNo, (LocalDate)transDate);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (String receipt : receiptDetail) {
            JSONObject jsonObject = JSONObject.parseObject((String)receipt);
            String billCode = jsonObject.getString("billCode");
            String amount = jsonObject.getString("amount");
            String creditDebitFlag = jsonObject.getString("creditDebitFlag");
            String dfAccount = jsonObject.getString("dfAccount");
            String EnFlowNo = jsonObject.getString("EnFlowNo");
            StringBuilder fileName = new StringBuilder();
            fileName.append(accNo).append("-");
            fileName.append(transDateStr).append("-");
            fileName.append(dfAccount).append("-");
            fileName.append(amount).append("-");
            fileName.append(creditDebitFlag).append("-");
            fileName.append(billCode).append("-");
            fileName.append(EnFlowNo).append(".pdf");
            String newFileName = fileName.toString();
            if (countMap.containsKey(newFileName)) {
                int count = (Integer)countMap.get(newFileName) + 1;
                countMap.put(newFileName, count);
                newFileName = newFileName + "-" + String.format("%04d", count);
            } else {
                countMap.put(newFileName, 0);
            }
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(receipt);
            detail.setFileName(newFileName);
            detail.setTransDate(task.getTransDate());
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "HXB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u534e\u590f\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

