/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hxb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.ResponseStrUtil;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class ReceiptParser {
    private static final String SEPARATOR = "#";
    private static final String CIRCLE_STR = "|";

    public static BankReceiptResponseEB parseXhj8035(BankReceiptRequest request, String responseStr) {
        int elemtIndex;
        String[] elements = EBGStringUtils.split((String)(responseStr = ResponseStrUtil.process((String)responseStr)), (String)SEPARATOR);
        if (elements == null || elements.length < 1) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"ReceiptParser_0", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]));
        }
        String responseCode = elements[0];
        if ("EL4418".equals(responseCode)) {
            return BankReceiptResponseEB.success();
        }
        if (!"000000".equals(responseCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u5931\u8d25\uff0c\u5931\u8d25\u54cd\u5e94\u7801\uff1a%s\u3002", (String)"ReceiptParser_4", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]), responseCode);
            throw new EBServiceException(errorMsg);
        }
        ArrayList<String> stringList = new ArrayList<String>(16);
        elements = responseStr.split(SEPARATOR, 3);
        String[] fourthElements = EBGStringUtils.split((String)elements[2], (String)"|#");
        String[] newElements = new String[2 + fourthElements.length];
        System.arraycopy(elements, 0, newElements, 0, 2);
        System.arraycopy(fourthElements, 0, newElements, 2, fourthElements.length);
        int total = Integer.parseInt(newElements[1]);
        if (total < 1) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u660e\u7ec6\u4e3a\u7a7a\u3002", (String)"ReceiptParser_2", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]));
        }
        int currentPage = Integer.parseInt(RequestContextUtils.getRunningParam((String)"pageKey"));
        if (total <= currentPage * 100) {
            RequestContextUtils.setRunningParam((String)"lastPageKey", (String)String.valueOf(true));
        }
        for (int i = elemtIndex = 2; i < newElements.length - 1; ++i) {
            String[] details = EBGStringUtils.split((String)newElements[i], (String)CIRCLE_STR);
            String accountNo = details[0];
            if (!Objects.equals(accountNo = accountNo.replace(SEPARATOR, ""), request.getAccNo())) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"xhj8035\u63a5\u53e3\u8fd4\u56de\u56de\u5355\u660e\u7ec6\u7684\u8d26\u53f7\u8ddf\u5b9e\u9645\u8bf7\u6c42\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6c42\u8d26\u53f7\u4e3a[%1$s],\u8fd4\u56de\u8d26\u53f7\u4e3a[%2$s]", (String)"ReceiptParser_5", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]), request.getAccNo(), accountNo));
            }
            String transDate = details[1];
            String Amount = details[2];
            String creditDebitFlag = details[3];
            String currency = details[4];
            String dfAccount = details[5];
            String dfAccName = details[6];
            String dfBankNo = details[7];
            String dfBank = details[8];
            String billType = details[9];
            String billCode = details[10];
            String PrintTimes = details[11];
            String custMemo = details[12];
            String txnComment = details[13];
            String fileID = details[14];
            String fileURL = details[15];
            String EnFlowNo = details[17];
            String transDateString = transDate.replace("-", "");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("amount", (Object)Amount);
            jsonObject.put("billCode", (Object)billCode);
            jsonObject.put("creditDebitFlag", (Object)creditDebitFlag);
            jsonObject.put("dfAccount", (Object)"e");
            jsonObject.put("EnFlowNo", (Object)EnFlowNo);
            stringList.add(jsonObject.toJSONString());
        }
        return BankReceiptResponseEB.success(stringList);
    }
}

