/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdb.ccip.service.receipt.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.cdb.ccip.service.util.CDBBankResponse;
import kd.ebg.receipt.banks.cdb.ccip.service.util.CommonPacker;
import kd.ebg.receipt.banks.cdb.ccip.service.util.CommonParser;
import kd.ebg.receipt.banks.cdb.ccip.service.util.LoginUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class BankReceiptInfoRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptInfoRequestImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        LoginUtils.getInstance().doBiz();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader((String)this.getBizCode(), (String)Sequence.genSequence(), (String)"", (String)(this.getCurrentPage().equalsIgnoreCase("0") ? "1" : this.getCurrentPage()));
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity((String)"O0220001", (String)Sequence.genSequence());
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData((Element)request, (String)"Btch_Vchr_Blg_AccNo", (String)accNo);
        JDomExtUtils.addChildCDData((Element)request, (String)"Enqr_StDt", (String)transDateStr);
        JDomExtUtils.addChildCDData((Element)request, (String)"Enqr_CODt", (String)transDateStr);
        JDomExtUtils.addChildCDData((Element)request, (String)"Mdf_Ind", (String)"0");
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        String accNo = bankReceiptRequest.getAccNo();
        responseStr = CommonParser.preParse((String)responseStr);
        logger.info("(P1CCMS001)\u56de\u5355\u8bb0\u5f55\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\uff1a" + responseStr);
        this.updatePage(responseStr);
        CDBBankResponse bankResp = CommonParser.getBankPreResponse((String)responseStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%s\u3002", (String)"BankReceiptInfoRequestImpl_0", (String)"ebg-receipt-banks-cdb-ccip", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        ArrayList<ReceiptInfo> detailInfoList = new ArrayList<ReceiptInfo>(16);
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String rcrdNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        List detaiList = response.getChildren("Hd_Grp");
        if (!"0".equals(rcrdNum)) {
            for (Element node : detaiList) {
                ReceiptInfo info = new ReceiptInfo();
                String Cmpt_TrcNo = JDomExtUtils.getChildText((Element)node, (String)"Cmpt_TrcNo");
                String VchID = JDomExtUtils.getChildText((Element)node, (String)"VchID");
                String DbtCrDrcCd = JDomExtUtils.getChildText((Element)node, (String)"DbtCrDrcCd");
                String Dep_TxnAmt = JDomExtUtils.getChildText((Element)node, (String)"Dep_TxnAmt");
                String Pym_AccNo = JDomExtUtils.getChildText((Element)node, (String)"Pym_AccNo");
                String Btch_Vchr_Blg_AccNo = JDomExtUtils.getChildText((Element)node, (String)"Btch_Vchr_Blg_AccNo");
                String oppAccNo = Objects.equals(accNo, Pym_AccNo) ? Btch_Vchr_Blg_AccNo : Pym_AccNo;
                DbtCrDrcCd = Objects.equals(PropertiesConstantsUtils.getValue((String)"CD_CREDIT"), DbtCrDrcCd) ? "1" : (Objects.equals(PropertiesConstantsUtils.getValue((String)"CD_DEBIT"), DbtCrDrcCd) ? "2" : "0");
                info.setReceiptNo(Cmpt_TrcNo);
                info.setOppAccNo(oppAccNo);
                info.setAmount(Dep_TxnAmt);
                info.setEbillKey(VchID);
                info.setExplanation(DbtCrDrcCd);
                detailInfoList.add(info);
            }
        }
        return BankReceiptResponseEB.success(detailInfoList);
    }

    public boolean updatePage(String rspStr) {
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element response = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String TOTAL_PAGE = response.getChildTextTrim("TOTAL_PAGE");
        int total_page = Integer.parseInt(TOTAL_PAGE);
        int page = Integer.parseInt(this.getCurrentPage().equalsIgnoreCase("0") ? "1" : this.getCurrentPage());
        if (page >= total_page) {
            this.setCurrentPage(page + 1);
            this.setLastPage(true);
            return true;
        }
        this.setCurrentPage(page + 1);
        this.setLastPage(false);
        return false;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "P1CCMS001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42", (String)"BankReceiptInfoRequestImpl_1", (String)"ebg-receipt-banks-cdb-ccip", (Object[])new Object[0]);
    }

    public List<ReceiptInfo> queryReceiptList(String accNo, LocalDate transDate) {
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        ArrayList<ReceiptInfo> detailInfos = new ArrayList<ReceiptInfo>(1);
        this.setCurrentPage("0");
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            BankReceiptResponseEB response = this.doBiz(request);
            List receiveItems = (List)response.getData();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }
}

