/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ljb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.ljb.dc.service.receipt.utils.CommonPacker;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;

public class BankReceiptQueryApi
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptQueryApi.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "02030201A0347";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5206\u9875\u67e5\u8be2\u8d26\u6237\u7535\u5b50\u56de\u5355\u4ea4\u6613\u660e\u7ec6", (String)"BankReceiptQueryApi_0", (String)"ebg-receipt-banks-ljb-dc", (Object[])new Object[0]);
    }

    public String pack(BankReceiptRequest request) {
        JSONObject bankRequest = CommonPacker.createRequest(Sequence.gen16Sequence(), this.getBizCode());
        bankRequest.put("acctNo", (Object)request.getAccNo());
        bankRequest.put("currency", (Object)request.getHeader().getAcnt().getCurrency());
        bankRequest.put("belongBankNo", (Object)"313261099913");
        bankRequest.put("startDate", (Object)LocalDateUtil.formatDate((LocalDate)request.getTransDate()));
        bankRequest.put("endDate", (Object)LocalDateUtil.formatDate((LocalDate)request.getTransDate()));
        return bankRequest.toJSONString();
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        JSONObject response = JSONObject.parseObject((String)responseStr);
        JSONArray dtos = response.getJSONArray("dtos");
        if (dtos.size() == 0) {
            return BankReceiptResponseEB.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u7535\u5b50\u56de\u5355\u4ea4\u6613\u660e\u7ec6\u4e3a\u7a7a\u3002", (String)"BankReceiptQueryApi_1", (String)"ebg-receipt-banks-ljb-dc", (Object[])new Object[0]));
        }
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(1);
        String accNo = request.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        for (int i = 0; i < dtos.size(); ++i) {
            try {
                String erptFileStat = dtos.getJSONObject(i).getString("erptFileStat");
                if (!Objects.equals(erptFileStat, "2")) continue;
                String erptFilePath = dtos.getJSONObject(i).getString("erptFilePath");
                String hostErptNo = dtos.getJSONObject(i).getString("hostErptNo");
                String hostSerialNo = dtos.getJSONObject(i).getString("hostSerialNo");
                String oppAcctNo = dtos.getJSONObject(i).getString("oppAcctNo");
                String crdrFlag = dtos.getJSONObject(i).getString("crdrFlag");
                String amt = dtos.getJSONObject(i).getString("amt");
                DetailInfo detailInfo = new DetailInfo();
                detailInfo.setJson(dtos.getJSONObject(i).toJSONString());
                detailInfo.setExplanation(erptFilePath);
                StringBuilder fileNameBuilder = new StringBuilder();
                fileNameBuilder.append(accNo).append("_");
                fileNameBuilder.append(transDateStr).append("_");
                fileNameBuilder.append(oppAcctNo).append("_");
                fileNameBuilder.append(amt).append("_");
                fileNameBuilder.append(hostSerialNo).append("_");
                fileNameBuilder.append(hostErptNo).append("_");
                fileNameBuilder.append(crdrFlag).append(".pdf");
                detailInfo.setReversed1(fileNameBuilder.toString());
                detailInfoList.add(detailInfo);
                continue;
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
        return BankReceiptResponseEB.success(detailInfoList);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/json");
    }
}

