/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bocom.dc.service.receipt.api;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.BocomDcCommonConfig;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.api.DownloadOneReceiptImpl;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.api.detail.HisDetailImpl;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.api.detail.TodayDetailImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListOnApiImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListOnApiImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.PROCESSING.getId()) {
            return false;
        }
        BocomDcCommonConfig bocomDcCommonConfig = (BocomDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(BocomDcCommonConfig.class, request.getBankLoginId());
        return !Objects.equals(bocomDcCommonConfig.getReceiptWayChoose(), "bank_proxy");
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        ArrayList<Object> result = new ArrayList<Object>(16);
        String accNo = bankReceiptHandleRequest.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)bankReceiptHandleRequest.getTransDate());
        LocalDate transDate = bankReceiptHandleRequest.getTransDate();
        List detailInfoList = new ArrayList(1);
        if (transDate.isEqual(LocalDate.now())) {
            TodayDetailImpl todayDetail = new TodayDetailImpl();
            detailInfoList = todayDetail.queryTransDetail(accNo, transDate, transDate);
        } else {
            HisDetailImpl hisDetail = new HisDetailImpl();
            detailInfoList = hisDetail.queryTransDetail(accNo, transDate, transDate);
        }
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        if (!detailInfoList.isEmpty()) {
            List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
            for (DownloadListDetail downloadListDetail : downloadListDetails) {
                if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
                existMap.put(downloadListDetail.getFileName(), downloadListDetail);
            }
        }
        String bakPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankReceiptHandleRequest.getBankVersionId(), (String)accNo, (String)transDateStr);
        for (DetailInfo detailInfo : detailInfoList) {
            String fileName = detailInfo.getReversed3();
            String vchNo = detailInfo.getReversed1();
            String vchSeq = detailInfo.getReversed2();
            if (!existMap.containsKey(fileName)) {
                String base64;
                DownloadOneReceiptImpl downloadOneReceipt = new DownloadOneReceiptImpl();
                HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)2);
                paramsMap.put("vchNo", vchNo);
                paramsMap.put("vchSeq", vchSeq);
                BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramsMap).build();
                BankReceiptResponseEB receiptResponseEB = downloadOneReceipt.doBiz(bankReceiptRequest);
                if (receiptResponseEB.getCode() != BankReceiptResponseEB.ResultEnum.SUCCESS.getCode() || !FileCommonUtils.base64ToFile((String)(base64 = (String)receiptResponseEB.getData()), (String)(bakPath + File.separator + fileName))) continue;
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileName(fileName);
                downloadListDetail.setFileLink(fileName);
                result.add(downloadListDetail);
                continue;
            }
            result.add(existMap.get(fileName));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListOnApiImpl_0", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BOCOM_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return null;
    }
}

