/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bocom.dc.service.receipt.api;

import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.api.utils.BOCOM_DC_Packer;
import kd.ebg.receipt.banks.bocom.dc.service.receipt.api.utils.BOCOM_DC_Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import org.jdom2.Element;

public class DownloadOneReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "QT0001";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        String transDateStr = bankReceiptRequest.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        Element root = BOCOM_DC_Packer.packRoot(this.getBizCode());
        Map paramsMap = bankReceiptRequest.getParamsMap();
        String vchNo = (String)paramsMap.get("vchNo");
        String vchSeq = (String)paramsMap.get("vchSeq");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cusAc", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"acDate", (String)transDateStr);
        JDomUtils.addChild((Element)body, (String)"vchNo", (String)vchNo);
        JDomUtils.addChild((Element)body, (String)"vchSeq", (String)vchSeq);
        JDomUtils.addChild((Element)body, (String)"tranType", (String)"0");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u884cQT0001\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de \uff1a%1$s\u3002", (String)"DownloadOneReceiptImpl_0", (String)"ebg-receipt-banks-bocom-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = root.getChild("body");
        String fileContext = JDomUtils.getChildTextNotNull((Element)body, (String)"bytes");
        if (EBGStringUtils.isNotEmpty((String)fileContext)) {
            return BankReceiptResponseEB.success((Object)fileContext);
        }
        return BankReceiptResponseEB.fail();
    }
}

