/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.IReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.business.receipt.utils.AccessUtils;
import kd.ebg.receipt.business.receipt.utils.ReceiptConvert;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptRequest;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptResponse;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.slf4j.MDC;

public class ReceiptMethod
implements EBServiceMethod<QueryReceiptRequest, QueryReceiptResponse> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptMethod.class);
    private BankAcntRepository bankAcntRepository;

    public QueryReceiptResponse executeClientRequest(QueryReceiptRequest request, EBContext context) {
        AccessUtils.checkQueryAllowed((EBContext)context);
        if ("receiptAccount".equals(request.getHeader().getSubBizType())) {
            this.bankAcntRepository = BankAcntRepository.getInstance();
            String customId = request.getHeader().getCustomId();
            String bankVersionId = request.getExtData();
            ArrayList<Acnt> acntList = new ArrayList<Acnt>(16);
            List bankAcntList = this.bankAcntRepository.findByCustomIDAndBankVersionIdAndHasReceipt(customId, bankVersionId, true);
            for (BankAcnt bankAcnt : bankAcntList) {
                if (bankAcnt.getHasReceipt() == null || !bankAcnt.getHasReceipt().booleanValue()) continue;
                Acnt acnt = new Acnt();
                acnt.setAccNo(bankAcnt.getAccNo());
                acnt.setAccName(bankAcnt.getAccName());
                acnt.setBankName(bankAcnt.getBankName());
                acnt.setBankAddress(bankAcnt.getBankAddress());
                acnt.setAreaCode(bankAcnt.getAreaCode());
                acnt.setAccDept(bankAcnt.getAccDept());
                acnt.setCountry(bankAcnt.getCountry());
                acnt.setProvince(bankAcnt.getProvince());
                acnt.setCity(bankAcnt.getCity());
                acnt.setSwiftCode(bankAcnt.getSwiftCode());
                acnt.setCurrency(bankAcnt.getCurrency());
                acnt.setBankVersionId(bankAcnt.getBankVersionId());
                acnt.setBankLoginId(bankAcnt.getBankLoginId());
                acnt.setBankShortName(bankAcnt.getBankShortName());
                acntList.add(acnt);
            }
            ReceiptAcnt receiptAcnt = new ReceiptAcnt();
            receiptAcnt.setStatus("success");
            receiptAcnt.setData(acntList);
            QueryReceiptResponse response = new QueryReceiptResponse();
            response.setExtData(JSON.toJSONString((Object)receiptAcnt));
            return response;
        }
        ReceiptRequest receiptRequest = ReceiptConvert.convert((QueryReceiptRequest)request);
        String startDateStr = request.getBody().getStartDate();
        String endDateStr = request.getBody().getEndDate();
        LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        ObjectPropertyService objectPropertyService = ObjectPropertyService.getInstance();
        String bankVersionID = context.getBankVersionID();
        String detailSerachDateStr = objectPropertyService.getBankSearchDetailDate(bankVersionID);
        String accnoSearchLimit = objectPropertyService.getAccnoSearchLimit(receiptRequest.getAccNo());
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        boolean limitQuery = false;
        ObjectProperties objectProperties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("receipt_detail_query_limit", "ebg", "common_business");
        if (objectProperties != null && "on".equalsIgnoreCase(objectProperties.getAttrValue())) {
            limitQuery = true;
        }
        if (limitQuery && StringUtils.isNotEmpty((String)detailSerachDateStr) || StringUtils.isNotEmpty((String)detailSerachDateStr) && Objects.equals(accnoSearchLimit, "false")) {
            LocalDate detailSearchDate = LocalDate.parse(detailSerachDateStr.replace("-", ""), DateTimeFormatter.BASIC_ISO_DATE);
            if (endDate.isBefore(detailSearchDate = detailSearchDate.minusDays(1L))) {
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u5728\u9650\u5236\u67e5\u8be2\u65e5\u671f[%s]\u4e4b\u524d\u3002", (String)"ReceiptMethod_2", (String)"ebg-receipt-business", (Object[])new Object[0]), detailSerachDateStr));
            }
            if (startDate.isBefore(detailSearchDate)) {
                startDate = detailSearchDate;
                receiptRequest.setStartDate(startDate);
                logger.info("\u5f00\u59cb\u65e5\u671f\u5728\u9650\u5236\u65e5\u671f{}\u4e4b\u524d\uff0c\u4fee\u6539\u5f00\u59cb\u65e5\u671f\u4e3a\u9650\u5236\u65e5\u671f{}", new Object[]{detailSerachDateStr, detailSerachDateStr});
            }
        }
        ReceiptResponseEB response = null;
        EBContext.initParameter();
        FEPAccess access = null;
        try {
            IReceipt receiptImpl = (IReceipt)BankBundleManager.getInstance().getImpl(context.getBankVersionID(), IReceipt.class, (Object)receiptRequest);
            if (receiptImpl.needLock()) {
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankVersionID());
                AccessUtils.checkQueryAllowed((EBContext)context);
            }
            response = receiptImpl.queryReceipt(receiptRequest);
        }
        catch (Exception e) {
            String errorMsp = e.getMessage();
            if (StringUtils.isNotEmpty((String)errorMsp) && errorMsp.contains("bankVersionID\uff1a")) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8be5\u8d26\u6237\u201c%1$s\u201d\u5bf9\u5e94\u7684\u94f6\u884c\u7248\u672c\u201c%2$s\u201d\u5c1a\u672a\u652f\u6301\u7535\u5b50\u56de\u5355\u529f\u80fd\u3002", (String)"ReceiptMethod_1", (String)"ebg-receipt-business", (Object[])new Object[0]), receiptRequest.getAccNo(), bankVersionID));
            }
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        finally {
            FEPAccessUtil.release(access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
        }
        return ReceiptConvert.convert((ReceiptResponseEB)response);
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "receipt";
    }

    public static class ReceiptAcnt {
        private String status;
        private List data;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public List getData() {
            return this.data;
        }

        public void setData(List data) {
            this.data = data;
        }
    }

    public static class Acnt {
        private String accNo;
        private String accName;
        private String bankName;
        private String bankAddress;
        private String areaCode;
        private String accDept;
        private String country;
        private String province;
        private String city;
        private String swiftCode;
        private String currency;
        private String bankVersionId;
        private String bankLoginId;
        private String bankShortName;

        public String getAccNo() {
            return this.accNo;
        }

        public void setAccNo(String accNo) {
            this.accNo = accNo;
        }

        public String getAccName() {
            return this.accName;
        }

        public void setAccName(String accName) {
            this.accName = accName;
        }

        public String getBankName() {
            return this.bankName;
        }

        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        public String getBankAddress() {
            return this.bankAddress;
        }

        public void setBankAddress(String bankAddress) {
            this.bankAddress = bankAddress;
        }

        public String getAreaCode() {
            return this.areaCode;
        }

        public void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        public String getAccDept() {
            return this.accDept;
        }

        public void setAccDept(String accDept) {
            this.accDept = accDept;
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getProvince() {
            return this.province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getSwiftCode() {
            return this.swiftCode;
        }

        public void setSwiftCode(String swiftCode) {
            this.swiftCode = swiftCode;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public String getBankVersionId() {
            return this.bankVersionId;
        }

        public void setBankVersionId(String bankVersionId) {
            this.bankVersionId = bankVersionId;
        }

        public String getBankLoginId() {
            return this.bankLoginId;
        }

        public void setBankLoginId(String bankLoginId) {
            this.bankLoginId = bankLoginId;
        }

        public String getBankShortName() {
            return this.bankShortName;
        }

        public void setBankShortName(String bankShortName) {
            this.bankShortName = bankShortName;
        }
    }
}

