/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.handler;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.framework.EBThreadPools;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.framework.TaskFactory;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.BankVersion;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class IntegrityHandler
extends ScheduleHanlder {
    EBGLogger logger = EBGLogger.getInstance().getLogger(IntegrityHandler.class);
    private BankLoginService bankLoginService;
    private BankVersionService bankVersionService;
    private BankAcntService bankAcntService;
    private DownloadTaskService downloadTaskService;

    public IntegrityHandler(String name) {
        super(name);
    }

    @Override
    public boolean preJob() {
        this.bankLoginService = BankLoginService.getInstance();
        this.bankVersionService = BankVersionService.getInstance();
        this.bankAcntService = BankAcntService.getInstance();
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        String customId = RequestContext.get().getTenantId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).logBizSeqID(Sequence.genSequence()).logRequestSeqID(Sequence.genSequence()).bizName("receipt").build());
        return true;
    }

    @Override
    public boolean afterJob() {
        EBContext.destroy();
        return true;
    }

    @Override
    public void subProcess() {
        this.MDC_Schedule();
        this.logger.info("\u5b8c\u6574\u5ea6\u68c0\u67e5\u5904\u7406\u5f00\u59cb");
        BankBundleManager bankBundleManager = BankBundleManager.getInstance();
        String customId = RequestContext.get().getTenantId();
        List<BankListEntity> bankListEntities = super.getBankListEntities();
        if (bankListEntities.size() == 0) {
            this.logger.info("\u5339\u914d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u542f\u7528\u7684\u94f6\u884c\u5217\u8868\u4e3a\u7a7a", (Object)customId);
            return;
        }
        List<BankLogin> bankLoginList = super.getBankLoginList();
        if (bankLoginList.size() == 0) {
            this.logger.info("\u5339\u914d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", (Object)customId);
            return;
        }
        HashMap allBankLoginMap = Maps.newHashMapWithExpectedSize((int)bankLoginList.size());
        for (BankLogin bankLogin : bankLoginList) {
            Set<String> bankLoginSet = new HashSet<String>();
            if (allBankLoginMap.containsKey(bankLogin.getBankVersionId())) {
                bankLoginSet = (Set)allBankLoginMap.get(bankLogin.getBankVersionId());
            }
            bankLoginSet.add(bankLogin.getKey().getBankLoginId());
            allBankLoginMap.put(bankLogin.getBankVersionId(), bankLoginSet);
        }
        for (BankListEntity bankListEntity : bankListEntities) {
            String bankVersionId = bankListEntity.getNumber();
            if (!this.isNeedExecuteOfBank(bankVersionId)) continue;
            String enable = bankListEntity.getEnable();
            BankVersion versionInfo = bankBundleManager.getBankVersionInfo(bankVersionId);
            if (versionInfo == null) continue;
            if (Objects.equals(enable, "0")) {
                this.logger.info("\u5339\u914d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u542f\u7528\u8be5\u94f6\u884c-{}", new Object[]{customId, bankVersionId});
                continue;
            }
            if (!allBankLoginMap.containsKey(bankVersionId)) {
                this.logger.info("\u5339\u914d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId});
                continue;
            }
            Set bankLoginSet = (Set)allBankLoginMap.get(bankVersionId);
            this.logger.info("\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u4e00\u5171\u914d\u7f6e\u4e86{}\u4e2a\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId, bankLoginSet.size()});
            for (String bankLoginId : bankLoginSet) {
                List<Object> bankAcntList = super.getAcntsListByBankLogin(bankVersionId, bankLoginId);
                if ((bankAcntList = bankAcntList.stream().filter(item -> Objects.equals(RequestContext.get().getTenantId(), item.getCustomID())).collect(Collectors.toList())).size() == 0) {
                    this.logger.info("\u5339\u914d\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-{}-\u4e0d\u5b58\u5728\u94f6\u884c\u56de\u5355\u8d26\u6237", new Object[]{customId, bankVersionId, bankLoginId});
                    continue;
                }
                List<DownloadListTask> downloadListTasks = super.getDownloadListTasksOfIntegrity(bankVersionId, bankLoginId, bankAcntList);
                if (downloadListTasks.size() == 0) continue;
                for (DownloadListTask downloadListTask : downloadListTasks) {
                    ReceiptHandlerRequest receiptRequest = new ReceiptHandlerRequest();
                    receiptRequest.setBankVersion(bankVersionId);
                    receiptRequest.setBatchSeqId(downloadListTask.getBatchNo());
                    receiptRequest.setTransDate(LocalDateUtil.formatDate((LocalDate)downloadListTask.getTransDate()));
                    receiptRequest.setType(this.name);
                    receiptRequest.setBankLoginId(bankLoginId);
                    receiptRequest.setCustomId(downloadListTask.getCustomNo());
                    receiptRequest.setTaskId(downloadListTask.getId());
                    receiptRequest.setAccNo(downloadListTask.getAccNo());
                    receiptRequest.setTransDate(LocalDateUtil.formatDate((LocalDate)downloadListTask.getTransDate()));
                    TaskActuator task = TaskFactory.getTask((ReceiptHandlerRequest)receiptRequest);
                    EBThreadPools.getThreadPool(this.name, bankLoginId, customId).submit((Callable)task);
                }
            }
        }
        this.logger.info("\u91cd\u65b0\u4e0b\u8f7d\u5904\u7406\u5b8c\u6210");
    }
}

