/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.handler;

import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.ConfigurationUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.utils.ErrorHandUtils;
import kd.ebg.receipt.common.constant.DetailDownloadStatusEnum;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.constant.defect.ReceiptDefectTypeEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.BankVersion;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.repository.DetailInfoRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class TaskStatusHandler
extends ScheduleHanlder {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TaskStatusHandler.class);
    private int redoMaxNum = 3;
    private DownloadTaskService downloadTaskService;
    private BankLoginService bankLoginService;
    private BankVersionService bankVersionService;
    private DownloadListDetailService detailService;
    private SingleNodeIDGetter singleNodeIDGetter;
    private BankAcntService bankAcntService;
    private EBCReceiptInfoJsonService ebcReceiptInfoJsonService;
    private DetailInfoRepository detailInfoRepository;
    private DownloadListDetailService downloadListDetailService;

    public TaskStatusHandler(String name) {
        super(name);
    }

    @Override
    public boolean preJob() {
        this.redoMaxNum = RequestContextUtils.getRetryReceiptTaskNum();
        try {
            String redoNum = ConfigurationUtil.getString((String)"receipt.redo");
            if (!EBGStringUtils.isEmpty((String)redoNum)) {
                this.redoMaxNum = Integer.parseInt(redoNum);
                if (this.redoMaxNum < 1) {
                    this.redoMaxNum = 3;
                }
            }
        }
        catch (Exception e) {
            this.redoMaxNum = 3;
        }
        this.bankLoginService = BankLoginService.getInstance();
        this.bankVersionService = BankVersionService.getInstance();
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        this.detailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.singleNodeIDGetter = (SingleNodeIDGetter)SpringContextUtil.getBean(SingleNodeIDGetter.class);
        this.bankAcntService = BankAcntService.getInstance();
        this.ebcReceiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
        this.detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        String customId = RequestContext.get().getTenantId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).logBizSeqID(Sequence.genSequence()).logRequestSeqID(Sequence.genSequence()).bizName("receipt").build());
        return true;
    }

    @Override
    public boolean afterJob() {
        EBContext.destroy();
        return true;
    }

    @Override
    public void subProcess() {
        this.MDC_Schedule();
        BankBundleManager bankBundleManager = BankBundleManager.getInstance();
        String customId = RequestContext.get().getTenantId();
        this.updateProcessingTask();
        List<BankListEntity> bankListEntities = super.getBankListEntities();
        if (bankListEntities.size() == 0) {
            this.logger.info("\u56de\u5355\u72b6\u6001\u4fee\u6539\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u542f\u7528\u7684\u94f6\u884c\u5217\u8868\u4e3a\u7a7a", (Object)customId);
            return;
        }
        List<BankLogin> bankLoginList = super.getBankLoginList();
        if (bankLoginList.size() == 0) {
            this.logger.info("\u56de\u5355\u72b6\u6001\u4fee\u6539\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", (Object)customId);
            return;
        }
        HashMap allBankLoginMap = Maps.newHashMapWithExpectedSize((int)16);
        for (BankLogin bankLogin : bankLoginList) {
            Set<String> bankLoginSet = new HashSet<String>();
            if (allBankLoginMap.containsKey(bankLogin.getBankVersionId())) {
                bankLoginSet = (Set)allBankLoginMap.get(bankLogin.getBankVersionId());
            }
            bankLoginSet.add(bankLogin.getKey().getBankLoginId());
            allBankLoginMap.put(bankLogin.getBankVersionId(), bankLoginSet);
        }
        for (BankListEntity bankListEntity : bankListEntities) {
            String bankVersionId = bankListEntity.getNumber();
            if (!this.isNeedExecuteOfBank(bankVersionId)) continue;
            String enable = bankListEntity.getEnable();
            BankVersion versionInfo = bankBundleManager.getBankVersionInfo(bankVersionId);
            if (versionInfo == null) continue;
            boolean isBreakRemoveTodayDetail = false;
            if (versionInfo != null) {
                isBreakRemoveTodayDetail = versionInfo.isBreakRemoveTodayDetail();
            }
            if (Objects.equals(enable, "0")) {
                this.logger.info("\u56de\u5355\u72b6\u6001\u4fee\u6539\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u672a\u542f\u7528\u8be5\u94f6\u884c-{}", new Object[]{customId, bankVersionId});
                continue;
            }
            if (!allBankLoginMap.containsKey(bankVersionId)) {
                this.logger.info("\u56de\u5355\u72b6\u6001\u4fee\u6539\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-\u672a\u914d\u7f6e\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId});
                continue;
            }
            ArrayList<Integer> statusList = new ArrayList<Integer>(16);
            statusList.add(TaskStatus.CREATE.getId());
            statusList.add(TaskStatus.COMPLETED.getId());
            statusList.add(TaskStatus.RETRYING.getId());
            statusList.add(TaskStatus.MATCHING.getId());
            statusList.add(TaskStatus.CHECKED.getId());
            List bankTaskList = this.downloadTaskService.findByCoustomIdAndStatusListAndBankVersion(customId, statusList, bankVersionId);
            Set bankLoginSet = (Set)allBankLoginMap.get(bankVersionId);
            this.logger.info("\u56de\u5355\u72b6\u6001\u4fee\u6539\u8c03\u5ea6-\u8be5\u79df\u6237{}-\u8be5\u94f6\u884c-{}-\u4e00\u5171\u914d\u7f6e\u4e86{}\u4e2a\u524d\u7f6e\u673a", new Object[]{customId, bankVersionId, bankLoginSet.size()});
            for (String bankLoginId : bankLoginSet) {
                List<Object> bankAcntList = super.getAcntsListByBankLogin(bankVersionId, bankLoginId);
                if ((bankAcntList = bankAcntList.stream().filter(item -> Objects.equals(RequestContext.get().getTenantId(), item.getCustomID())).collect(Collectors.toList())).size() == 0) {
                    this.logger.info("\u56de\u5355\u72b6\u6001\u4fee\u6539\u8c03\u5ea6-\u8be5\u79df\u6237-{}-\u8be5\u94f6\u884c-{}-{}-\u4e0d\u5b58\u5728\u94f6\u884c\u56de\u5355\u8d26\u6237", new Object[]{customId, bankVersionId, bankLoginId});
                    continue;
                }
                Map<String, String> accNoMap = bankAcntList.stream().collect(Collectors.toMap(item -> item.getAccNo(), item -> item.getAccNo()));
                List<DownloadListTask> taskList = bankTaskList.stream().filter(o -> accNoMap.containsKey(o.getAccNo()) && o.getBankLoginId().equals(bankLoginId)).collect(Collectors.toList());
                this.updateRedoTask(taskList);
            }
            LocalDate yesterday = LocalDate.now().minusDays(1L);
            List yesterdayTaskList = this.downloadTaskService.findByBankVersionIDAndTransDateAndCustomId(bankVersionId, yesterday, customId);
            this.updateRedoTask(yesterdayTaskList);
            ArrayList<Integer> twoStatusList = new ArrayList<Integer>(16);
            twoStatusList.add(TaskStatus.FINISH.getId());
            twoStatusList.add(TaskStatus.FAILED.getId());
            List todayTaskList = this.downloadTaskService.findByCoustomIdAndStatusListAndBankVersionAndTransDate(customId, twoStatusList, bankVersionId, LocalDate.now());
            this.logger.info("\u79df\u6237\u53f7\uff1a{}-\u94f6\u884c\u7248\u672c\uff1a{}-\u5f53\u65e5\u56de\u5355\u6570\u91cf\uff1a{}", new Object[]{customId, bankVersionId, todayTaskList.size()});
            boolean finalIsBreakRemoveTodayDetail = isBreakRemoveTodayDetail;
            todayTaskList.forEach(o -> {
                Long taskId;
                List downloadListDetails;
                List ids;
                o.setRedo(Integer.valueOf(0));
                o.setStatus(Integer.valueOf(TaskStatus.CREATE.getId()));
                o.setExpmsg("");
                this.downloadTaskService.update(o);
                if (!finalIsBreakRemoveTodayDetail && !(ids = (downloadListDetails = this.downloadListDetailService.selectByRefId(taskId = Long.valueOf(o.getId()))).stream().map(detail -> detail.getId()).collect(Collectors.toList())).isEmpty()) {
                    this.downloadListDetailService.deleteAll(ids);
                }
            });
        }
        this.logger.info("\u56de\u5355\u72b6\u6001\u4fee\u6539\u4efb\u52a1\u5904\u7406\u5b8c\u6210-{}", (Object)customId);
    }

    public void updateProcessingTask() {
        int retryHour = RequestContextUtils.getRetryHour();
        List onTowStepTasks = this.downloadTaskService.findByStatus(Integer.valueOf(TaskStatus.PROCESSING.getId()));
        this.logger.info("\u7b2c\u4e8c\u6b65\u72b6\u6001\u56de\u6eda--\u603b\u6761\u6570\uff1a{}", (Object)onTowStepTasks.size());
        for (Object task : onTowStepTasks) {
            long seconds;
            LocalDateTime dateTime = task.getCompleteTime();
            if (task.getCompleteTime() == null && task.getModifytime() != null) {
                dateTime = task.getModifytime();
            }
            if (dateTime == null || (seconds = Duration.between(dateTime, LocalDateTime.now()).getSeconds()) < (long)(3600 * retryHour)) continue;
            task.setStatus(Integer.valueOf(TaskStatus.CREATE.getId()));
            this.downloadTaskService.update((DownloadListTask)task);
            this.handleUploadingDetail(task.getId());
            this.clearAllCache((DownloadListTask)task);
        }
        List onThreeStepTasks = this.downloadTaskService.findByStatus(Integer.valueOf(TaskStatus.DOWNLOADING.getId()));
        this.logger.info("\u7b2c\u4e09\u6b65\u72b6\u6001\u56de\u6eda--\u603b\u6761\u6570\uff1a{}", (Object)onTowStepTasks.size());
        for (DownloadListTask task : onThreeStepTasks) {
            long seconds;
            LocalDateTime dateTime = task.getCompleteTime();
            if (task.getCompleteTime() == null && task.getModifytime() != null) {
                dateTime = task.getModifytime();
            }
            if (dateTime == null || (seconds = Duration.between(dateTime, LocalDateTime.now()).getSeconds()) < (long)(3600 * retryHour)) continue;
            task.setStatus(Integer.valueOf(TaskStatus.COMPLETED.getId()));
            this.downloadTaskService.update(task);
            this.handleUploadingDetail(task.getId());
            this.clearAllCache(task);
        }
        ArrayList<Integer> uploadStatus = new ArrayList<Integer>(2);
        uploadStatus.add(UploadStatusEnum.UPLOAD_PROCESSING.getId());
        List jobList = this.detailService.selectByUploadFlag(uploadStatus);
        jobList.forEach(o -> {
            if (o.getModifytime() == null) {
                return;
            }
            long seconds = Duration.between(o.getModifytime(), LocalDateTime.now()).getSeconds();
            if (seconds < (long)(3600 * retryHour)) {
                return;
            }
            o.setUploadRedo(0);
            o.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
            this.detailService.update(o);
        });
    }

    public void handleUploadingDetail(Long taskId) {
        List details = this.detailService.selectByRefId(taskId);
        ArrayList<DownloadListDetail> jobList = new ArrayList<DownloadListDetail>(1);
        for (DownloadListDetail downloadListDetail : details) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_PROCESSING.getId()) continue;
            jobList.add(downloadListDetail);
        }
        this.detailService.updateAll(jobList);
    }

    public void updateRedoTask(List<DownloadListTask> taskList) {
        for (DownloadListTask task : taskList) {
            String accNo = task.getAccNo();
            LocalDate yesterday = LocalDate.now().minusDays(1L);
            if (task.getTodaysFlag() == 1 && task.getTransDate().equals(yesterday)) {
                Long taskId;
                List downloadListDetails;
                List ids;
                int status = task.getStatus();
                task.setTxDetailNum(Integer.valueOf(0));
                task.setReceiptNum(Integer.valueOf(0));
                task.setStatus(Integer.valueOf(TaskStatus.CREATE.getId()));
                task.setUploadFlag(Integer.valueOf(UploadTaskStatusEnum.UN_UPLOAD.getId()));
                task.setTodaysFlag(0);
                this.downloadTaskService.update(task);
                if ((status == TaskStatus.FINISH.getId() || status == TaskStatus.FAILED.getId()) && task.getBankVersionId().equals("QLB_DC") && !(ids = (downloadListDetails = this.downloadListDetailService.selectByRefId(taskId = Long.valueOf(task.getId()))).stream().map(detail -> detail.getId()).collect(Collectors.toList())).isEmpty()) {
                    this.downloadListDetailService.deleteAll(ids);
                }
                this.clearAllCache(task);
                continue;
            }
            if (task.getRedo() < this.redoMaxNum) {
                if (task.getStatus().intValue() != TaskStatus.RETRYING.getId()) continue;
                task.setRedo(Integer.valueOf(task.getRedo() + 1));
                task.setCompleteTime(LocalDateTime.now());
                task.setUploadFlag(Integer.valueOf(UploadTaskStatusEnum.UN_UPLOAD.getId()));
                List details = this.detailService.selectByRefId(Long.valueOf(task.getId()));
                ArrayList<Long> detailIds = new ArrayList<Long>(16);
                for (DownloadListDetail detail2 : details) {
                    if (this.isNeedSkip(detail2)) continue;
                    detailIds.add(detail2.getId());
                }
                this.detailService.deleteAll(detailIds);
                this.ebcReceiptInfoJsonService.deleteByDetailIdList(detailIds);
                task.setStatus(Integer.valueOf(TaskStatus.CREATE.getId()));
                this.downloadTaskService.update(task);
                continue;
            }
            if (task.getRedo() == this.redoMaxNum && task.getStatus().intValue() != TaskStatus.FINISH.getId() && this.redoMaxNum != 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u91cd\u8bd5\u4e0b\u6b21\u8f7d\u6570\u8fbe\u5230%s\u6b21\uff0c\u8bf7\u624b\u52a8\u70b9\u51fb\u201c\u91cd\u65b0\u4e0b\u8f7d\u201d;", (String)"TaskStatusHandler_4", (String)"ebg-receipt-business", (Object[])new Object[0]), this.redoMaxNum);
                if (task.getExpmsg() != null && !task.getExpmsg().contains(msg)) {
                    String msgStr = msg + String.format(ResManager.loadKDString((String)"\u4e0a\u6b21\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"TaskStatusHandler_5", (String)"ebg-receipt-business", (Object[])new Object[0]), task.getExpmsg());
                    msgStr = msgStr.length() > 252 ? msgStr.substring(0, 252) + "..." : msgStr + "...";
                    task.setExpmsg(msgStr);
                } else if (task.getExpmsg() == null) {
                    task.setExpmsg(msg);
                }
                String customId = task.getCustomNo();
                boolean isPullDetail = ReceiptCommonAipUtil.isPullRecordByCustomIdTransDateAndAccNo((String)customId, (LocalDate)task.getTransDate(), (String)accNo);
                int txDetailNum = this.detailInfoRepository.countDetailByAccNoAndTransDate(accNo, task.getTransDate());
                task.setTxDetailNum(Integer.valueOf(txDetailNum));
                task.setDetailFlag(Integer.valueOf(isPullDetail ? DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId() : DetailDownloadStatusEnum.UN_DOWNLOAD.getId()));
                task.setRedo(Integer.valueOf(this.redoMaxNum + 1));
                task.setStatus(Integer.valueOf(TaskStatus.FAILED.getId()));
                task.setCompleteTime(LocalDateTime.now());
                String defectType = task.getDefectType();
                ErrorHandUtils.getInstance().judgeReceiptIsPushAll(task);
                if (!Objects.equals(defectType, ReceiptDefectTypeEnum.OTHER.getCode()) && Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.OTHER.getCode())) {
                    task.setDefectType(defectType);
                }
                if (txDetailNum == 0) {
                    task.setStatus(Integer.valueOf(TaskStatus.FINISH.getId()));
                    task.setDefectType(ReceiptDefectTypeEnum.FINISH.getCode());
                }
                if (Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.NULL.getCode())) {
                    this.logger.info("\u56de\u5355\u4efb\u52a1\uff1a{}-\u8d26\u53f7\uff1a{}-\u65e5\u671f\uff1a{} \u4e0b\u8f7d\u56de\u5355\u5b8c\u6210 \u5f53\u5929\u6ca1\u6709\u6d41\u6c34");
                    task.setExpmsg(ResManager.loadKDString((String)"\u5f53\u65e5\u6ca1\u6709\u4ea4\u6613\u6d41\u6c34\u3002", (String)"TaskStatusHandler_3", (String)"ebg-receipt-business", (Object[])new Object[0]));
                }
                this.downloadTaskService.update(task);
                this.clearAllCache(task);
                continue;
            }
            if (task.getRedo() == this.redoMaxNum + 1 && task.getStatus().intValue() == TaskStatus.CREATE.getId() && this.redoMaxNum != 0) {
                this.logger.info("\u83b7\u53d6\u7684\u8c03\u5ea6\u8d26\u53f7:" + accNo);
                this.logger.info("\u83b7\u53d6\u7684\u8c03\u5ea6\u65e5\u671f:" + LocalDateUtil.formatDate((LocalDate)task.getTransDate()));
                task.setRedo(Integer.valueOf(0));
                task.setStatus(Integer.valueOf(TaskStatus.CREATE.getId()));
                task.setCompleteTime(LocalDateTime.now());
                task.setUploadFlag(Integer.valueOf(UploadTaskStatusEnum.UN_UPLOAD.getId()));
                this.downloadTaskService.update(task);
                continue;
            }
            if (task.getRedo() <= this.redoMaxNum || task.getStatus().intValue() != TaskStatus.RETRYING.getId() && task.getStatus().intValue() != TaskStatus.CREATE.getId() && task.getStatus().intValue() != TaskStatus.COMPLETED.getId()) continue;
            task.setRedo(Integer.valueOf(0));
            task.setStatus(Integer.valueOf(TaskStatus.FINISH.getId()));
            task.setCompleteTime(LocalDateTime.now());
            task.setUploadFlag(Integer.valueOf(UploadTaskStatusEnum.UN_UPLOAD.getId()));
            this.downloadTaskService.update(task);
            this.clearAllCache(task);
        }
    }

    public void clearAllCache(DownloadListTask task) {
        String cacheName = task.getCustomNo() + task.getId();
        CosmicCache.delete((String)cacheName);
        String cacheName1 = String.format("checkReceiptNum-%s-%s", task.getAccNo(), LocalDateUtil.formatDate((LocalDate)task.getTransDate()));
        CosmicCache.delete((String)cacheName1);
        String cacheName2 = this.getCacheKey(task.getId());
        CosmicCache.delete((String)cacheName2);
    }

    private String getCacheKey(long taskId) {
        return "ebg_download_" + taskId + "_lock";
    }

    private boolean isNeedSkip(DownloadListDetail downloadListDetail) {
        return downloadListDetail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId() && downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId();
    }
}

