/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.atom.IReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.HandlerType;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.business.receipt.impl.task.ReceiptUploadTask;
import kd.ebg.receipt.business.receipt.utils.ErrorHandUtils;
import kd.ebg.receipt.business.receipt.utils.ReceiptConvert;
import kd.ebg.receipt.business.receipt.utils.ReceiptTaskHandleUtils;
import kd.ebg.receipt.common.constant.DetailDownloadStatusEnum;
import kd.ebg.receipt.common.constant.MatchDefectStatusEnum;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.constant.defect.ReceiptDefectTypeEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptRequest;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptRequestBody;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.log.MDCUtil;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.constant.RetryErrorEnum;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptDownLoadException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptExceptionUtil;
import kd.ebg.receipt.common.framework.receipt.parse.FileParserRegister;
import kd.ebg.receipt.common.framework.receipt.parse.api.IFileInfo;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.repository.DetailInfoRepository;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.ReceiptMatchUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.common.utils.ofd.OfdSignUtil;
import org.slf4j.MDC;

public class DownLoadTask
extends TaskActuator {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DownLoadTask.class);
    private DownloadTaskService downloadTaskService;
    private DownloadListDetailService downloadListDetailService;
    private EBCReceiptInfoJsonService ebcReceiptInfoJsonService;
    private DetailInfoRepository detailInfoRepository;

    public DownLoadTask(ReceiptHandlerRequest request) {
        super(request);
    }

    public boolean preTask() {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
        this.ebcReceiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
        this.detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        String key = this.getCacheKey(this.receiptHandlerRequest.getTaskId());
        String cache_token = CosmicCache.get((String)key);
        if (FileCommonUtils.isTestEnv()) {
            cache_token = "";
        }
        if (EBGStringUtils.isNotEmpty((String)cache_token)) {
            this.logger.monitorInfo("receipt_is_downloading:{}", new Object[]{key});
            return false;
        }
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String customId = this.receiptHandlerRequest.getCustomId();
        String batchNo = this.receiptHandlerRequest.getBatchSeqId();
        long taskId = this.receiptHandlerRequest.getTaskId();
        String transDate = this.receiptHandlerRequest.getTransDate();
        String loggerBatchNo = Sequence.gen16Sequence();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).bankLoginID(bankLoginId).bankVersionID(bankVersionId).logBizSeqID(taskId + "").bizSeqID(Sequence.gen18Sequence()).logRequestSeqID(taskId + "").bizName("receipt").loggerBatchNo(taskId + "").loggerDetailNo(loggerBatchNo).loggerBankNo(ID.genLongId() + "").build());
        String accNo = this.receiptHandlerRequest.getAccNo();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(accNo);
        EBContext.getContext().setBankAcnt(bankAcnt);
        MDC.put((String)"bankVersion", (String)bankVersionId);
        MDC.put((String)"transDate", (String)transDate);
        EBContext.initParameter();
        if (FileCommonUtils.isTestEnv()) {
            RequestContextUtils.setRunningParam((String)"timeout", (String)"3000");
        }
        MDCUtil.initMDC((EBContext)EBContext.getContext());
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u56de\u5355\u4e0b\u8f7d\u4e1a\u52a1\u5904\u7406,{}", (Object)loggerBatchNo);
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        if (downloadListTask.getStatus().intValue() == TaskStatus.CREATE.getId()) {
            this.updateTaskStatus(downloadListTask, TaskStatus.PROCESSING.getId());
        }
        if (downloadListTask.getStatus().intValue() == TaskStatus.COMPLETED.getId()) {
            this.logger.info("\u56de\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u56de\u5355\u4efb\u52a1\u524d\u7f6e\u5904\u7406-{}-{}", new Object[]{downloadListTask.getAccNo(), downloadListTask.getId()});
            this.updateTaskStatus(downloadListTask, TaskStatus.DOWNLOADING.getId());
        }
        this.logger.info("\u56de\u5355\u4e0b\u8f7d\u8c03\u5ea6-\u56de\u5355\u4efb\u52a1\u524d\u7f6e\u5904\u7406\u7ed3\u679c-{}-{}", new Object[]{downloadListTask.getAccNo(), downloadListTask.getId(), downloadListTask.getStatus()});
        CosmicCache.putIfAbsentWithExpire((String)key, (String)"download", (int)12, (TimeUnit)TimeUnit.HOURS);
        return true;
    }

    private String getCacheKey(long taskId) {
        return "ebg_download_" + taskId + "_lock";
    }

    public boolean afterTask() {
        String transDateStr = this.receiptHandlerRequest.getTransDate();
        LocalDate transDate = LocalDateUtil.parserDate((String)transDateStr);
        ReceiptCommonAipUtil.handleReceiptInfo((String)this.receiptHandlerRequest.getCustomId(), (String)this.receiptHandlerRequest.getBankVersion(), (String)this.receiptHandlerRequest.getBatchSeqId(), (LocalDate)transDate);
        MDC.remove((String)"bankVersion");
        MDC.remove((String)"type");
        EBContext.destroy();
        String key = this.getCacheKey(this.receiptHandlerRequest.getTaskId());
        CosmicCache.delete((String)key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subProcess() {
        block13: {
            String bankVersionId = this.receiptHandlerRequest.getBankVersion();
            String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
            String transDateStr = this.receiptHandlerRequest.getTransDate();
            String accNo = this.receiptHandlerRequest.getAccNo();
            long taskId = this.receiptHandlerRequest.getTaskId();
            DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
            this.logger.info("\u4e0b\u8f7d\u56de\u5355\u4efb\u52a1-taskId:{} \u8d26\u53f7\uff1a{} \u56de\u5355\u65e5\u671f\uff1a{}", new Object[]{taskId, accNo, transDateStr});
            try {
                FEPAccess access = FEPAccessUtil.access((String)bankVersionId, (String)bankLoginId);
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                if (Objects.nonNull(access)) {
                    try {
                        this.updateTaskStatus(downloadListTask, downloadListTask.getStatus());
                        this.doTask(downloadListTask);
                        break block13;
                    }
                    catch (Throwable ex) {
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        this.logger.info("\u4e0b\u8f7d\u56de\u5355\u4efb\u52a1-\u64cd\u4f5c\u5f02\u5e38\u56de\u6eda-taskId:{} \u8d26\u53f7\uff1a{} \u5904\u7406\u65f6\u95f4\uff1a{}-\u5f02\u5e38\u539f\u56e0\uff1a{}", new Object[]{taskId, accNo, transDateStr, ex.getMessage()});
                        this.logger.error("\u4e0b\u8f7d\u56de\u5355\u4efb\u52a1-\u64cd\u4f5c\u5f02\u5e38\uff1a", ex);
                        String message = ex.getMessage();
                        if (message.contains(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b9e\u73b0", (String)"DownLoadTask_0", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                            if (!EBGStringUtils.isEmpty((String)message) && message.length() > 255) {
                                message = message.substring(0, 255) + "...";
                            }
                            downloadListTask.setDefectType(ReceiptDefectTypeEnum.OTHER.getCode());
                            downloadListTask.setExpmsg(message);
                            this.updateTaskStatus(downloadListTask, TaskStatus.FAILED.getId());
                            return;
                        }
                        this.rollback(taskId, message);
                        break block13;
                    }
                    finally {
                        access.release();
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    }
                }
                throw new ReceiptException(ResManager.loadKDString((String)"\u201c\u4e0b\u8f7d\u56de\u5355\u4efb\u52a1>\u5f53\u524d\u4efb\u52a1\u201d\u83b7\u53d6\u524d\u7f6e\u673a\u9501\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"DownLoadTask_1", (String)"ebg-receipt-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                String message = e.getMessage();
                if (message.contains(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b9e\u73b0", (String)"DownLoadTask_0", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                    if (!EBGStringUtils.isEmpty((String)message) && message.length() > 255) {
                        message = message.substring(0, 255) + "...";
                    }
                    downloadListTask.setDefectType(ReceiptDefectTypeEnum.OTHER.getCode());
                    downloadListTask.setExpmsg(message);
                    this.updateTaskStatus(downloadListTask, TaskStatus.FAILED.getId());
                    return;
                }
                this.logger.info("\u4e0b\u8f7d\u56de\u5355\u4efb\u52a1-\u5f02\u5e38\u56de\u6eda-taskId:{} \u8d26\u53f7\uff1a{} \u5904\u7406\u65f6\u95f4\uff1a{}-\u5f02\u5e38\u539f\u56e0\uff1a{}", new Object[]{taskId, accNo, transDateStr, e.getMessage()});
                this.logger.error("\u4e0b\u8f7d\u56de\u5355\u4efb\u52a1-\u5f02\u5e38\u56de\u6eda\uff1a", e);
                this.rollback(taskId, message);
            }
        }
    }

    public boolean match() {
        return HandlerType.DOWNLOAD.getName().equals(this.receiptHandlerRequest.getType()) || HandlerType.TODAY_DOWNLOAD.getName().equals(this.receiptHandlerRequest.getType());
    }

    public void updateTaskStatus(DownloadListTask task, Integer status) {
        boolean isPullDetail = ReceiptCommonAipUtil.isPullRecordByCustomIdTransDateAndAccNo((String)task.getCustomNo(), (LocalDate)task.getTransDate(), (String)task.getAccNo());
        task.setDetailFlag(Integer.valueOf(isPullDetail ? DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId() : DetailDownloadStatusEnum.UN_DOWNLOAD.getId()));
        int detailCount = this.detailInfoRepository.countDetailByAccNoAndTransDate(task.getAccNo(), task.getTransDate());
        task.setTxDetailNum(Integer.valueOf(detailCount));
        if (detailCount > 0) {
            task.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId()));
        }
        task.setStatus(status);
        task.setCompleteTime(LocalDateTime.now());
        task.setTodaysFlag(task.getTransDate().equals(LocalDate.now()) ? 1 : 0);
        if (status.intValue() == TaskStatusEnum.FAILED.getId() || status.intValue() == TaskStatusEnum.FINISH.getId()) {
            String cacheName = task.getCustomNo() + task.getId();
            CosmicCache.delete((String)cacheName);
        }
        this.downloadTaskService.update(task);
    }

    public void rollback(long taskId, String message) {
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        String accNo = downloadListTask.getAccNo();
        LocalDate transDate = downloadListTask.getTransDate();
        if (!EBGStringUtils.isEmpty((String)message) && message.length() > 255) {
            message = message.substring(0, 230) + "...";
        }
        if (downloadListTask.getStatus().intValue() == TaskStatus.PROCESSING.getId()) {
            downloadListTask.setExpmsg(message);
            this.updateTaskStatus(downloadListTask, TaskStatus.CREATE.getId());
        }
        if (downloadListTask.getStatus().intValue() == TaskStatus.DOWNLOADING.getId()) {
            downloadListTask.setExpmsg(message);
            this.updateTaskStatus(downloadListTask, TaskStatus.COMPLETED.getId());
        }
    }

    public void doTask(DownloadListTask task) {
        if (!RequestContextUtils.receiptFormatIsFile() && task.getStatus().intValue() == TaskStatus.PROCESSING.getId()) {
            EBContext.getContext().setType("download");
            this.dealXmlReceiptTask(task);
            return;
        }
        if (task.getStatus().intValue() == TaskStatus.PROCESSING.getId()) {
            EBContext.getContext().setType("fetch");
            this.dealProcessingTask(task);
        }
        if (task.getStatus().intValue() == TaskStatus.DOWNLOADING.getId()) {
            EBContext.getContext().setType("download");
            this.dealDownloadingTask(task);
        }
    }

    private void dealProcessingTask(DownloadListTask task) {
        String accNo = task.getAccNo();
        String bankVersionId = task.getBankVersionId();
        String bankLoginId = task.getBankLoginId();
        LocalDate transDate = task.getTransDate();
        long taskId = task.getId();
        String customId = this.receiptHandlerRequest.getCustomId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)task.getTransDate());
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap jsonMap = Maps.newHashMapWithExpectedSize((int)1);
        BankReceiptHandleRequest receiptRequest = BankReceiptHandleRequest.builder().accNo(accNo).bankLoginId(bankLoginId).bankVersionId(bankVersionId).taskId(taskId).taskStatus(TaskStatus.PROCESSING.getId()).type(BankReceiptHandleRequest.TypeEnum.FETCH.name()).transDate(transDate).build();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        if (acnt != null) {
            String currency = acnt.getCurrency();
            String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(accNo);
            bankAcnt.setCurrency(bankCurrency);
            BankHeader bankHeader = new BankHeader();
            bankHeader.setAcnt(bankAcnt);
            bankHeader.setBankCurrency(bankCurrency);
            receiptRequest.setHeader(bankHeader);
        }
        try {
            IBankReceiptHandle iBankReceipt = RequestContextUtils.isOpenEves() ? (IBankReceiptHandle)BankBundleManager.getInstance().getImpl("EVES_DC", IBankReceiptHandle.class, (Object)receiptRequest) : (IBankReceiptHandle)BankBundleManager.getInstance().getImpl(task.getBankVersionId(), IBankReceiptHandle.class, (Object)receiptRequest);
            iBankReceipt.init(receiptRequest);
            BankReceiptHandleResponseEB receiptResponseEB = (BankReceiptHandleResponseEB)iBankReceipt.doBiz(receiptRequest);
            Map receiptParamsMap = ReceiptMatchUtils.getInstance().selectMustFiledByBankVersion(bankVersionId);
            if (receiptResponseEB.getCode() == BankReceiptHandleResponseEB.ResultEnum.SUCCESS.getCode()) {
                List details = (List)receiptResponseEB.getData();
                if (Objects.nonNull(details) && details.size() > 0) {
                    List detailList = this.downloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
                    ArrayList<Long> detailIds = new ArrayList<Long>(16);
                    ArrayList<String> fileNameList = new ArrayList<String>(16);
                    HashMap existDetailMap = Maps.newHashMapWithExpectedSize((int)8);
                    detailList.forEach(o -> existDetailMap.put(o.getFileName(), o));
                    if (detailList.size() > 0) {
                        for (DownloadListDetail detail : detailList) {
                            if (!this.isNeedSkip(detail)) {
                                detailIds.add(detail.getId());
                                existDetailMap.remove(detail.getFileName());
                                continue;
                            }
                            fileNameList.add(detail.getFileName());
                        }
                        this.downloadListDetailService.deleteAll(detailIds);
                        this.ebcReceiptInfoJsonService.deleteByDetailIdList(detailIds);
                    }
                    RequestContextUtils.setZipNameAndFileNumInTask((DownloadListTask)task);
                    ArrayList<DownloadListDetail> insertList = new ArrayList<DownloadListDetail>(details.size());
                    ArrayList<DownloadListDetail> updateList = new ArrayList<DownloadListDetail>(details.size());
                    boolean isNeedJsonSave = false;
                    for (DownloadListDetail detail : details) {
                        if (fileNameList.size() > 0 && fileNameList.contains(detail.getFileName())) {
                            String fileLink = detail.getFileLink();
                            if ((detail = (DownloadListDetail)existDetailMap.get(detail.getFileName())) != null) {
                                detail.setExpmsg("");
                                detail.setUploadExpMsg("");
                                detail.setStatus(Integer.valueOf(TaskStatus.COMPLETED.getId()));
                                if (detail.getMatchFlag().intValue() != MatchStatusEnum.SUCCESS.getId()) {
                                    detail.setMatchFlag(Integer.valueOf(MatchStatusEnum.SATRT.getId()));
                                }
                                if (detail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                                    detail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
                                }
                                detail.setCompleteTime(LocalDateTime.now());
                                detail.setFileLink(fileLink);
                                updateList.add(detail);
                                continue;
                            }
                        }
                        if (detail == null) continue;
                        detail.setMatchFlag(Integer.valueOf(MatchStatusEnum.SATRT.getId()));
                        detail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
                        detail.setUploadRedo(0);
                        detail.setExpmsg("");
                        detail.setUploadExpMsg("");
                        detail.setStatus(Integer.valueOf(TaskStatus.COMPLETED.getId()));
                        detail.setRefid(Long.valueOf(task.getId()));
                        detail.setTransDate(task.getTransDate());
                        detail.setAccNo(accNo);
                        detail.setBankLoginId(bankLoginId);
                        detail.setBankVersionId(bankVersionId);
                        detail.setCustomNo(customId);
                        if (EBGStringUtils.isNotEmpty((String)detail.getReceiptJson())) {
                            String detailNo = MatchRule.getInstance().getReceiptMatchNo(accNo, transDateStr, detail.getReceiptJson());
                            if (countMap.containsKey(detailNo)) {
                                int recount = (Integer)countMap.get(detailNo);
                                countMap.put(detailNo, ++recount);
                                detailNo = detailNo + "-" + String.format("%04d", recount);
                            } else {
                                countMap.put(detailNo, 0);
                            }
                            detail.setDetailNo(detailNo);
                            jsonMap.put(detailNo, detail.getReceiptJson());
                            this.isDefectMatchFiledValue(detail, receiptParamsMap);
                            isNeedJsonSave = true;
                        } else {
                            detail.setDetailNo(Sequence.genSequence());
                        }
                        insertList.add(detail);
                    }
                    this.downloadListDetailService.updateAll(updateList);
                    this.downloadListDetailService.saveAll(insertList);
                    if (isNeedJsonSave) {
                        List downloadListDetailList = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
                        for (DownloadListDetail downloadListDetail : downloadListDetailList) {
                            String receiptNo = downloadListDetail.getDetailNo();
                            String json = (String)jsonMap.get(receiptNo);
                            downloadListDetail.setReceiptJson(json);
                        }
                        ReceiptTaskHandleUtils.getInstance().handReceiptJsonRecord(downloadListDetailList);
                    }
                    task.setCompleteTime(LocalDateTime.now());
                    task.setRedo(Integer.valueOf(0));
                    if (iBankReceipt.isBreak()) {
                        this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
                    } else {
                        this.updateTaskStatus(task, TaskStatus.DOWNLOADING.getId());
                    }
                } else {
                    ErrorHandUtils.getInstance().judgeReceiptIsPushAll(task);
                    if (Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.NULL.getCode())) {
                        this.updateNullReceipt(task);
                        return;
                    }
                    if (this.isNeedRetryDownload(task, ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u4e0b\u8f7d\u5217\u8868\u4e3a\u7a7a\u3002", (String)"DownLoadTask_2", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                        return;
                    }
                    this.logger.info("\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002");
                    task.setRedo(Integer.valueOf(task.getRedo() + 1));
                    task.setExpmsg(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u4e0b\u8f7d\u5217\u8868\u4e3a\u7a7a\u3002", (String)"DownLoadTask_2", (String)"ebg-receipt-business", (Object[])new Object[0]));
                    this.updateTaskStatus(task, TaskStatus.RETRYING.getId());
                }
            } else {
                ErrorHandUtils.getInstance().judgeReceiptIsPushAll(task);
                if (Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.NULL.getCode())) {
                    this.updateNullReceipt(task);
                    return;
                }
                String message = receiptResponseEB.getMessage();
                task.setRedo(Integer.valueOf(task.getRedo() + 1));
                task.setExpmsg(message);
                this.updateTaskStatus(task, TaskStatus.CREATE.getId());
                this.logger.info("\u4e0b\u8f7d\u56de\u5355\u4efb\u52a1-\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff0c\u91cd\u7f6e\u72b6\u6001\u4e3a\u521b\u5efa-\u4efb\u52a1ID:{}-\u8d26\u6237:{}-\u56de\u5355\u65e5\u671f\uff1a{}-\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{taskId, accNo, transDate, message});
            }
        }
        catch (Throwable e) {
            ErrorHandUtils.getInstance().classifyByErrorInfo(e, task);
            this.logger.error("\u6267\u884c\u83b7\u53d6\u5217\u8868\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38:" + e.getMessage(), e);
            this.setExpMsg(task, e);
            if (!FileCommonUtils.isTestEnv() && Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.NULL.getCode())) {
                this.updateNullReceipt(task);
                return;
            }
            if (RetryErrorEnum.isNeedRetryByMsg((String)e.getMessage())) {
                task.setRedo(Integer.valueOf(0));
                task.setStatus(Integer.valueOf(TaskStatus.RETRYING.getId()));
                task.setCompleteTime(LocalDateTime.now());
                this.updateTaskStatus(task, TaskStatus.RETRYING.getId());
            }
            if (this.isNeedRetryDownload(task, e.getMessage())) {
                return;
            }
            task.setRedo(Integer.valueOf(task.getRedo() + 1));
            task.setStatus(Integer.valueOf(TaskStatus.CREATE.getId()));
            this.updateTaskStatus(task, TaskStatus.CREATE.getId());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dealXmlReceiptTask(DownloadListTask task) {
        String accNo = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        long taskId = task.getId();
        try {
            String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
            BankReceiptHandleResponseEB receiptResponseEB = this.getXmlReceiptByBank(accNo, transDateStr);
            if (receiptResponseEB.getCode() == BankReceiptHandleResponseEB.ResultEnum.SUCCESS.getCode()) {
                List successOfDetails = (List)receiptResponseEB.getData();
                this.logger.info("\u62a5\u6587\u56de\u5355\u4e0b\u8f7d\u8c03\u5ea6-download-{}-{}-\u4e0b\u8f7d\u5230\u7684\u56de\u5355\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, successOfDetails.size()});
                if (!Objects.nonNull(successOfDetails) || successOfDetails.size() <= 0) throw new ReceiptException(ResManager.loadKDString((String)"\u62a5\u6587\u683c\u5f0f\u56de\u5355\u4e0b\u8f7d\u8bb0\u5f55\u4e3a\u7a7a\u3002", (String)"DownLoadTask_3", (String)"ebg-receipt-business", (Object[])new Object[0]));
                List detailList = this.downloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
                ArrayList deleteDetailIds = new ArrayList(16);
                detailList.forEach(o -> deleteDetailIds.add(o.getId()));
                int saveOfDataCount = successOfDetails.size();
                ArrayList<DownloadListDetail> insertDetailList = new ArrayList<DownloadListDetail>(16);
                HashMap detailNoMap = Maps.newHashMapWithExpectedSize((int)16);
                for (DownloadListDetail listDetail : successOfDetails) {
                    listDetail = this.installXmlTaskDetailInfo(listDetail, detailNoMap, task);
                    insertDetailList.add(listDetail);
                }
                this.ebcReceiptInfoJsonService.deleteByDetailIdList(deleteDetailIds);
                this.downloadListDetailService.deleteAll(deleteDetailIds);
                this.downloadListDetailService.saveAll(insertDetailList);
                List downloadListDetailList = this.downloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
                ReceiptTaskHandleUtils.getInstance().handReceiptJsonRecord(downloadListDetailList);
                task.setExpmsg("");
                task.setRedo(Integer.valueOf(0));
                task.setReceiptNum(Integer.valueOf(saveOfDataCount));
                task.setUploadNum(Integer.valueOf(saveOfDataCount));
                task.setUploadFlag(Integer.valueOf(UploadTaskStatusEnum.UPLOAD_SUCCESS.getId()));
                task.setDefectType(ReceiptDefectTypeEnum.FINISH.getCode());
                this.updateTaskStatus(task, TaskStatus.DOWNLOADED.getId());
                this.logger.info("\u4e0b\u8f7d\u4efb\u52a1\uff1a{}-\u62a5\u6587\u56de\u5355\u4e0b\u8f7d-\u8d26\u53f7\uff1a{}-\u56de\u5355\u65e5\u671f\uff1a{}-\u56de\u5355\u8be6\u60c5-\u65b0\u589e\u8bb0\u5f55\u6761\u6570--{}", new Object[]{task.getId(), accNo, transDate, insertDetailList.size()});
                return;
            } else {
                this.logger.info("\u62a5\u6587\u56de\u5355\u4e0b\u8f7d-\u8d26\u53f7\uff1a{}-\u56de\u5355\u65e5\u671f\uff1a{}-{}-\u65e0\u56de\u5355\u8bb0\u5f55\uff0c\u8bbe\u7f6e\u91cd\u8bd5\u4e00\u6b21\u3002", new Object[]{accNo, transDate, task.getId()});
                if (this.isNeedRetryDownload(task, ResManager.loadKDString((String)"\u65e0\u56de\u5355\u8bb0\u5f55", (String)"DownLoadTask_4", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                    return;
                }
                task.setRedo(Integer.valueOf(task.getRedo() + 1));
                this.updateTaskStatus(task, TaskStatus.CREATE.getId());
            }
            return;
        }
        catch (Throwable e) {
            ErrorHandUtils.getInstance().classifyByErrorInfo(e, task);
            this.logger.error("\u62a5\u6587\u683c\u5f0f\u56de\u5355-\u56de\u5355\u4e0b\u8f7d\u8c03\u5ea6-download-\u4e0b\u8f7d\u5f02\u5e38\u3002" + e.getMessage(), e);
            this.setExpMsg(task, e);
            List details = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
            for (DownloadListDetail detail : details) {
                if (this.isNeedSkip(detail)) continue;
                detail.setExpmsg(DownLoadTask.formatException(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()), 255));
                detail.setStatus(Integer.valueOf(TaskStatus.FAILED.getId()));
                detail.setCompleteTime(LocalDateTime.now());
            }
            if (!FileCommonUtils.isTestEnv() && Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.NULL.getCode())) {
                this.updateNullReceipt(task);
                return;
            }
            if (this.isNeedRetryDownload(task, e.getMessage())) {
                return;
            }
            this.downloadListDetailService.updateAll(details);
            task.setRedo(Integer.valueOf(task.getRedo() + 1));
            this.updateTaskStatus(task, TaskStatus.CREATE.getId());
        }
    }

    public BankReceiptHandleResponseEB getXmlReceiptByBank(String accNo, String transDateStr) {
        ReceiptResponseEB receiptResponse = null;
        EBContext.initParameter();
        FEPAccess access = null;
        EBContext context = EBContext.getContext();
        QueryReceiptRequest queryReceiptRequest = new QueryReceiptRequest();
        QueryReceiptRequestBody body = new QueryReceiptRequestBody();
        body.setStartDate(transDateStr);
        body.setEndDate(transDateStr);
        queryReceiptRequest.setBody(body);
        EBHeader header = new EBHeader();
        header.setAccNo(accNo);
        header.setCustomId(context.getCustomID());
        header.setLogBizSeqID(Sequence.gen16Sequence());
        header.setBizType("receipt");
        header.setSubBizType("receipt");
        header.setClientName("SYSTEM_RECEIPT_API");
        header.setClientVersion("1.0");
        queryReceiptRequest.setHeader(header);
        ReceiptRequest receiptRequest = ReceiptConvert.convert((QueryReceiptRequest)queryReceiptRequest);
        try {
            IReceipt receiptImpl = (IReceipt)BankBundleManager.getInstance().getImpl(context.getBankVersionID(), IReceipt.class, (Object)receiptRequest);
            receiptResponse = receiptImpl.queryReceipt(receiptRequest);
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        finally {
            FEPAccessUtil.release(access);
        }
        List receiptInfos = receiptResponse.getReceiptInfos();
        ArrayList<DownloadListDetail> details = new ArrayList<DownloadListDetail>(16);
        for (ReceiptInfo receiptDetail : receiptInfos) {
            DownloadListDetail detail = new DownloadListDetail();
            if (StringUtils.isEmpty((String)receiptDetail.getReceiptNo()) && StringUtils.isEmpty((String)receiptDetail.getJson())) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u62a5\u6587\u683c\u5f0f\u7684\u56de\u5355\uff0c\u8fd4\u56de\u7684\u56de\u5355\u8bb0\u5f55json\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DownLoadTask_5", (String)"ebg-receipt-business", (Object[])new Object[0]));
            }
            detail.setAccNo(accNo);
            detail.setReceiptJson(receiptDetail.getJson());
            detail.setDetailNo(receiptDetail.getReceiptNo());
            detail.setFileName(receiptDetail.getReceiptNo());
            detail.setFileLink(receiptDetail.getReceiptNo());
            receiptDetail.setJson("");
            detail.setOfdJson(JSONObject.toJSONString((Object)receiptDetail));
            details.add(detail);
        }
        return BankReceiptHandleResponseEB.success(details);
    }

    private void dealDownloadingTask(DownloadListTask task) {
        String accNo = task.getAccNo();
        String bankVersionId = task.getBankVersionId();
        String bankLoginId = task.getBankLoginId();
        LocalDate transDate = task.getTransDate();
        long taskId = task.getId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        BankReceiptHandleRequest receiptRequest = BankReceiptHandleRequest.builder().accNo(accNo).bankLoginId(bankLoginId).bankVersionId(bankVersionId).taskId(taskId).taskStatus(TaskStatus.DOWNLOADING.getId()).type(BankReceiptHandleRequest.TypeEnum.DOWNLOAD.name()).transDate(transDate).build();
        BankAcnt bankAccInfo = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        if (bankAccInfo != null) {
            String currency = bankAccInfo.getCurrency();
            String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(accNo);
            bankAcnt.setCurrency(bankCurrency);
            BankHeader bankHeader = new BankHeader();
            bankHeader.setAcnt(bankAcnt);
            bankHeader.setBankCurrency(bankCurrency);
            receiptRequest.setHeader(bankHeader);
        }
        String expMsg = "";
        int failedCount = 0;
        try {
            Map receiptParamsMap = ReceiptMatchUtils.getInstance().selectMustFiledByBankVersion(bankVersionId);
            IBankReceiptHandle downloadHandle = RequestContextUtils.isOpenEves() ? (IBankReceiptHandle)BankBundleManager.getInstance().getImpl("EVES_DC", IBankReceiptHandle.class, (Object)receiptRequest) : (IBankReceiptHandle)BankBundleManager.getInstance().getImpl(task.getBankVersionId(), IBankReceiptHandle.class, (Object)receiptRequest);
            FileParserRegister fileParserRegister = (FileParserRegister)SpringContextUtil.getBean(FileParserRegister.class);
            IFileInfo iFileInfo = fileParserRegister.getFileInfo(bankVersionId, "xx.pdf");
            boolean isNeedHandReceiptNoOnDownload = true;
            if (iFileInfo == null) {
                isNeedHandReceiptNoOnDownload = false;
            }
            downloadHandle.init(receiptRequest);
            BankReceiptHandleResponseEB receiptResponseEB = (BankReceiptHandleResponseEB)downloadHandle.doBiz(receiptRequest);
            if (receiptResponseEB.getCode() == BankReceiptHandleResponseEB.ResultEnum.SUCCESS.getCode()) {
                ArrayList<DownloadListDetail> successOfDetails = (ArrayList<DownloadListDetail>)receiptResponseEB.getData();
                this.logger.info("\u56de\u5355\u4e0b\u8f7d\u8c03\u5ea6-download-{}-{}-\u8fd4\u56de\u7684\u56de\u5355\u7ed3\u679c\u6761\u6570\uff1a{}", new Object[]{accNo, transDate, successOfDetails.size()});
                if (Objects.nonNull(successOfDetails) && successOfDetails.size() > 0) {
                    List detailList = this.downloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
                    ArrayList zipFileIds = new ArrayList(detailList.size());
                    detailList.forEach(o -> {
                        if (o.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".zip") || o.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".rar") || o.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".gz") || o.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".tar")) {
                            zipFileIds.add(o.getId());
                        }
                    });
                    String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
                    boolean isSupportPushAll = false;
                    int saveOfDataCount = detailList.size();
                    int successOfCount = successOfDetails.size();
                    BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
                    if (Objects.equals(ftpProperties.isSupportTodayReceipt(), "true")) {
                        saveOfDataCount = successOfCount;
                    }
                    if (zipFileIds.size() > 0) {
                        saveOfDataCount = successOfCount;
                        isSupportPushAll = true;
                    }
                    RequestContextUtils.setFileNum((int)successOfDetails.size());
                    RequestContextUtils.setZipNameAndFileNumInTask((DownloadListTask)task);
                    if (saveOfDataCount == successOfCount) {
                        if (saveOfDataCount > 0) {
                            ArrayList<DownloadListDetail> checkedList = new ArrayList<DownloadListDetail>(1);
                            for (DownloadListDetail downloadListDetail : successOfDetails) {
                                if (!OfdSignUtil.checkOFDFile((String)downloadListDetail.getFileName(), (String)bakFilePath)) continue;
                                checkedList.add(downloadListDetail);
                            }
                            successOfDetails = checkedList;
                        }
                        HashMap existDetailMap = Maps.newHashMapWithExpectedSize((int)detailList.size());
                        detailList.forEach(o -> existDetailMap.put(o.getFileName(), o));
                        ArrayList<DownloadListDetail> updateDetailList = new ArrayList<DownloadListDetail>(16);
                        ArrayList<DownloadListDetail> insertDetailList = new ArrayList<DownloadListDetail>(16);
                        HashMap detailNoMap = Maps.newHashMapWithExpectedSize((int)successOfCount);
                        for (DownloadListDetail listDetail : successOfDetails) {
                            DownloadListDetail downloadListDetail;
                            String fileName = listDetail.getFileName();
                            String receiptJsonStr = listDetail.getReceiptJson();
                            if (EBGStringUtils.isNotEmpty((String)receiptJsonStr)) {
                                isNeedHandReceiptNoOnDownload = true;
                            }
                            if (StringUtils.isEmpty((String)receiptJsonStr) && isNeedHandReceiptNoOnDownload) {
                                receiptJsonStr = downloadHandle.installReceiptJson(fileName);
                                JSONObject jsonObject = JSONObject.parseObject((String)receiptJsonStr);
                                jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[2], (Object)transDateStr);
                                receiptJsonStr = jsonObject.toJSONString();
                            }
                            if ((downloadListDetail = (DownloadListDetail)existDetailMap.get(fileName)) == null) {
                                if (isNeedHandReceiptNoOnDownload) {
                                    listDetail.setReceiptJson(receiptJsonStr);
                                    this.isDefectMatchFiledValue(listDetail, receiptParamsMap);
                                }
                                listDetail = this.installTaskDetailInfo(listDetail, detailNoMap, bakFilePath, task, false, isNeedHandReceiptNoOnDownload);
                                insertDetailList.add(listDetail);
                                continue;
                            }
                            if (!this.isNeedSkip(downloadListDetail)) {
                                downloadListDetail.setReceiptJson(receiptJsonStr);
                                downloadListDetail = this.installTaskDetailInfo(downloadListDetail, detailNoMap, bakFilePath, task, false, isNeedHandReceiptNoOnDownload);
                                if (downloadListDetail.getMatchFlag().intValue() != MatchStatusEnum.SUCCESS.getId()) {
                                    downloadListDetail.setMatchFlag(Integer.valueOf(MatchStatusEnum.SATRT.getId()));
                                }
                                if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                                    downloadListDetail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
                                }
                                updateDetailList.add(downloadListDetail);
                                continue;
                            }
                            String detailNo = downloadListDetail.getDetailNo();
                            if (detailNoMap.containsKey(detailNo)) {
                                int recount = (Integer)detailNoMap.get(detailNo);
                                detailNoMap.put(detailNo, ++recount);
                                continue;
                            }
                            detailNoMap.put(detailNo, 0);
                        }
                        HashMap countMap = Maps.newHashMapWithExpectedSize((int)8);
                        MatchRule.getInstance().handleMatchNoRepeat((Map)countMap, updateDetailList);
                        MatchRule.getInstance().handleMatchNoRepeat((Map)countMap, insertDetailList);
                        this.logger.info("\u56de\u5355\u8be6\u60c5-\u65b0\u589e\u8bb0\u5f55--{}\uff0c\u66f4\u65b0\u6761\u6570\uff1a{}", new Object[]{insertDetailList.size(), updateDetailList.size()});
                        this.downloadListDetailService.updateAll(updateDetailList);
                        this.downloadListDetailService.saveAll(insertDetailList);
                        ArrayList<DownloadListDetail> listDetailsByDownload = new ArrayList<DownloadListDetail>(1);
                        listDetailsByDownload.addAll(insertDetailList);
                        listDetailsByDownload.addAll(updateDetailList);
                        List downloadListDetailList = this.downloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
                        ReceiptTaskHandleUtils.getInstance().handReceiptJsonRecordOnDownload(downloadListDetailList, listDetailsByDownload);
                        if (isSupportPushAll) {
                            this.downloadListDetailService.deleteAll(zipFileIds);
                        }
                        task.setExpmsg("");
                        task.setRedo(Integer.valueOf(0));
                        task.setReceiptNum(Integer.valueOf(saveOfDataCount));
                        task.setDefectType(ReceiptDefectTypeEnum.FINISH.getCode());
                        this.updateTaskStatus(task, TaskStatus.DOWNLOADED.getId());
                        this.upload(task);
                    } else {
                        this.logger.info("\u4e0b\u8f7d\u4efb\u52a1\uff1a" + task.getId() + "\u672a\u5b8c\u5168\u4e0b\u8f7d\u5b8c\u6bd5\uff0c\u8bbe\u7f6e\u91cd\u8bd5\u4e00\u6b21\u3002" + task.getAccNo() + "-" + task.getTransDate());
                        task.setExpmsg(String.format(ResManager.loadKDString((String)"\u5171\u8ba1%1$s\u4e2a\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c%2$s\u3002", (String)"DownLoadTask_16", (String)"ebg-receipt-business", (Object[])new Object[0]), failedCount, expMsg));
                        task.setRedo(Integer.valueOf(task.getRedo() + 1));
                        this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
                    }
                } else {
                    this.logger.info("\u56de\u5355\u4e0b\u8f7d\u8c03\u5ea6-download-\u65e0\u56de\u5355\u8bb0\u5f55-{}-{}", new Object[]{accNo, transDate});
                    ErrorHandUtils.getInstance().judgeReceiptIsPushAll(task);
                    if (Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.NULL.getCode())) {
                        this.updateNullReceipt(task);
                        return;
                    }
                    if (this.isNeedRetryDownload(task, ResManager.loadKDString((String)"\u65e0\u56de\u5355\u8bb0\u5f55", (String)"DownLoadTask_4", (String)"ebg-receipt-business", (Object[])new Object[0]))) {
                        return;
                    }
                    task.setRedo(Integer.valueOf(task.getRedo() + 1));
                    this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
                }
            } else {
                ErrorHandUtils.getInstance().judgeReceiptIsPushAll(task);
                if (Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.NULL.getCode())) {
                    this.updateNullReceipt(task);
                    return;
                }
                this.logger.info("\u56de\u5355\u4e0b\u8f7d\u8c03\u5ea6-download-\u4e0b\u8f7d\u5931\u8d25-{}-{}", new Object[]{accNo, transDate});
                String message = receiptResponseEB.getMessage();
                task.setExpmsg(message);
                task.setRedo(Integer.valueOf(task.getRedo() + 1));
                this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
                this.logger.info("\u4e0b\u8f7d\u56de\u5355\u4efb\u52a1-\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff0c\u91cd\u7f6e\u72b6\u6001\u4e3a\u9884\u5904\u7406\u5b8c\u6210-\u4efb\u52a1ID:{}-\u8d26\u6237:{}-\u65e5\u671f\uff1a{}-\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{taskId, accNo, transDate, message});
            }
        }
        catch (Throwable e) {
            this.setExpMsg(task, e);
            if (RetryErrorEnum.isNeedRetryByMsg((String)e.getMessage())) {
                task.setRedo(Integer.valueOf(0));
                task.setStatus(Integer.valueOf(TaskStatus.COMPLETED.getId()));
                task.setCompleteTime(LocalDateTime.now());
                this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
                return;
            }
            List details = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
            for (DownloadListDetail detail : details) {
                if (this.isNeedSkip(detail)) continue;
                detail.setExpmsg(ReceiptExceptionUtil.formatException((Throwable)e, (int)255));
                detail.setStatus(Integer.valueOf(TaskStatus.FAILED.getId()));
                detail.setCompleteTime(LocalDateTime.now());
            }
            ErrorHandUtils.getInstance().classifyByErrorInfo(e, task);
            this.logger.error("\u6267\u884cdownload\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38:{}" + e.getMessage(), e);
            if (!FileCommonUtils.isTestEnv() && Objects.equals(task.getDefectType(), ReceiptDefectTypeEnum.NULL.getCode())) {
                this.updateNullReceipt(task);
                return;
            }
            if (this.isNeedRetryDownload(task, e.getMessage())) {
                return;
            }
            this.downloadListDetailService.updateAll(details);
            task.setRedo(Integer.valueOf(task.getRedo() + 1));
            this.updateTaskStatus(task, TaskStatus.COMPLETED.getId());
        }
    }

    public void setExpMsg(DownloadListTask task, Throwable e) {
        if (EBGStringUtils.isEmpty((String)e.getMessage())) {
            task.setExpmsg(DownLoadTask.formatException(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()), 255));
        } else {
            task.setExpmsg(DownLoadTask.formatException(e.getMessage(), 255));
        }
    }

    private void updateNullReceipt(DownloadListTask task) {
        long taskId = task.getId();
        List details = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList deleteDetailIds = new ArrayList(16);
        details.forEach(o -> {
            if (!this.isNeedSkip((DownloadListDetail)o)) {
                deleteDetailIds.add(o.getId());
            }
        });
        this.downloadListDetailService.deleteAll(deleteDetailIds);
        task.setExpmsg(ResManager.loadKDString((String)"\u5f53\u5929\u6ca1\u6709\u4ea4\u6613\u6d41\u6c34\u3002", (String)"DownLoadTask_8", (String)"ebg-receipt-business", (Object[])new Object[0]));
        task.setRedo(Integer.valueOf(0));
        task.setReceiptNum(Integer.valueOf(0));
        task.setTxDetailNum(Integer.valueOf(0));
        boolean isPullDetail = ReceiptCommonAipUtil.isPullRecordByCustomIdTransDateAndAccNo((String)task.getCustomNo(), (LocalDate)task.getTransDate(), (String)task.getAccNo());
        task.setDetailFlag(Integer.valueOf(isPullDetail ? DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId() : DetailDownloadStatusEnum.UN_DOWNLOAD.getId()));
        task.setUploadFlag(Integer.valueOf(UploadTaskStatusEnum.UPLOAD_FAIL.getId()));
        this.updateTaskStatus(task, TaskStatus.FINISH.getId());
    }

    private boolean isNeedRetryDownload(DownloadListTask task, String message) {
        String bankVersionId = task.getBankVersionId();
        LocalDate transDate = task.getTransDate();
        String accNo = task.getAccNo();
        if (!RequestContextUtils.receiptFormatIsFile()) {
            return false;
        }
        List detailInfoList = this.detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionId, transDate, transDate);
        if (detailInfoList.size() > 0) {
            String cacheName = task.getCustomNo() + task.getId();
            String cacheValue = CosmicCache.get((String)cacheName);
            if (RequestContextUtils.isReceiptAutoRetryDownload()) {
                ReceiptSystemProperties receiptSystemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
                int retryingDay = receiptSystemProperties.getRetryingDay();
                if (StringUtils.isNotEmpty((String)cacheValue)) {
                    LocalDate lastDate = LocalDateUtil.parserDate((String)cacheValue);
                    if (lastDate.minusDays(-retryingDay).isBefore(LocalDate.now())) {
                        return false;
                    }
                } else {
                    CosmicCache.putIfAbsentWithExpire((String)cacheName, (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()), (int)((retryingDay + 1) * 24 * 60 * 60 + 3600), (TimeUnit)TimeUnit.SECONDS);
                }
                task.setExpmsg(String.format(ResManager.loadKDString((String)"\u8be5\u8d26\u53f7\u5b58\u5728\u4ea4\u6613\u6d41\u6c34\uff0c\u56de\u5355\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6b63\u5728\u91cd\u65b0\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"DownLoadTask_17", (String)"ebg-receipt-business", (Object[])new Object[0]), message));
                task.setExpmsg(DownLoadTask.formatException(task.getExpmsg(), 255));
                task.setRedo(Integer.valueOf(0));
                task.setTxDetailNum(Integer.valueOf(detailInfoList.size()));
                task.setDetailFlag(Integer.valueOf(DetailDownloadStatusEnum.DOWNLOAD_SUCCESS.getId()));
                this.updateTaskStatus(task, TaskStatus.RETRYING.getId());
                this.logger.info("\u5b58\u5728\u6d41\u6c34\uff0c\u56de\u5355\u4efb\u52a1\u81ea\u52a8\u91cd\u65b0\u4e0b\u8f7d-{}-{}-\u4ea4\u6613\u660e\u7ec6\u6570-{}", new Object[]{accNo, transDate, detailInfoList.size()});
                return true;
            }
            CosmicCache.delete((String)cacheName);
        }
        return false;
    }

    public static String formatException(String message, int length) {
        if (EBGStringUtils.isNotEmpty((String)message)) {
            if (message.length() > length) {
                message = message.substring(0, length);
            }
        } else {
            message = "";
        }
        return message;
    }

    public static String fixAccNoTo15Or19(String accNo) {
        String retAccNo = null;
        if (null != accNo) {
            String str2 = accNo.trim();
            retAccNo = str2.length() == 19 ? accNo : (str2.length() == 21 ? str2.substring(2) : DownLoadTask.getLastNString(str2, 15));
        }
        return retAccNo;
    }

    private static String getLastNString(String accNo, int count) {
        String str = accNo;
        if (accNo.length() > count) {
            int i = accNo.length() - count;
            str = accNo.substring(i);
        }
        return str;
    }

    private DownloadListDetail installXmlTaskDetailInfo(DownloadListDetail downloadListDetail, Map<String, Integer> detailNoMap, DownloadListTask task) {
        this.installTaskDetailInfo(downloadListDetail, detailNoMap, "", task, true, true);
        downloadListDetail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UPLOAD_SUCCESS.getId()));
        return downloadListDetail;
    }

    private DownloadListDetail installTaskDetailInfo(DownloadListDetail downloadListDetail, Map<String, Integer> detailNoMap, String bakFilePath, DownloadListTask task, boolean isXmlReceipt, boolean isNeedHandReceiptNoOnDownload) {
        String fixAccount = task.getAccNo();
        if (Objects.equals(task.getBankVersionId(), "ABC_DC")) {
            fixAccount = DownLoadTask.fixAccNoTo15Or19(fixAccount);
        }
        String detailNo = downloadListDetail.getDetailNo();
        if ((!isXmlReceipt || StringUtils.isEmpty((String)detailNo)) && isNeedHandReceiptNoOnDownload) {
            detailNo = MatchRule.getInstance().getReceiptMatchNo(fixAccount, LocalDateUtil.formatDate((LocalDate)task.getTransDate()), downloadListDetail.getReceiptJson());
        }
        if (EBGStringUtils.isEmpty((String)detailNo)) {
            throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u5339\u914d\u7801\u4e0d\u80fd\u4e3a\u7a7a-\u8d26\u53f7\uff1a%1$s\uff0c\u56de\u5355\u65e5\u671f\uff1a%2$s\u3002", (String)"DownLoadTask_18", (String)"ebg-receipt-business", (Object[])new Object[0]), downloadListDetail.getAccNo(), downloadListDetail.getTransDate()));
        }
        if (detailNoMap.containsKey(detailNo)) {
            int recount = detailNoMap.get(detailNo);
            detailNoMap.put(detailNo, ++recount);
            detailNo = detailNo + "-" + String.format("%04d", recount);
        } else {
            detailNoMap.put(detailNo, 0);
        }
        if (detailNo.length() > 255) {
            detailNo = detailNo.substring(0, 255);
        }
        downloadListDetail.setDetailNo(detailNo);
        downloadListDetail.setStatus(Integer.valueOf(TaskStatus.DOWNLOADED.getId()));
        downloadListDetail.setCompleteTime(LocalDateTime.now());
        downloadListDetail.setMatchFlag(Integer.valueOf(MatchStatusEnum.SATRT.getId()));
        downloadListDetail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UN_UPLOAD.getId()));
        downloadListDetail.setBankFilePath(bakFilePath + File.separator + downloadListDetail.getFileName());
        downloadListDetail.setExpmsg("");
        downloadListDetail.setQueryFlag("0");
        downloadListDetail.setUploadRedo(0);
        downloadListDetail.setUploadExpMsg("");
        downloadListDetail.setRefid(Long.valueOf(task.getId()));
        downloadListDetail.setTransDate(task.getTransDate());
        downloadListDetail.setAccNo(task.getAccNo());
        downloadListDetail.setBankLoginId(task.getBankLoginId());
        downloadListDetail.setBankVersionId(task.getBankVersionId());
        downloadListDetail.setCustomNo(task.getCustomNo());
        downloadListDetail.setRefid(Long.valueOf(task.getId()));
        return downloadListDetail;
    }

    private boolean isNeedSkip(DownloadListDetail downloadListDetail) {
        return downloadListDetail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId() && downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId();
    }

    public void upload(DownloadListTask downloadListTask) {
        String bankVersionId = downloadListTask.getBankVersionId();
        ReceiptHandlerRequest receiptRequest = new ReceiptHandlerRequest();
        receiptRequest.setBankVersion(downloadListTask.getBankVersionId());
        receiptRequest.setType(HandlerType.UPLOAD.getName());
        receiptRequest.setBankLoginId(downloadListTask.getBankLoginId());
        receiptRequest.setCustomId(downloadListTask.getCustomNo());
        receiptRequest.setAccNo(downloadListTask.getAccNo());
        receiptRequest.setTaskId(downloadListTask.getId());
        receiptRequest.setTransDate(LocalDateUtil.formatDate((LocalDate)downloadListTask.getTransDate()));
        receiptRequest.setBatchSeqId(downloadListTask.getBatchNo());
        this.logger.info("\u5c06\u4efb\u52a1ID:{}-\u94f6\u884c\u7248\u672c\uff1a{}-\u8d26\u53f7\uff1a{}-\u4e0b\u8f7d\u5b8c\u6210\u7acb\u523b\u8fdb\u884c\u6587\u4ef6\u4e0a\u4f20", new Object[]{downloadListTask.getId(), bankVersionId, downloadListTask.getAccNo()});
        ReceiptUploadTask uploadTask = new ReceiptUploadTask(receiptRequest);
        if (uploadTask.preTask()) {
            uploadTask.subProcess();
            EBContext ebContext = EBContext.getContext();
            uploadTask.afterTask();
            EBContext.setContext((EBContext)ebContext);
        }
    }

    public void isDefectMatchFiledValue(DownloadListDetail downloadListDetail, Map<String, String> receiptParamsMap) {
        ReceiptMatchUtils receiptMatchUtils = ReceiptMatchUtils.getInstance();
        String defectMsg = receiptMatchUtils.isDefectByMatchNo(downloadListDetail.getReceiptJson(), receiptParamsMap);
        if (StringUtils.isNotEmpty((String)defectMsg)) {
            downloadListDetail.setMatch_is_defect(MatchDefectStatusEnum.YES.getCode());
            downloadListDetail.setMatch_defect_desc(defectMsg);
        }
    }
}

