/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.task.reconciliation;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.entity.ReceiptHandlerRequest;
import kd.ebg.receipt.business.receipt.entity.ReconciliationHandlerType;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.framework.TaskActuator;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankReconciliationProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadTaskService;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.slf4j.MDC;

public class CreateTask
extends TaskActuator {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CreateTask.class);
    private ReconciliationDownloadTaskService reconciliationDownloadTaskService;

    public CreateTask(ReceiptHandlerRequest request) {
        super(request);
    }

    public boolean preTask() {
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String customId = this.receiptHandlerRequest.getCustomId();
        String batchNo = this.receiptHandlerRequest.getBatchSeqId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).bankLoginID(bankLoginId).bankVersionID(bankVersionId).logBizSeqID(batchNo).bizName("receipt").logRequestSeqID(Sequence.genSequence()).build());
        MDC.put((String)"bankVersion", (String)bankVersionId);
        EBContext.getContext().setType("create");
        this.reconciliationDownloadTaskService = (ReconciliationDownloadTaskService)SpringContextUtil.getBean(ReconciliationDownloadTaskService.class);
        return true;
    }

    public boolean afterTask() {
        MDC.remove((String)"bankVersion");
        MDC.remove((String)"type");
        EBContext.destroy();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subProcess() {
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String transDateStr = this.receiptHandlerRequest.getTransDate();
        BankAcntService bankAcntService = BankAcntService.getInstance();
        LocalDate transDate = LocalDateUtil.parserDate((String)transDateStr);
        List bankAcntList = bankAcntService.findByBankVersionIdAndBankLoginIdAndHasReconciliation(bankVersionId, bankLoginId, true);
        String customID = EBContext.getContext().getCustomID();
        bankAcntList = bankAcntList.stream().filter(item -> Objects.equals(customID, item.getCustomID())).collect(Collectors.toList());
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1 \u94f6\u884c\u8d26\u6237\u4e2a\u6570:{}-{}", new Object[]{bankLoginId, bankAcntList.size()});
        if (bankAcntList.isEmpty() || bankAcntList.size() == 0) {
            return;
        }
        RequestContextUtils.handBankAcntListByBankVersion(bankAcntList);
        for (BankAcnt bankAcnt : bankAcntList) {
            String accNo = bankAcnt.getAccNo();
            try {
                FEPAccess access = FEPAccessUtil.access((String)bankVersionId, (String)(bankLoginId + accNo));
                if (Objects.nonNull(access)) {
                    this.logger.info("\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1-\u8d26\u53f7\uff1a{} \u5904\u7406\u65f6\u95f4\uff1a{}-\u5f00\u59cb\u83b7\u53d6\u5206\u5e03\u5f0f\u9501", new Object[]{accNo, transDateStr});
                    try {
                        this.logger.info("\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1- \u8d26\u53f7\uff1a{} \u5904\u7406\u65f6\u95f4\uff1a{}-\u83b7\u53d6\u5230\u5206\u5e03\u5f0f\u9501", new Object[]{accNo, transDateStr});
                        if (!RequestContextUtils.isAccNoOfReconciliationByBank((String)bankVersionId)) {
                            accNo = "";
                        }
                        List downLoadTasks = this.reconciliationDownloadTaskService.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionId, bankLoginId, transDate, transDate);
                        BankReconciliationProperties bankBusinessProperties = (BankReconciliationProperties)EBConfigBuilder.getInstance().buildConfig(BankReconciliationProperties.class, bankLoginId);
                        if (Objects.equals(bankBusinessProperties.getIsMonthReconciliation(), "true")) {
                            HashMap existTransDateMaps = Maps.newHashMapWithExpectedSize((int)16);
                            downLoadTasks.stream().forEach(t -> {
                                String dateStr;
                                LocalDate date = t.getTransDate();
                                if (date != null && !existTransDateMaps.containsKey(dateStr = LocalDateUtil.formatDate((LocalDate)date, (String)"yyyyMM"))) {
                                    existTransDateMaps.put(dateStr, dateStr);
                                }
                            });
                            List monthsBetweenDate = LocalDateUtil.getMonthsBetweenDate((LocalDate)transDate, (LocalDate)transDate);
                            for (String month : monthsBetweenDate) {
                                if (existTransDateMaps.containsKey(month)) continue;
                                LocalDate createLocalDate = LocalDateUtil.parserDate((String)(month + "01"));
                                this.createNewTask(this.receiptHandlerRequest, accNo, createLocalDate);
                            }
                        } else if (downLoadTasks.size() == 0) {
                            this.createNewTask(this.receiptHandlerRequest, accNo, transDate);
                        }
                        this.logger.info("\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1- \u8d26\u53f7\uff1a{} \u5904\u7406\u65f6\u95f4\uff1a{}-\u6267\u884cdownload\u5b8c\u6210", new Object[]{accNo, transDateStr});
                        continue;
                    }
                    catch (Exception ex) {
                        this.logger.info("\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1-\u64cd\u4f5c\u5f02\u5e38\u56de\u6eda- \u8d26\u53f7\uff1a{} \u5904\u7406\u65f6\u95f4\uff1a{}-\u5f02\u5e38\u539f\u56e0\uff1a{}", new Object[]{accNo, transDateStr, ex.getMessage()});
                        this.logger.error("\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1-\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)ex);
                        continue;
                    }
                    finally {
                        access.release();
                        continue;
                    }
                }
                throw new ReceiptException(ResManager.loadKDString((String)"\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1-\u5f53\u524d\u4efb\u52a1\u83b7\u53d6\u524d\u7f6e\u673a\u9501\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"CreateTask_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.logger.info("\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1-\u8d26\u6237{}-\u65e5\u671f\uff1a{}-\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{accNo, transDateStr, e.getMessage()});
            }
        }
        this.logger.info("\u4efb\u52a1\u6267\u884c\u5668\uff1a\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1");
    }

    public void createNewTask(ReceiptHandlerRequest request, String accNo, LocalDate transDate) {
        String bankVersionId = this.receiptHandlerRequest.getBankVersion();
        String bankLoginId = this.receiptHandlerRequest.getBankLoginId();
        String customId = this.receiptHandlerRequest.getCustomId();
        ReconciliationInfo downLoadTask = new ReconciliationInfo();
        downLoadTask.setAccNo(accNo);
        downLoadTask.setBankLoginId(bankLoginId);
        downLoadTask.setBankVersionId(bankVersionId);
        downLoadTask.setCustomNo(customId);
        downLoadTask.setStatus(Integer.valueOf(TaskStatus.CREATE.getId()));
        downLoadTask.setTransDate(transDate);
        downLoadTask.setUploadFlag(Integer.valueOf(UploadTaskStatusEnum.UN_UPLOAD.getId()));
        this.reconciliationDownloadTaskService.save(downLoadTask);
        this.logger.info("\u65b0\u589e\u5bf9\u8d26\u5355\u4efb\u52a1 -> \u94f6\u884c:" + bankVersionId + "; \u8d26\u53f7:" + accNo + "; \u4ea4\u6613\u65e5\u671f:" + transDate);
    }

    public boolean match() {
        return ReconciliationHandlerType.CREATE.getName().equals(this.receiptHandlerRequest.getType());
    }
}

