/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.abc.dc.service.receipt;

import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.abc.dc.service.receipt.AbcDcCommonConfig;
import kd.ebg.receipt.banks.abc.dc.service.receipt.api.GetBankReceiptFileNameImpl;
import kd.ebg.receipt.banks.abc.dc.service.receipt.api.SendRequestImpl;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.AcntNumberHelper;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.FileInfo;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.ReceiptFileConvertUtils;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.ReceiptPacker;
import kd.ebg.receipt.banks.abc.dc.service.receipt.util.ReceiptParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankLoginId = request.getBankLoginId();
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        AbcDcCommonConfig abcDcCommonConfig = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLoginId);
        boolean isPushed = abcDcCommonConfig.getAbcPushMode().equals("true");
        List<Object> result = new ArrayList(16);
        boolean isToday = downloadListTask.getTransDate().isEqual(LocalDate.now());
        boolean isOFDReceipt = Objects.equals(abcDcCommonConfig.getReceiptFileType(), "OFD");
        if (isToday) {
            if (isOFDReceipt) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301OFD\u683c\u5f0f\u7684\u5f53\u65e5\u56de\u5355\u3002", (String)"BankReceiptFetchListImpl_10", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]));
            }
            result = this.doJob_todayProxyMode(downloadListTask);
        } else {
            boolean hisChoose = ((AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLoginId)).getHistorychoose().equals("CMRA25");
            if (!isPushed) {
                result = hisChoose || isOFDReceipt ? this.doJob_proxyMode(downloadListTask, isOFDReceipt) : this.doJob_todayProxyMode(downloadListTask);
            } else {
                result = this.doJob_pushMode(downloadListTask, isOFDReceipt);
                this.clearDetailFromBD(taskId);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public void clearDetailFromBD(long taskId) {
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        List ids = downloadListDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            this.downloadListDetailService.deleteAll(ids);
        }
    }

    public List<DownloadListDetail> doJob_todayProxyMode(DownloadListTask task) {
        String transDate = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        AbcDcCommonConfig config = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, task.getBankLoginId());
        String corpNo = config.getCorpNo();
        String opNo = config.getOpNo();
        String charset = config.getCharset();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(task.getAccNo(), EBContext.getContext().getCustomID());
        String dbProv = AcntNumberHelper.getAreaCodeByAcnt((BankAcnt)mainAcnt);
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        String acntNo = ReceiptFileConvertUtils.fixAccNoTo15Or19(task.getAccNo());
        String detailRequest = ReceiptPacker.detailRequestPack((String)"CQRA10", (String)corpNo, (String)opNo, (String)dbProv, (String)acntNo, (String)transDate, (String)charset, (String)bankCurrency);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(task.getAccNo()).transDate(task.getTransDate()).requestStr(detailRequest).build();
        SendRequestImpl iBankReceipt = new SendRequestImpl();
        BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)request);
        String detailResponse = (String)receiptResponseEB.getData();
        List fileInfos = ReceiptParser.detailResponseParser((DownloadListTask)task, (String)detailResponse);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(task.getId()));
        HashMap existDownloadMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId() || downloadListDetail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId()) {
                existDownloadMap.put(downloadListDetail.getFileName(), downloadListDetail);
            }
            if (!downloadListDetail.getFileLink().endsWith(".zip")) continue;
            this.downloadListDetailService.deleteById(downloadListDetail.getId());
        }
        int count = 0;
        SendRequestImpl sendRequestImpl = new SendRequestImpl();
        for (int i = 0; i < fileInfos.size(); ++i) {
            FileInfo info = (FileInfo)fileInfos.get(i);
            String trJrn = info.getTrJrn();
            String oppAccNo = info.getOppAccNo();
            String amt = info.getAmt();
            boolean isPushedFromMaster = config.getPushWay().equals("true");
            StringBuilder fileName = new StringBuilder();
            if (isPushedFromMaster) {
                fileName.append(info.getProv()).append("_");
                fileName.append(transDate).append("_");
                fileName.append(acntNo).append("_");
                fileName.append(trJrn).append("_");
                fileName.append(oppAccNo).append("_");
                BigDecimal amount = new BigDecimal(amt);
                amount = amount.abs();
                fileName.append(amount.toPlainString()).append("_");
            } else {
                fileName.append(acntNo).append("-");
                fileName.append(transDate).append("-");
            }
            fileName.append(trJrn);
            fileName.append(".pdf");
            String newFileName = fileName.toString();
            if (existDownloadMap.containsKey(newFileName)) {
                detailList.add((DownloadListDetail)existDownloadMap.get(newFileName));
                continue;
            }
            String todayReceiptRequest = ReceiptPacker.todayReceiptRequestPack((String)"CMRA76", (String)corpNo, (String)opNo, (String)acntNo, (String)transDate, (String)charset, (FileInfo)info);
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(todayReceiptRequest).accNo(acntNo).transDate(task.getTransDate()).build();
            BankReceiptResponseEB todayResponseEB = (BankReceiptResponseEB)sendRequestImpl.doBiz((BankRequest)bankReceiptRequest);
            String todayReceiptResponse = (String)todayResponseEB.getData();
            String batchFileName = "";
            try {
                batchFileName = ReceiptParser.todayReceiptResponseParse((String)todayReceiptResponse, (String)charset);
            }
            catch (Exception e) {
                logger.error("\u5f53\u65e5\u56de\u5355\u4e0b\u8f7d\u5f02\u5e38-CMRA76\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                continue;
            }
            if (null == batchFileName || "".equals(batchFileName)) {
                logger.info("\u519c\u884cCMRA76\u8fd4\u56de\u7a7a\u6587\u4ef6\u540d \u8d26\u53f7\uff1a" + acntNo + "\u65e5\u671f\uff1a" + transDate + "\u65e5\u5fd7\u53f7\uff1a" + trJrn + "\u7684\u56de\u5355\u4efb\u52a1\u7684\u91cd\u7f6e\u91cd\u8bd5\u6b21\u6570\u4e3a" + count);
                if (count >= 3) {
                    count = 0;
                    logger.info("\u91cd\u7f6e\u91cd\u8bd5\u6b21\u6570\u6e05\u96f6" + count);
                    continue;
                }
                logger.info("\u7b2c" + ++count + "\u6b21\u4e0b\u8f7d\u5931\u8d25\uff0c\u7b49\u5f85\u91cd\u65b0\u4e0b\u8f7d");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u7761\u7720\u5931\u8d25\uff1a%s\u3002", (String)"BankReceiptFetchListImpl_9", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
                --i;
                continue;
            }
            count = 0;
            DownloadListDetail detail = new DownloadListDetail();
            detail.setFileLink(batchFileName);
            detail.setFileName(newFileName);
            detailList.add(detail);
        }
        return detailList;
    }

    /*
     * Unable to fully structure code
     */
    private List<DownloadListDetail> doJob_proxyMode(DownloadListTask task, boolean isOFDReceipt) {
        bankLogin = task.getBankLoginId();
        transDate = LocalDateUtil.formatDate((LocalDate)task.getTransDate());
        bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ftpPath = bankFtpProperties.getFtpPath();
        ftpPath = EBGStringUtils.isNotEmpty((String)ftpPath) != false ? ftpPath : "/";
        detailList = new ArrayList<DownloadListDetail>(16);
        existed = false;
        batchFileName = "";
        sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            try {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp();
                }
                if (sftp == null) {
                    throw new ReceiptException(ResManager.loadKDString((String)"\u5efa\u7acbsftp\u8fde\u63a5\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]));
                }
                vector = sftp.ls(ftpPath);
                if (!Objects.nonNull(vector) || vector.size() <= 0) ** GOTO lbl34
                for (E o : vector) {
                    file = (ChannelSftp.LsEntry)o;
                    if (!this.isConformZipByTransDate(file.getFilename(), transDate, isOFDReceipt)) continue;
                    existed = true;
                    batchFileName = file.getFilename();
                }
            }
            catch (SftpException e) {
                BankReceiptFetchListImpl.logger.error(e.getMessage());
            }
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login") && (tempFiles = this.getFileByName(transDate, task.getAccNo(), task.getTransDate(), ".zip")) != null && tempFiles.size() != 0) {
            for (String tempFileName : tempFiles) {
                if (!this.isConformZipByTransDate(tempFileName, transDate, isOFDReceipt)) continue;
                existed = true;
                batchFileName = tempFileName;
            }
        }
lbl34:
        // 6 sources

        if (existed) {
            BankReceiptFetchListImpl.logger.info("\u68c0\u6d4b\u5230\u5df2\u7ecf\u63a8\u9001\u603b\u5305\uff0c\u4e0d\u53d1\u9001\u8bf7\u6c42\uff1aCMRA25");
            detail = new DownloadListDetail();
            detail.setFileName(batchFileName);
            detail.setFileLink(batchFileName);
            detailList.add(detail);
        } else {
            request = BankReceiptRequest.builder().accNo(task.getAccNo()).transDate(task.getTransDate()).build();
            iBankReceipt = new GetBankReceiptFileNameImpl();
            receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)request);
            batchFileName = (String)receiptResponseEB.getData();
            if (!isOFDReceipt && receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.FAIL.getCode()) {
                return this.doJob_todayProxyMode(task);
            }
            detail = new DownloadListDetail();
            detail.setFileName(batchFileName);
            detail.setFileLink(batchFileName);
            detailList.add(detail);
        }
        RequestContextUtils.setZipName((String)batchFileName);
        this.clearDetailFromBD(task.getId());
        return detailList;
    }

    public boolean isConformZipByTransDate(String fileName, String transDateStr, boolean isOFDReceipt) {
        if (fileName.endsWith(".zip") && fileName.contains(transDateStr)) {
            if (isOFDReceipt && fileName.contains("OFDRecpSingle")) {
                return true;
            }
            if (!isOFDReceipt) {
                return true;
            }
        }
        return false;
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate, String suffix) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString, suffix);
    }

    private List<DownloadListDetail> doJob_pushMode(DownloadListTask task, boolean isOFDReceipt) {
        String bankLogin = task.getBankLoginId();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        String ftpPath = bankFtpProperties.getFtpPath();
        ftpPath = EBGStringUtils.isNotEmpty((String)ftpPath) ? ftpPath : "/";
        AbcDcCommonConfig config = (AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLogin);
        boolean isPushedFromMaster = config.getPushWay().equals("true");
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String accNo = task.getAccNo();
        boolean flag = false;
        String bakPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)task.getBankVersionId(), (String)task.getAccNo(), (String)transDateStr);
        String type = "PDF";
        if (isOFDReceipt) {
            type = "OFD";
        }
        String tempPath = FileStorageUtil.getFileBakPath((String)task.getBankVersionId()) + File.separator + transDateStr;
        String unZipDir = FileStorageUtil.getFileBatchBakPathByTransDate((String)task.getBankVersionId(), (String)transDateStr);
        List<File> receiptFiles = ReceiptFileConvertUtils.getReceiptFileByAccNoAndAreaCode(task.getAccNo(), transDateStr, unZipDir, type.toLowerCase(Locale.ENGLISH), isPushedFromMaster);
        if (receiptFiles.size() > 0) {
            flag = true;
        }
        if (!flag) {
            ChannelSftp sftp = null;
            detailList = new ArrayList(16);
            try {
                String okFile = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE) + ".ok";
                if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                    if (SFTPUtils.getInstance().isAbort(sftp)) {
                        sftp = SFTPUtils.getInstance().getSftp();
                    }
                    if (sftp == null) {
                        throw new ReceiptException(ResManager.loadKDString((String)"\u5efa\u7acbsftp\u8fde\u63a5\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]));
                    }
                    Vector vector = sftp.ls(ftpPath);
                    if (!isPushedFromMaster) {
                        vector = SFTPUtils.getInstance().listFile(ftpPath, okFile, sftp);
                        if (Objects.isNull(vector) || vector.size() == 0) {
                            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230%s\u6587\u4ef6\uff0c\u56de\u5355\u6587\u4ef6\u5c1a\u672a\u5b8c\u6210\u63a8\u9001\u3002", (String)"BankReceiptFetchListImpl_13", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), okFile));
                        }
                        String zipFile = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE) + ".zip";
                        vector = SFTPUtils.getInstance().listFile(ftpPath, zipFile, sftp);
                    }
                    if (Objects.nonNull(vector) && vector.size() > 0) {
                        for (Object o : vector) {
                            ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)o;
                            String fileName = file.getFilename();
                            if (!this.isConformZipByTransDate(fileName, transDateStr, isOFDReceipt) || !(flag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, fileName, tempPath, sftp))) continue;
                            this.handleFiles(fileName, tempPath, unZipDir);
                        }
                    }
                } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                    List<String> okFiles;
                    if (!(isPushedFromMaster || (okFiles = this.getFileByName(transDateStr, task.getAccNo(), task.getTransDate(), ".ok")) != null && okFiles.size() != 0)) {
                        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230%s\u6587\u4ef6\uff0c\u56de\u5355\u6587\u4ef6\u5c1a\u672a\u5b8c\u6210\u63a8\u9001\u3002", (String)"BankReceiptFetchListImpl_13", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), okFiles));
                    }
                    List<String> filenames = this.getFileByName(transDateStr, task.getAccNo(), task.getTransDate(), ".zip");
                    if (filenames != null && filenames.size() > 0) {
                        for (String filename : filenames) {
                            BankReceiptApiUtil bankReceiptApiUtil;
                            if (!this.isConformZipByTransDate(filename, transDateStr, isOFDReceipt) || !(flag = (bankReceiptApiUtil = new BankReceiptApiUtil(accNo, task.getTransDate())).downloadReceiptFile(filename, tempPath))) continue;
                            this.handleFiles(filename, tempPath, unZipDir);
                        }
                    }
                }
                receiptFiles = ReceiptFileConvertUtils.getReceiptFileByAccNoAndAreaCode(task.getAccNo(), transDateStr, unZipDir, type.toLowerCase(Locale.ENGLISH), isPushedFromMaster);
            }
            catch (Exception e) {
                try {
                    String msg = ErrorMsgUtil.getSFTPErrorMSG((String)"", (String)e.getMessage());
                    logger.error("\u519c\u884c\u56de\u5355\u4e0b\u8f7d\u6709\u8bef,", (Throwable)e);
                    throw new ReceiptException(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    SFTPUtils.getInstance().close(sftp);
                    throw throwable;
                }
            }
            SFTPUtils.getInstance().close(sftp);
        }
        detailList.addAll(ReceiptFileConvertUtils.handReceiptList(receiptFiles, bakPath));
        if (detailList.size() == 0) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u94f6\u884c\u8d26\u53f7[%1$s]\u5728\u4ea4\u6613\u65e5\u671f%2$s\u7684\u56de\u5355\u6587\u4ef6", (String)"BankReceiptFetchListImpl_14", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]), accNo, transDateStr));
        }
        return detailList;
    }

    private void handleFiles(String zipName, String tempPath, String unZipDir) {
        RequestContextUtils.setZipName((String)zipName);
        if (GZFileUtils.unZipFiles((String)(tempPath + File.separator + zipName), (String)unZipDir)) {
            logger.info("\u89e3\u538b\u5b8c\u6bd5...");
            boolean isDelete = FileCommonUtils.getFileByPath((String)(tempPath + File.separator + zipName)).delete();
            logger.info("\u519c\u4e1a\u94f6\u884c-\u6587\u4ef6\u540d\u79f0\uff1a{}-{}", new Object[]{zipName, isDelete});
            isDelete = FileCommonUtils.getFileByPath((String)(tempPath + File.separator + "result.txt")).delete();
            logger.info("\u519c\u4e1a\u94f6\u884c-\u6587\u4ef6\u540d\u79f0\uff1aresult.txt-{}", (Object)isDelete);
        }
    }

    public boolean isBreak() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        boolean isPushed = ((AbcDcCommonConfig)EBConfigBuilder.getInstance().buildConfig(AbcDcCommonConfig.class, bankLoginId)).getAbcPushMode().equals("true");
        return !isPushed;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ABC_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u519c\u4e1a\u94f6\u884c\u516c\u7f51\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_8", (String)"ebg-receipt-banks-abc-dc", (Object[])new Object[0]);
    }
}

