/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crbc.dc.service.receipt.api;

import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.crbc.dc.service.receipt.api.CommonUtils;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class QuerySignAccListImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QuerySignAccListImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200010";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/presystem/access");
        super.configFactory(factory);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element body = new Element("BODY");
        JDomUtils.addChild((Element)body, (String)"CURRENT_PAGE", (String)this.getCurrentPage());
        String requestStr = CommonUtils.getInstance().getPackerData(this.getBizCode(), body);
        return requestStr;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        this.setLastPage(true);
        String encoding = RequestContextUtils.getCharset();
        Element element = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element head = element.getChild("HEAD");
        String retCode = head.getChildTextTrim("RET_CODE");
        String retMsg = head.getChildTextTrim("RET_MSG");
        if (!"000000".equals(retCode)) {
            logger.error("\u63a5\u53e3\u54cd\u5e94\u5931\u8d25{}", new Object[]{retMsg});
            this.setLastPage(true);
            return new EBBankDetailResponse(new ArrayList(16));
        }
        Element body = element.getChild("BODY");
        Element array = body.getChild("ARRAY");
        List list = array.getChildren("STRUCT");
        if (list.size() == 0) {
            return new EBBankDetailResponse(new ArrayList(16));
        }
        String totalRows = body.getChildText("TOTALROWS");
        this.handLastPage(totalRows, list);
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(1);
        for (Element ele : list) {
            String accNo = ele.getChildText("PAY_ACCOUNT");
            String ACC_FLAG = ele.getChildText("ACC_FLAG");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(accNo);
            detailInfo.setReversed1(ACC_FLAG);
            details.add(detailInfo);
        }
        return new EBBankDetailResponse(details);
    }

    public void handLastPage(String totalRows, List<Element> list) {
        if (list.size() < 20) {
            this.setLastPage(true);
            return;
        }
        if (StringUtils.isNotEmpty((String)totalRows)) {
            String currentPage = this.getCurrentPage();
            int count = Integer.parseInt(currentPage) * 20;
            if (count < Integer.parseInt(totalRows)) {
                this.setLastPage(false);
                this.setCurrentPage(Integer.parseInt(currentPage) + 1);
                return;
            }
            this.setLastPage(true);
        }
    }

    public boolean isSupportPage() {
        return true;
    }

    public int getFirstPage() {
        return 1;
    }
}

