/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gdnxs.dc.service;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.gdnxs.dc.service.api.BankFileFetchImpl;
import kd.ebg.receipt.banks.gdnxs.dc.service.api.DetailImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchImpl.class);
    private static final String SPLIT = "_";
    public DownloadListDetailService downloadListDetailService;

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActTrsdownloadFile";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        DetailImpl impl = new DetailImpl();
        List detailInfos = impl.queryTransDetail(request.getAccNo(), request.getTransDate(), request.getTransDate());
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(request.getTaskId());
        HashMap existDownloadMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId() && downloadListDetail.getMatchFlag().intValue() != MatchStatusEnum.SUCCESS.getId()) continue;
            existDownloadMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        BankFileFetchImpl fetch = new BankFileFetchImpl();
        BankReceiptRequest tempRequst = new BankReceiptRequest();
        for (DetailInfo info : detailInfos) {
            StringBuilder temp = new StringBuilder();
            String serialNo = info.getReversed1();
            StringBuilder newFileName = new StringBuilder();
            newFileName.append(request.getAccNo()).append(SPLIT).append(info.getOppAccNo()).append(SPLIT).append(LocalDateUtil.formatDate((LocalDate)request.getTransDate())).append(SPLIT).append(info.getReversed2()).append(SPLIT).append(serialNo).append(SPLIT).append(".pdf");
            temp.append(request.getAccNo()).append(SPLIT).append(serialNo).append(SPLIT).append(LocalDateUtil.formatDate((LocalDate)request.getTransDate(), (String)"yyyy-MM-dd")).append(".pdf");
            if (existDownloadMap.containsKey(newFileName.toString())) {
                DownloadListDetail detail = (DownloadListDetail)existDownloadMap.get(newFileName.toString());
                detail.setReceiptJson(info.getJson());
                result.add(detail);
                continue;
            }
            try {
                tempRequst.setRequestStr(temp.toString());
                BankReceiptResponseEB responseEB = fetch.doBiz(tempRequst);
                String file = responseEB.getMessage();
                DownloadListDetail detail = new DownloadListDetail();
                detail.setFileLink(file);
                detail.setFileName(newFileName.toString());
                detail.setReceiptJson(info.getJson());
                result.add(detail);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankDetailRequest getDetailList(String accNo, LocalDate transDate) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setStartDate(transDate);
        request.setEndDate(transDate);
        return request;
    }

    public boolean isBreak() {
        return true;
    }
}

