/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gdnxs.dc.service.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gdnxs.dc.service.util.DateUtils;
import kd.ebg.receipt.banks.gdnxs.dc.service.util.GDNXS_Packer;
import kd.ebg.receipt.banks.gdnxs.dc.service.util.GDNXS_Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl {
    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "B2EGroupActTrsQry";
    }

    public String getBizDesc() {
        return "detail search";
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)GDNXS_Packer.buildHead((String)this.getBizCode(), (String)Sequence.gen18Sequence()));
        Element body = this.getDetailRequestBody(bankDetailRequest, this.getCurrentPage(), "20");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String rqstStr = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return rqstStr;
    }

    private Element getDetailRequestBody(BankDetailRequest request, String pageTag, String page) {
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)DateUtils.getDate((LocalDate)request.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)DateUtils.getDate((LocalDate)request.getEndDate()));
        JDomUtils.addChild((Element)body, (String)"BeginNo", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"RecordNum", (String)page);
        return body;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String resp) {
        this.setLastPage(true);
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(1);
        Element head = JDomUtils.string2Root((String)resp, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = GDNXS_Parser.parserCommonInfo((Element)head);
        Element body = head.getChild("Body");
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element lists = body.getChild("List");
            String count = body.getChildText("TotalCount");
            String recordCount = body.getChildText("RecordCount");
            Integer TotleCount = Integer.parseInt(count);
            if (TotleCount == 0) {
                return new EBBankDetailResponse(result);
            }
            this.judgeLastPage(recordCount, count);
            List list = lists.getChildren("Map");
            for (Element row : list) {
                String hostJnlNo = row.getChildTextTrim("HostJnlNo");
                DetailInfo info = new DetailInfo();
                info.setReversed1(hostJnlNo);
                String transDate = row.getChildTextTrim("TransDate");
                info.setTransDate(LocalDateUtil.parserDate((String)transDate));
                String amount = row.getChildTextTrim("Amount");
                String peerAcNo = row.getChildTextTrim("PeerAcNo");
                info.setOppAccNo(peerAcNo);
                if (StringUtils.isNotEmpty((String)amount)) {
                    info.setReversed2(amount);
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                info.setJson(jsonStr);
                result.add(info);
            }
            return new EBBankDetailResponse(result);
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25", (String)"DetailImpl_0", (String)"ebg-receipt-banks-gdnxs-dc", (Object[])new Object[0]));
    }

    private void judgeLastPage(String recordCount, String totalCount) {
        if (StringUtils.isEmpty((String)recordCount) || StringUtils.isEmpty((String)totalCount)) {
            this.setLastPage(true);
            return;
        }
        int recordCountPage = Integer.parseInt(recordCount);
        int totalCountPage = Integer.parseInt(totalCount);
        if (recordCountPage < 20) {
            this.setLastPage(true);
            return;
        }
        String currentPage = this.getCurrentPage();
        int currentPageCount = Integer.parseInt(currentPage);
        if (currentPageCount + 20 > totalCountPage) {
            this.setLastPage(true);
            return;
        }
        this.setLastPage(false);
        this.setCurrentPage(currentPageCount + 20);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/").append(this.getBizCode()).append(".do?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("userPassword")).append("&SIGDATA=0");
        factory.setUri(sb.toString());
    }

    public boolean isSupportPage() {
        return true;
    }
}

