/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zjws.opa.service.receipt.download;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        return request.getTaskStatus().intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        ChannelSftp sftp = null;
        String bankLogin = request.getBankLoginId();
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp") && SFTPUtils.getInstance().isAbort(sftp)) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        boolean isLastFile = false;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(downloadListDetails.size());
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail downloadListDetail;
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            if (!this.download(downloadListDetail = (DownloadListDetail)downloadListDetails.get(i), bakFilePath, bankLogin, isLastFile, bankFtpProperties, sftp)) continue;
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(DownloadListDetail detail, String bakFilePath, String bankLogin, boolean isLastFile, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        boolean result = true;
        String ftpPath = "/";
        String nowLocalPath = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String fileName = detail.getFileLink();
        try {
            File receiptFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + detail.getFileName()));
            if (receiptFile.exists()) {
                boolean bl = true;
                return bl;
            }
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLogin);
            }
            ftpPath = EBGStringUtils.isEmpty((String)(ftpPath = bankFtpProperties.getFtpPath())) ? "/" + nowLocalPath : ftpPath + "/" + nowLocalPath;
            result = SFTPUtils.getInstance().downloadSingleFile(ftpPath, fileName, bakFilePath, sftp);
            if (!result) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:%s\u3002", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-cbhb-dc", (Object[])new Object[0]), detail.getFileLink()));
            }
            File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + detail.getFileLink()));
            if (file.exists()) {
                FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)detail.getFileName());
            } else {
                result = false;
            }
        }
        catch (Throwable e) {
            String msg = ErrorMsgUtil.getSFTPErrorMSG((String)detail.getFileLink(), (String)e.getMessage());
            logger.error(msg, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
        return result;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

