/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zjws.opa.service.receipt.utils;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zjws.opa.service.receipt.utils.Crypto;
import kd.ebg.receipt.banks.zjws.opa.service.receipt.utils.ResultInfo;
import kd.ebg.receipt.business.receipt.utils.ShowTipUtil;
import org.jdom2.Element;

public class AntUtils {
    public static final String CHARSET = "UTF-8";

    public static Element createBody() {
        return JDomUtils.createRoot((String)"body");
    }

    public static Element createHead(String function) {
        Element head = JDomUtils.createRoot((String)"head");
        JDomUtils.addChild((Element)head, (String)"version", (String)"1.0.0");
        JDomUtils.addChild((Element)head, (String)"appid", (String)RequestContextUtils.getBankParameterValue((String)"app_id"));
        JDomUtils.addChild((Element)head, (String)"function", (String)function);
        String ReqTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HHmmss"));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)ReqTime);
        JDomUtils.addChild((Element)head, (String)"reqTimeZone", (String)ZoneId.systemDefault().getId());
        JDomUtils.addChild((Element)head, (String)"reqMsgId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)head, (String)"signType", (String)"RSA");
        JDomUtils.addChild((Element)head, (String)"inputCharset", (String)CHARSET);
        return head;
    }

    public static String execute(Element body, String function, List<String> signFields) {
        Element document = JDomUtils.createRoot((String)"document");
        Element request = JDomUtils.addChild((Element)document, (String)"request");
        request.setAttribute("id", "request");
        JDomUtils.addChild((Element)request, (Element)AntUtils.createHead(function));
        JDomUtils.addChild((Element)request, (Element)body);
        JDomUtils.addChild((Element)body, (String)"sign", (String)Crypto.signBizParams(AntUtils.format(body, signFields)));
        String entireData = JDomUtils.root2String((Element)document.clone(), (String)CHARSET);
        Crypto.addSignature(document, entireData);
        return JDomUtils.root2String((Element)document, (String)CHARSET);
    }

    public static String format(Element element, List<String> signFields) {
        StringBuilder signMessage = new StringBuilder();
        for (int i = 0; i < signFields.size(); ++i) {
            String signField = signFields.get(i);
            signMessage.append(signField).append("=").append(element.getChildTextTrim(signField));
            if (i == signFields.size() - 1) continue;
            signMessage.append("||");
        }
        return signMessage.toString();
    }

    public static Element getResponse(String doc) {
        Element document = JDomUtils.string2Root((String)doc, (String)RequestContextUtils.getCharset());
        return document.getChild("response");
    }

    public static ResultInfo getResultInfo(Element body) {
        Element resultInfo = body.getChild("resultInfo");
        if (resultInfo == null) {
            return ResultInfo.failResultInfo();
        }
        String resultStatus = resultInfo.getChildTextTrim("resultStatus");
        String resultCode = resultInfo.getChildTextTrim("resultCode");
        String resultMsg = resultInfo.getChildTextTrim("resultMsg");
        return new ResultInfo(resultStatus, resultCode, resultMsg);
    }

    public static ResultInfo getResultInfo(Element body, boolean throwOnError) {
        ResultInfo resultInfo = AntUtils.getResultInfo(body);
        if (throwOnError && !resultInfo.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)resultInfo.getStatusAndCode(), (String)resultInfo.getResultMsg()));
        }
        return resultInfo;
    }

    public static String getHashAlg() {
        return "SHA1";
    }

    public static void setURI(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/xml;charset=UTF-8");
    }
}

