/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.receipt.common.utils.ReflectUtil;
import kd.sdk.ebg.cus.api.ISDKBankBusiness;
import kd.sdk.ebg.cus.api.ISDKBankReceiptMetaData;

public class CUSMetaDataCache {
    private static Map<String, ISDKBankReceiptMetaData> bankMetaDataMap = Maps.newHashMapWithExpectedSize((int)1);
    private static Map<String, ISDKBankBusiness> bankBusinessMap = Maps.newHashMapWithExpectedSize((int)1);
    private static boolean init;
    private static CUSMetaDataCache instance;

    public static CUSMetaDataCache getInstance() {
        return instance;
    }

    private void initBankMetaData() {
        Set<Class<?>> clzImplSet = ReflectUtil.getSubTypesOf(ISDKBankReceiptMetaData.class);
        if (clzImplSet != null) {
            for (Class<?> c : clzImplSet) {
                try {
                    ISDKBankReceiptMetaData bankMetaData = (ISDKBankReceiptMetaData)c.newInstance();
                    bankMetaDataMap.put(bankMetaData.getBankVersionID(), bankMetaData);
                }
                catch (Throwable t) {
                    EBGLogger logger = EBGLogger.getInstance().getLogger(CUSMetaDataCache.class);
                    String msg = ResManager.loadKDString((String)"\u5b9a\u5236\u5316\u5f00\u53d1\u94f6\u884c\u63d2\u4ef6\u63cf\u8ff0\u4fe1\u606f\u52a0\u8f7d\u5f02\u5e38\u3002", (String)"CUSMetaDataCache_1", (String)"ebg-receipt-common", (Object[])new Object[0]);
                    logger.monitorError(msg, t);
                }
            }
        }
    }

    private void initBankBusiness() {
        Set<Class<?>> clzImplSet = ReflectUtil.getSubTypesOf(ISDKBankBusiness.class);
        if (clzImplSet != null) {
            for (Class<?> c : clzImplSet) {
                try {
                    ISDKBankBusiness bankBusiness = (ISDKBankBusiness)c.newInstance();
                    bankBusinessMap.put(bankBusiness.getBankVersionID(), bankBusiness);
                }
                catch (Throwable t) {
                    EBGLogger logger = EBGLogger.getInstance().getLogger(CUSMetaDataCache.class);
                    String msg = ResManager.loadKDString((String)"\u5b9a\u5236\u5316\u5f00\u53d1\u94f6\u884c\u4e1a\u52a1\u914d\u7f6e\u9879\u52a0\u8f7d\u5f02\u5e38\u3002", (String)"CUSMetaDataCache_2", (String)"ebg-receipt-common", (Object[])new Object[0]);
                    logger.monitorError(msg, t);
                }
            }
        }
    }

    public Map<String, ISDKBankReceiptMetaData> getCUSMetaDataSet() {
        if (!init) {
            this.initBankMetaData();
            this.initBankBusiness();
            init = true;
        }
        return bankMetaDataMap;
    }

    public ISDKBankReceiptMetaData getCUSMetaDataImpl(String bankVersion) {
        if (bankMetaDataMap.containsKey(bankVersion)) {
            return bankMetaDataMap.get(bankVersion);
        }
        return null;
    }

    public ISDKBankBusiness getCUSBankBusiness(String bankVersion) {
        if (bankBusinessMap.containsKey(bankVersion)) {
            return bankBusinessMap.get(bankVersion);
        }
        return null;
    }

    static {
        instance = new CUSMetaDataCache();
    }
}

