/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.properties;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.receipt.common.framework.properties.PropertyChecker;
import kd.ebg.receipt.common.framework.properties.PropertyConfigItem;
import kd.ebg.receipt.common.framework.properties.PropertyName;

public interface PropertyConfig {
    public static final String SPECIAL_OBJECT_ID_FLAG = "NAN";
    public static final List<String> trueFalseCN = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u662f", (String)"PropertyConfig_0", (String)"ebg-receipt-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426", (String)"PropertyConfig_1", (String)"ebg-receipt-common", (Object[])new Object[0])});
    public static final List<String> falseTrueCN = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5426", (String)"PropertyConfig_1", (String)"ebg-receipt-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f", (String)"PropertyConfig_0", (String)"ebg-receipt-common", (Object[])new Object[0])});
    public static final List<String> trueFalseEN = Lists.newArrayList((Object[])new String[]{"true", "false"});
    public static final List<String> falseTrueEN = Lists.newArrayList((Object[])new String[]{"false", "true"});
    public static final List<String> onOffCN = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5f00", (String)"PropertyConfig_2", (String)"ebg-receipt-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5173", (String)"PropertyConfig_3", (String)"ebg-receipt-common", (Object[])new Object[0])});
    public static final List<String> offOnCN = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5173", (String)"PropertyConfig_3", (String)"ebg-receipt-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f00", (String)"PropertyConfig_2", (String)"ebg-receipt-common", (Object[])new Object[0])});
    public static final List<String> onOffEN = Lists.newArrayList((Object[])new String[]{"on", "off"});
    public static final List<String> offOnEN = Lists.newArrayList((Object[])new String[]{"off", "on"});
    public static final List<MultiLangEnumBridge> mlTrueFalseCN = Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "PropertyConfig_0", "ebg-receipt-common"), new MultiLangEnumBridge("\u5426", "PropertyConfig_1", "ebg-receipt-common")});
    public static final List<MultiLangEnumBridge> mlFalseTrueCN = Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5426", "PropertyConfig_1", "ebg-receipt-common"), new MultiLangEnumBridge("\u662f", "PropertyConfig_0", "ebg-receipt-common")});
    public static final List<MultiLangEnumBridge> mlOnOffCN = Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f00", "PropertyConfig_2", "ebg-receipt-common"), new MultiLangEnumBridge("\u5173", "PropertyConfig_3", "ebg-receipt-common")});
    public static final List<MultiLangEnumBridge> mlOffOnCN = Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5173", "PropertyConfig_3", "ebg-receipt-common"), new MultiLangEnumBridge("\u5f00", "PropertyConfig_2", "ebg-receipt-common")});
    public static final List<String> defaultTrue = Lists.newArrayList((Object[])new String[]{"true"});
    public static final List<String> defaultFalse = Lists.newArrayList((Object[])new String[]{"false"});
    public static final List<String> defaultOn = Lists.newArrayList((Object[])new String[]{"on"});
    public static final List<String> defaultOff = Lists.newArrayList((Object[])new String[]{"off"});
    public static final Pattern positiveIntegerPattern = Pattern.compile("^[1-9][0-9]*");
    public static final Pattern decimalWith2Pattern = Pattern.compile("^[0-9]+(.[0-9]{2})?$");
    public static final Pattern decimalWith2PatternStrict = Pattern.compile("^[0-9]+(.[0-9]{2}){1}$");
    public static final PropertyChecker trueFalseChecker = trueFalseEN::contains;
    public static final PropertyChecker onOffChecker = onOffEN::contains;
    public static final PropertyChecker positiveIntegerChecker = value -> positiveIntegerPattern.matcher(value).matches();
    public static final PropertyChecker decimalWith2Strict = value -> decimalWith2PatternStrict.matcher(value).matches();
    public static final PropertyChecker notNull = StrUtil::isNotBlank;

    default public PropertyChecker getNumberCheckerByLength(int length) {
        Pattern pattern = Pattern.compile("^\\d{" + length + "}$");
        return value -> pattern.matcher(value).matches();
    }

    default public PropertyChecker getNumberCheckerByLength(int minLength, int maxLength) {
        Pattern pattern = Pattern.compile("^\\d{" + minLength + "," + maxLength + "}$");
        return value -> pattern.matcher(value).matches();
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems();

    public String getPropertyConfigID();

    public PropertyName getPropertyName();

    public String getConfigName();

    public String getConfigDesc();
}

