/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.parse.FileParserRegister;
import kd.ebg.receipt.common.framework.receipt.parse.api.IFileInfo;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.receipt.EBCReceiptInfo;
import kd.ebg.receipt.common.model.receipt.ReceiptJson;
import kd.ebg.receipt.common.model.repository.DetailInfoRepository;
import kd.ebg.receipt.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptCommonAipUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptCommonAipUtil.class);

    public BankVersionService getBankVersionService() {
        return BankVersionService.getInstance();
    }

    public BankLoginService getBankLoginService() {
        return BankLoginService.getInstance();
    }

    public DetailInfoRepository getDetailInfoRepository() {
        return SpringContextUtil.getBean(DetailInfoRepository.class);
    }

    public DownloadTaskService getDownloadTaskService() {
        return SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public DownloadListDetailService getDownloadListDetailService() {
        return SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public BankAcntService getBankAcntService() {
        return BankAcntService.getInstance();
    }

    public List<BankAcnt> getNeedCreateTaskBankAcntList(String bankVersionId, String bankLoginId, LocalDate transDate) {
        long startTime = System.currentTimeMillis();
        String customID = EBContext.getContext().getCustomID();
        List bankAcntList = this.getBankAcntService().findByBankVersionIdAndBankLoginIdAndHasReconciliation(bankVersionId, bankLoginId, true);
        List receiptAccountList = bankAcntList.stream().filter(item -> item.getHasReceipt() != false && Objects.equals(customID, item.getCustomID())).collect(Collectors.toList());
        List<DownloadListTask> receiptDownloadTaskEntityList = this.getDownloadTaskService().findByBankVersionIDAndTransDateAndCustomId(bankVersionId, transDate, customID);
        List exitTaskOfbankAcntList = receiptDownloadTaskEntityList.stream().map(item -> item.getAccNo()).collect(Collectors.toList());
        List<BankAcnt> needCreateTaskBankAcntList = receiptAccountList.stream().filter(item -> !exitTaskOfbankAcntList.contains(item.getAccNo())).collect(Collectors.toList());
        long endTime = System.currentTimeMillis();
        logger.monitorInfo("ebg-getNeedCreateTaskBankAcntList\uff1a{} ms", new Object[]{endTime - startTime});
        return needCreateTaskBankAcntList;
    }

    public static void handleReceiptInfo(String customId, String bankVersionId, String requestSeqID, LocalDate transDate) {
        ReceiptCommonAipUtil.handleReceiptInfo(customId, bankVersionId, requestSeqID, transDate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleReceiptInfo(String customId, String bankVersionId, String requestSeqID, LocalDate transDate, boolean updTaskNum) {
        FEPAccess access;
        BankAcntService bankAcntService = BankAcntService.getInstance();
        int receiptAcntCount = bankAcntService.selectReconciliationByCustomIdAndBankVersion(customId, bankVersionId).size();
        EBCReceiptInfoService ebcReceiptInfoService = SpringContextUtil.getBean(EBCReceiptInfoService.class);
        DownloadTaskService receiptDownloadTaskService = SpringContextUtil.getBean(DownloadTaskService.class);
        boolean isCreateEBContext = false;
        if (EBContext.getContext() == null) {
            EBContext ebContext = EBContext.builder().customID(customId).bankVersionID(bankVersionId).build();
            EBContext.setContext((EBContext)ebContext);
            isCreateEBContext = true;
        }
        if (Objects.nonNull(access = FEPAccessUtil.access((String)bankVersionId, (String)bankVersionId))) {
            try {
                EBCReceiptInfo ebcReceiptInfo = ebcReceiptInfoService.findByCustomIdAndTransDateAndBankVersionId(customId, transDate, bankVersionId);
                int taskNum = receiptDownloadTaskService.countTaskNumByBankVersionIDAndTransDateAndCustomId(bankVersionId, transDate, customId);
                if (ebcReceiptInfo == null) {
                    ebcReceiptInfo = new EBCReceiptInfo();
                    ebcReceiptInfo.setBatchNo(requestSeqID);
                    ebcReceiptInfo.setEbcTransDate(transDate);
                    ebcReceiptInfo.setBankVersionId(bankVersionId);
                    ebcReceiptInfo.setReceiptAcntNum(Integer.valueOf(receiptAcntCount));
                    if (updTaskNum) {
                        ebcReceiptInfo.setTaskNum(Integer.valueOf(taskNum));
                    } else {
                        ebcReceiptInfo.setTaskNum(Integer.valueOf(0));
                    }
                    ebcReceiptInfo.setFileNum(Integer.valueOf(0));
                    ebcReceiptInfo.setCustomNo(customId);
                    ebcReceiptInfo.setModifytime(LocalDateTime.now());
                    ebcReceiptInfo.setCompeletedFlag(Integer.valueOf(0));
                    ebcReceiptInfoService.save(ebcReceiptInfo);
                } else {
                    ebcReceiptInfo.setReceiptAcntNum(Integer.valueOf(receiptAcntCount));
                    ebcReceiptInfo.setModifytime(LocalDateTime.now());
                    DownloadListDetailService downloadListDetailService = SpringContextUtil.getBean(DownloadListDetailService.class);
                    int finishTasks = receiptDownloadTaskService.countFinishTaskNumByBankVersionIDAndTransDateAndCustomId(bankVersionId, transDate, customId);
                    ebcReceiptInfo.setTaskNum(Integer.valueOf(taskNum));
                    if (finishTasks != taskNum) {
                        ebcReceiptInfo.setCompeletedFlag(Integer.valueOf(0));
                    } else {
                        ebcReceiptInfo.setCompeletedFlag(Integer.valueOf(1));
                    }
                    int fileNum = downloadListDetailService.countDetailByCustomerBankAndTransDate(customId, bankVersionId, transDate);
                    ebcReceiptInfo.setFileNum(Integer.valueOf(fileNum));
                    ebcReceiptInfoService.update(ebcReceiptInfo);
                }
            }
            catch (Throwable e) {
                logger.monitorError("handleReceiptInfo#error:", e);
            }
            finally {
                access.release();
                if (isCreateEBContext) {
                    EBContext.destroy();
                }
            }
        }
    }

    public static boolean isPullRecordByCustomIdTransDateAndAccNo(String customID, LocalDate transDate, String accNo) {
        try {
            DetailSyncRecordRepository detailSyncRecordRepository = SpringContextUtil.getBean(DetailSyncRecordRepository.class);
            List records = detailSyncRecordRepository.findByCustomIDAndAccNoAndSyncDateBetween(customID, accNo, transDate, transDate);
            return records.size() > 0;
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u540c\u6b65\u8bb0\u5f55\u5f02\u5e38\uff1a{}", e.getMessage());
            logger.error("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u540c\u6b65\u8bb0\u5f55\u5f02\u5e38\uff1a", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void againInstallReceiptNo(String bankVersion) {
        if (!RequestContextUtils.receiptFormatIsFile(bankVersion)) {
            return;
        }
        EBCReceiptInfoJsonService receiptInfoJsonService = SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
        String customId = RequestContext.get().getTenantId();
        LocalDate startTransDate = LocalDate.now().minusMonths(3L);
        LocalDate endTransDate = LocalDate.now().minusDays(1L);
        FEPAccess access = FEPAccessUtil.access((String)bankVersion, (String)"updateReceiptNo");
        if (Objects.nonNull(access)) {
            try {
                List<DownloadListDetail> downloadListDetailList = this.getDownloadListDetailService().findByCustomIdAndBankVersionAndBetweenTransDate(customId, bankVersion, startTransDate, endTransDate);
                HashMap detailNoMap = Maps.newHashMapWithExpectedSize((int)1);
                for (DownloadListDetail downloadListDetail : downloadListDetailList) {
                    String detailNo = downloadListDetail.getDetailNo();
                    detailNoMap.put(detailNo, downloadListDetail.getId());
                }
                HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
                List needHandReceiptList = downloadListDetailList.stream().filter(o -> o.getAccNo() != null && o.getBankLoginId() != null && o.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId() && o.getMatchFlag().intValue() == MatchStatusEnum.FAIL.getId() && o.getStatus().intValue() == TaskStatusEnum.FINISH.getId()).collect(Collectors.toList());
                HashMap receiptListGroupByAccAndTransDateMap = Maps.newHashMapWithExpectedSize((int)16);
                for (DownloadListDetail detail : needHandReceiptList) {
                    Long id;
                    String detailNo;
                    String accNo = detail.getAccNo();
                    LocalDate transDate = detail.getTransDate();
                    String dateStr = LocalDateUtil.formatDate((LocalDate)transDate);
                    String key = String.format("%s-%s", accNo, dateStr);
                    List<DownloadListDetail> receiptListGroupList = new ArrayList(16);
                    if (receiptListGroupByAccAndTransDateMap.containsKey(key)) {
                        receiptListGroupList = (List)receiptListGroupByAccAndTransDateMap.get(key);
                    }
                    long fid = detail.getId();
                    String fileName = detail.getFileName();
                    ReceiptJson receiptInfoJson = receiptInfoJsonService.findByDetailId(fid);
                    String receiptJson = "";
                    if (receiptInfoJson != null) {
                        receiptJson = receiptInfoJson.getJson();
                    }
                    if (StringUtils.isEmpty((String)receiptJson)) {
                        receiptJson = this.installReceiptJsonByFileName(bankVersion, fileName, accNo, transDate);
                    }
                    String fixAccount = accNo;
                    if (Objects.equals(bankVersion, "ABC_DC")) {
                        fixAccount = ReceiptCommonAipUtil.fixAccNoTo15Or19(fixAccount);
                    }
                    if (detailNoMap.containsKey(detailNo = MatchRule.getInstance().getReceiptMatchNo(fixAccount, LocalDateUtil.formatDate((LocalDate)transDate), receiptJson)) && (id = (Long)detailNoMap.get(detailNo)).longValue() != detail.getId()) {
                        logger.monitorInfo("exits replace record of detailNo\uff1a{}", new Object[]{detailNo});
                        if (countMap.containsKey(detailNo)) {
                            int recount = (Integer)countMap.get(detailNo);
                            countMap.put(detailNo, ++recount);
                            detailNo = detailNo + "-" + String.format("%04d", recount);
                        } else {
                            countMap.put(detailNo, 1);
                            detailNo = detailNo + "-" + String.format("%04d", 1);
                        }
                    }
                    detail.setDetailNo(detailNo);
                    receiptListGroupList.add(detail);
                    receiptListGroupByAccAndTransDateMap.put(key, receiptListGroupList);
                }
                Map<String, DetailInfo> yesterdayDetailInfoMap = this.selectDetailNoByBankVersionAndTransDate(bankVersion, startTransDate.minusDays(1L), endTransDate);
                ArrayList<DownloadListDetail> updateReceiptDetailList = new ArrayList<DownloadListDetail>(1);
                ArrayList<String> deleteReceiptInfoJsonIds = new ArrayList<String>(1);
                ArrayList<DetailInfo> updateTransInfos = new ArrayList<DetailInfo>(1);
                for (Map.Entry entry : receiptListGroupByAccAndTransDateMap.entrySet()) {
                    String[] strings;
                    String key = (String)entry.getKey();
                    List detailList = (List)entry.getValue();
                    if (!StringUtils.isNotEmpty((String)key) || (strings = key.split("-")).length != 2) continue;
                    String accNo = strings[0];
                    String transDateStr = strings[1];
                    LocalDate transDate = LocalDateUtil.parserDate((String)transDateStr);
                    String yesterdayDateStr = LocalDateUtil.formatDate((LocalDate)transDate.minusDays(1L));
                    for (DownloadListDetail detail : detailList) {
                        String detailNo = detail.getDetailNo();
                        String againReceiptNo = detailNo.replace(String.format("-%s-", transDateStr), String.format("-%s-", yesterdayDateStr));
                        boolean isDailyCut = yesterdayDetailInfoMap.containsKey(againReceiptNo);
                        if (isDailyCut) {
                            detailNo = againReceiptNo;
                        }
                        if (!yesterdayDetailInfoMap.containsKey(detailNo) && !isDailyCut) continue;
                        DetailInfo detailInfo = yesterdayDetailInfoMap.get(detailNo);
                        if (isDailyCut && detailInfo == null) {
                            detailInfo = yesterdayDetailInfoMap.get(againReceiptNo);
                        }
                        detail.setDetailId(detailInfo.getId());
                        detail.setMatchFlag(MatchStatusEnum.SUCCESS.getId());
                        try {
                            updateReceiptDetailList.add(detail);
                            logger.info("\u4fee\u6539\u5339\u914d\u89c4\u5219-\u56de\u5355\u8bb0\u5f55id:{}-accNo:{}-\u56de\u5355\u65e5\u671f\uff1a{} \u5339\u914d\u4ea4\u6613\u660e\u7ec6\u6210\u529f \u5220\u9664\u56de\u5355\u62a5\u6587", new Object[]{detail.getId(), detail.getAccNo(), detail.getTransDate()});
                            deleteReceiptInfoJsonIds.add(Long.toString(detail.getId()));
                        }
                        catch (Exception e) {
                            logger.monitorError("edit only record error\uff1a", e);
                        }
                        if (!isDailyCut) continue;
                        logger.monitorInfo("edit only record of detail_no\uff1a" + detail.getDetailNo());
                        detailInfo.setReceiptNo(detail.getDetailNo());
                        updateTransInfos.add(detailInfo);
                    }
                }
                this.getDetailInfoRepository().updateBatchReceiptNo(updateTransInfos);
                this.getDownloadListDetailService().updateAll(updateReceiptDetailList);
                receiptInfoJsonService.deleteBatchByDetailId(deleteReceiptInfoJsonIds);
            }
            catch (Throwable ex) {
                logger.monitorError("againInstallReceiptNo error" + ex.getMessage(), ex);
            }
            finally {
                access.release();
            }
        }
    }

    public String installReceiptJsonByFileName(String bankVersion, String fileName, String accNo, LocalDate transDate) {
        FileParserRegister fileParserRegister = SpringContextUtil.getBean(FileParserRegister.class);
        IFileInfo iFileInfo = fileParserRegister.getFileInfo(bankVersion, fileName);
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String amount = iFileInfo.getAmount();
        String cdFlag = iFileInfo.getCdFlag();
        String receiptNo = iFileInfo.getReceiptNo();
        String oppAccNo = iFileInfo.getOppAccNo();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[0], (Object)accNo);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[1], (Object)oppAccNo);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[2], (Object)transDateStr);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[3], (Object)amount);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[4], (Object)cdFlag);
        jsonObject.put(CosmicConstants.DEFAULT_MATCH_RULE_PARAM_KEY_ARRAY[5], (Object)receiptNo);
        return jsonObject.toJSONString();
    }

    public static String fixAccNoTo15Or19(String accNo) {
        String retAccNo = null;
        if (null != accNo) {
            String str2 = accNo.trim();
            retAccNo = str2.length() == 19 ? accNo : (str2.length() == 21 ? str2.substring(2) : ReceiptCommonAipUtil.getLastNString(str2, 15));
        }
        return retAccNo;
    }

    private static String getLastNString(String accNo, int count) {
        String str = accNo;
        if (accNo.length() > count) {
            int i = accNo.length() - count;
            str = accNo.substring(i);
        }
        return str;
    }

    public Map<String, DetailInfo> selectDetailNoByBankVersionAndTransDate(String bankVersionId, LocalDate startDate, LocalDate endDate) {
        DetailInfoRepository detailInfoRepository = SpringContextUtil.getBean(DetailInfoRepository.class);
        List<DetailInfo> detailInfoList = detailInfoRepository.findByBankVersionIDAndTransDateBetween(bankVersionId, startDate, endDate);
        HashMap detailInfoMap = Maps.newHashMapWithExpectedSize((int)detailInfoList.size());
        detailInfoList.forEach(o -> detailInfoMap.put(o.getReceiptNo(), o));
        return detailInfoMap;
    }
}

