/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.monitor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.utils.AESUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.constant.monitor.ReceiptPushWayEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.model.monitor.ReceiptConnectMonitorInfo;

@Component
public class ReceiptConnectMonitorRepository {
    private static final String ENTITY = "receipt_connect_monitor";
    private static final String SELECT_ALL_PROPERTIES = "id,status,creator,modifier,enable,createtime,modifytime,receipt_way,ip,port,user,password,monitor_status,error_msg,private_cert_path,monitor_time";

    public ReceiptConnectMonitorInfo save(ReceiptConnectMonitorInfo info) {
        DynamicObject dynamicObject = this.packDynamicObject(null, info);
        DynamicObject[] resultArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        ReceiptConnectMonitorInfo receiptConnectMonitorInfo = this.toInfo(resultArray[0]);
        return receiptConnectMonitorInfo;
    }

    public List<ReceiptConnectMonitorInfo> selectAll() {
        QFilter filter = QFilter.of((String)"status=?", (Object[])new Object[]{"A"});
        DynamicObject[] resultArray = BusinessDataServiceHelper.load((String)ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        ArrayList<ReceiptConnectMonitorInfo> result = new ArrayList<ReceiptConnectMonitorInfo>(16);
        for (DynamicObject dy : resultArray) {
            ReceiptConnectMonitorInfo receiptConnectMonitorInfo = this.toInfo(dy);
            result.add(receiptConnectMonitorInfo);
        }
        return result;
    }

    public void update(ReceiptConnectMonitorInfo info) {
        DynamicObject dynamicObject = this.findOneById(info.getId());
        dynamicObject = this.packDynamicObject(dynamicObject, info);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void delete(ReceiptConnectMonitorInfo info) {
        long id = info.getId();
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DeleteServiceHelper.delete((String)ENTITY, (QFilter[])filter.toArray());
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public ReceiptConnectMonitorInfo findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            ReceiptConnectMonitorInfo receiptInfo = this.toInfo(dynamicObject);
            return receiptInfo;
        }
        return null;
    }

    public ReceiptConnectMonitorInfo findInfoByWayAndIpAndPort(String way, String ip, String port) {
        DynamicObject[] dynamicObjectCollection = BusinessDataServiceHelper.load((String)ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("receipt_way", "=", (Object)way), new QFilter("ip", "=", (Object)ip), new QFilter("port", "=", (Object)port)});
        if (dynamicObjectCollection == null || dynamicObjectCollection.length == 0) {
            return null;
        }
        DynamicObject dynamicObject = dynamicObjectCollection[0];
        ReceiptConnectMonitorInfo receiptInfo = this.toInfo(dynamicObject);
        return receiptInfo;
    }

    public ReceiptConnectMonitorInfo findInfoByWayAndIpAndPortAndUserName(String way, String ip, String port, String userName) {
        DynamicObject[] dynamicObjectCollection = BusinessDataServiceHelper.load((String)ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("receipt_way", "=", (Object)way), new QFilter("ip", "=", (Object)ip), new QFilter("port", "=", (Object)port), new QFilter("user", "=", (Object)userName)});
        if (dynamicObjectCollection == null || dynamicObjectCollection.length == 0) {
            return null;
        }
        DynamicObject dynamicObject = dynamicObjectCollection[0];
        ReceiptConnectMonitorInfo receiptInfo = this.toInfo(dynamicObject);
        return receiptInfo;
    }

    private ReceiptConnectMonitorInfo toInfo(DynamicObject dynamicObject) {
        String cipher;
        ReceiptConnectMonitorInfo info = new ReceiptConnectMonitorInfo();
        info.setId(dynamicObject.getLong("id"));
        info.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        info.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        Date monitorTime = dynamicObject.getDate("monitor_time");
        if (monitorTime != null) {
            info.setMonitor_time(LocalDateUtil.date2LocalDateTime((Date)monitorTime));
        }
        if (EBGStringUtils.isNotEmpty(cipher = dynamicObject.getString("password"))) {
            cipher = AESUtil.unencryptedDesEncrypt((String)cipher, null);
            info.setCipher(cipher);
        }
        info.setReceipt_way(dynamicObject.getString("receipt_way"));
        info.setIp(dynamicObject.getString("ip"));
        info.setPort(dynamicObject.getString("port"));
        info.setUser(dynamicObject.getString("user"));
        info.setMonitor_status(dynamicObject.getString("monitor_status"));
        info.setError_msg(dynamicObject.getString("error_msg"));
        info.setPrivate_cert_path(dynamicObject.getString("private_cert_path"));
        return info;
    }

    private DynamicObject packDynamicObject(DynamicObject dynamicObject, ReceiptConnectMonitorInfo info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("status", (Object)info.getStatus());
        dynamicObject.set("creator", (Object)RequestContext.get().getAccountId());
        dynamicObject.set("modifier", (Object)RequestContext.get().getAccountId());
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("receipt_way", (Object)info.getReceipt_way());
        dynamicObject.set("ip", (Object)info.getIp());
        dynamicObject.set("port", (Object)info.getPort());
        dynamicObject.set("user", (Object)info.getUser());
        String cipher = info.getCipher();
        if (EBGStringUtils.isNotEmpty(cipher)) {
            cipher = AESUtil.encrypt((String)cipher);
            dynamicObject.set("password", (Object)cipher);
        }
        dynamicObject.set("monitor_status", (Object)info.getMonitor_status());
        dynamicObject.set("error_msg", (Object)info.getError_msg());
        dynamicObject.set("private_cert_path", (Object)info.getPrivate_cert_path());
        if (info.getMonitor_time() != null) {
            dynamicObject.set("monitor_time", (Object)new Date());
        }
        return dynamicObject;
    }

    public void insertMonitorRecordByBankVersionAndBankLogin(String bankVersion, String bankLogin) {
        EBContext ebContext = EBContext.builder().bankVersionID(bankVersion).bankLoginID(bankLogin).customID(RequestContext.get().getTenantId()).build();
        EBContext.setContext((EBContext)ebContext);
        BankFtpProperties bankFtpProperties = EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ReceiptConnectMonitorInfo info = new ReceiptConnectMonitorInfo();
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            info.setIp(bankFtpProperties.getBankFtpIP());
            info.setPort(bankFtpProperties.getBankFtpPort() + "");
            info.setPrivate_cert_path(bankFtpProperties.getCertPath());
            info.setUser(bankFtpProperties.getUserName());
            info.setCipher(bankFtpProperties.getPassword());
            info.setReceipt_way(ReceiptPushWayEnum.SFTP.getCode());
        }
        if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            info.setReceipt_way(ReceiptPushWayEnum.BANK_LOGIN.getCode());
            info.setIp(bankFtpProperties.getFrontProxyIP());
            info.setPort(bankFtpProperties.getFrontProxyPort() + "");
        }
        if (StringUtils.isEmpty((String)info.getIp()) || StringUtils.isEmpty((String)info.getPort())) {
            return;
        }
        FEPAccess access = FEPAccessUtil.access((String)bankVersion, (String)(bankLogin + "_monitor"));
        if (Objects.nonNull(access)) {
            try {
                ReceiptConnectMonitorInfo dbMonitorRecord = null;
                dbMonitorRecord = bankFtpProperties.getReceiptAchieveWay().equals("sftp") ? this.findInfoByWayAndIpAndPortAndUserName(info.getReceipt_way(), info.getIp(), info.getPort(), info.getUser()) : this.findInfoByWayAndIpAndPort(info.getReceipt_way(), info.getIp(), info.getPort());
                if (dbMonitorRecord != null) {
                    this.delete(dbMonitorRecord);
                }
                this.save(info);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            finally {
                access.release();
            }
        }
        EBContext.destroy();
    }
}

