/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.receipt;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageImpl;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

@Component
public class DownloadListDetailRepository {
    private static final String DETAILINFO_ENTITY = "receipt_detail";
    private static final String SELECT_ALL_PROPERTIES = "id,bank_version.number,bank_login.number,acc_no.number,bank_file_path,file_name,upload_file_name,file_link,custom_id,complete_time,upload_time,detail_no,match_flag,detail_id,md5,query_flag,refid,upload_flag,upload_redo,upload_exp_msg,exp_msg,trans_date,status,modifytime,createtime,ofd_json,match_is_defect,match_defect_desc";

    public DownloadListDetail save(DownloadListDetail downloadListDetail) {
        DynamicObject dynamicObject = this.packDetailInfo(null, downloadListDetail);
        DynamicObject[] resultArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return this.toReceiptDownloadListDetailInfo(resultArray[0]);
    }

    public int countDetailByCustomerBankAndTransDate(String customId, String bankVersionId, LocalDate transDate) {
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=?  and trans_date=?", (Object[])new Object[]{customId, bankVersionId, transDate});
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)DownloadListDetailRepository.class.getName(), (String)DETAILINFO_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");){
            int total;
            int n = total = ds.count("id", Boolean.FALSE.booleanValue());
            return n;
        }
    }

    public void update(DownloadListDetail downloadListDetail) {
        DynamicObject dynamicObject = this.findOneById(downloadListDetail.getId());
        dynamicObject = this.packDetailInfo(dynamicObject, downloadListDetail);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void update(DynamicObject dynamicObject) {
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void updateAll(List<DownloadListDetail> downloadListDetails) {
        List<Long> ids = downloadListDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
        Map<Long, DownloadListDetail> listDetailMap = downloadListDetails.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        DynamicObject[] dynamicObjects = this.batchFindById(ids);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            Long id = dynamicObject.getLong("id");
            if (!listDetailMap.containsKey(id)) continue;
            DownloadListDetail detail = listDetailMap.get(id);
            dynamicObjects[i] = dynamicObject = this.packDetailInfo(dynamicObject, detail);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void deleteAllByIds(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)DETAILINFO_ENTITY);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])ids.toArray());
    }

    public DynamicObject selectById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
    }

    public DynamicObject[] findByTaskIdAndUploadFlag(long taskId, Long uploadFlag) {
        QFilter filter = QFilter.of((String)"refid=? and upload_flag = ?", (Object[])new Object[]{String.valueOf(taskId), uploadFlag.toString()});
        return BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
    }

    public void saveAll(List<DownloadListDetail> downloadListDetail) {
        if (downloadListDetail == null || downloadListDetail.size() == 0) {
            return;
        }
        DynamicObject[] dynamicObjects = new DynamicObject[downloadListDetail.size()];
        for (int i = 0; i < downloadListDetail.size(); ++i) {
            DynamicObject dynamicObject;
            DownloadListDetail detail = downloadListDetail.get(i);
            dynamicObjects[i] = dynamicObject = this.packDetailInfo(null, detail);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public DownloadListDetail findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
            return downloadListDetail;
        }
        return null;
    }

    public DynamicObject[] batchFindById(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public List<DownloadListDetail> findByRefid(Long refid) {
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)("refid='" + refid.toString() + "'"), (Object[])new Object[0]);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
                downloadListDetails.add(downloadListDetail);
            }
        }
        return downloadListDetails;
    }

    public List<DownloadListDetail> findByRefidInAndAccNo(List<Long> refid, String accNo) {
        QFilter filter1;
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        if (refid == null || refid.size() == 0) {
            return downloadListDetails;
        }
        List<String> refidList = refid.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        QFilter filter = QFilter.of((String)this.packInOfStrByList("refid", refidList), (Object[])new Object[0]);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filter1 = QFilter.of((String)"acc_no.number=?", (Object[])new Object[]{accNo})});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
                downloadListDetails.add(downloadListDetail);
            }
        }
        return downloadListDetails;
    }

    public List<DownloadListDetail> findByRefids(List<Long> refid) {
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        if (refid == null || refid.size() == 0) {
            return downloadListDetails;
        }
        List<String> refidList = refid.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        QFilter filter = QFilter.of((String)this.packInOfStrByList("refid", refidList), (Object[])new Object[0]);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
                downloadListDetails.add(downloadListDetail);
            }
        }
        return downloadListDetails;
    }

    public Page<DownloadListDetail> findByRefidInAndAccNoPage(List<Long> refid, String accNo, Pageable pageRequest) {
        PageImpl downloadListDetailPage = new PageImpl();
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        int page = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        StringBuilder orderBy = new StringBuilder();
        Sort sort = pageRequest.getSort();
        List orders = sort.toList();
        if (refid == null || refid.size() == 0) {
            return downloadListDetailPage;
        }
        for (int i = 0; i < orders.size(); ++i) {
            if (i == orders.size() - 1) {
                if (((Sort.Order)orders.get(i)).getDirection().isAscending()) {
                    orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" asc");
                    continue;
                }
                orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" desc");
                continue;
            }
            if (((Sort.Order)orders.get(i)).getDirection().isAscending()) {
                orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" asc,");
                continue;
            }
            orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" desc,");
        }
        List<String> refidList = refid.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        QFilter filter = QFilter.of((String)this.packInOfStrByList("refid", refidList), (Object[])new Object[0]);
        QFilter filter1 = QFilter.of((String)"acc_no.number=?", (Object[])new Object[]{accNo});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filter1}, (String)orderBy.toString(), (int)page, (int)pageSize);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)DETAILINFO_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");){
            if (dynamicObjects != null) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
                    downloadListDetails.add(downloadListDetail);
                }
                long total = ds.count("id", false);
                downloadListDetailPage = new PageImpl(downloadListDetails, pageRequest, total);
            }
        }
        return downloadListDetailPage;
    }

    public List<DownloadListDetail> selectByUploadFlag(List<Integer> uploadFlags) {
        List<String> uploads;
        QFilter filter1;
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)"status=?", (Object[])new Object[]{String.valueOf(TaskStatusEnum.FINISH.getId())});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filter1 = QFilter.of((String)this.packInOfStrByList("upload_flag", uploads = uploadFlags.stream().map(o -> String.valueOf(o)).collect(Collectors.toList())), (Object[])new Object[0])});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
                downloadListDetails.add(downloadListDetail);
            }
        }
        return downloadListDetails;
    }

    public String packInOfStrByList(String filed, List<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(filed).append(" in (");
        for (int i = 0; i < arrayList.size(); ++i) {
            String str = arrayList.get(i);
            stringBuilder.append("'");
            stringBuilder.append(str);
            stringBuilder.append("'");
            if (i >= arrayList.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public List<DownloadListDetail> selectByRefidAndUploadFlag(String refid, List<Integer> uploadFlags) {
        List<String> uploads;
        QFilter filter1;
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)"refid=?", (Object[])new Object[]{refid});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filter1 = QFilter.of((String)this.packInOfStrByList("upload_flag", uploads = uploadFlags.stream().map(o -> String.valueOf(o)).collect(Collectors.toList())), (Object[])new Object[0])});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
                downloadListDetails.add(downloadListDetail);
            }
        }
        return downloadListDetails;
    }

    public List<DownloadListDetail> findByRefidAndStatus(String refid, Integer status) {
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)"refid=? and status=?", (Object[])new Object[]{refid, String.valueOf(status)});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
                downloadListDetails.add(downloadListDetail);
            }
        }
        return downloadListDetails;
    }

    public List<DownloadListDetail> findByCustomIdAndBankVersionAndBankLoginIdAndTransDate(String customId, String bankVersionId, String bankLoginId, LocalDate transDate) {
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=? and bank_login.number=? and trans_date=?", (Object[])new Object[]{customId, bankVersionId, bankLoginId, transDate});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
                downloadListDetails.add(downloadListDetail);
            }
        }
        return downloadListDetails;
    }

    public DownloadListDetail findByRefidAndFileName(Long refid, String file_name) {
        QFilter filter = QFilter.of((String)"refid=? and file_name=?", (Object[])new Object[]{refid.toString(), file_name});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
        return downloadListDetail;
    }

    public List<DownloadListDetail> findByCustomIdAndBankVersionAndTransDate(String customId, String bankVersion, LocalDate transDate) {
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=? and trans_date=?", (Object[])new Object[]{customId, bankVersion, transDate});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
                downloadListDetails.add(downloadListDetail);
            }
        }
        return downloadListDetails;
    }

    public List<DownloadListDetail> findByCustomIdAndBankVersionAndBetweenTransDate(String customId, String bankVersion, LocalDate startTransDate, LocalDate endTransDate) {
        DynamicObject[] dynamicObjects;
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=? and trans_date >=? and trans_date <= ?", (Object[])new Object[]{customId, bankVersion, startTransDate, endTransDate});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
            downloadListDetails.add(downloadListDetail);
        }
        return downloadListDetails;
    }

    public List<DownloadListDetail> findBybankVersionAndCustomNoAndQueryDateBetweenOrderByFileNumDesc(String customId, String bankVersion, LocalDate startDate, LocalDate endDate) {
        DynamicObject[] dynamicObjects;
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=? and trans_date>=? and trans_date<= ", (Object[])new Object[]{customId, bankVersion, startDate, endDate});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
            downloadListDetails.add(downloadListDetail);
        }
        return downloadListDetails;
    }

    public List<DownloadListDetail> findByRefidAndFileNameAndStatus(Long refid, String file_name, Integer t_status) {
        DynamicObject[] dynamicObjects;
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)"refid=? and file_name=? and status=?", (Object[])new Object[]{refid.toString(), file_name, t_status.toString()});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
            downloadListDetails.add(downloadListDetail);
        }
        return downloadListDetails;
    }

    public List<DownloadListDetail> findByFileNameAndStatus(String file_name, Integer t_status) {
        DynamicObject[] dynamicObjects;
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        QFilter filter = QFilter.of((String)"file_name=? and status=?", (Object[])new Object[]{file_name, t_status.toString()});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            DownloadListDetail downloadListDetail = this.toReceiptDownloadListDetailInfo(dynamicObject);
            downloadListDetails.add(downloadListDetail);
        }
        return downloadListDetails;
    }

    private DownloadListDetail toReceiptDownloadListDetailInfo(DynamicObject dynamicObject) {
        String redo;
        String uploadFlag;
        String status;
        if (dynamicObject == null) {
            return null;
        }
        DownloadListDetail info = new DownloadListDetail();
        info.setId(dynamicObject.getLong("id"));
        info.setAccNo(dynamicObject.getString("acc_no.number"));
        info.setBankLoginId(dynamicObject.getString("bank_login.number"));
        info.setBankVersionId(dynamicObject.getString("bank_version.number"));
        info.setBankFilePath(dynamicObject.getString("bank_file_path"));
        info.setFileName(dynamicObject.getString("file_name"));
        info.setUploadFileName(dynamicObject.getString("upload_file_name"));
        info.setFileLink(dynamicObject.getString("file_link"));
        info.setCustomNo(dynamicObject.getString("custom_id"));
        info.setDetailNo(dynamicObject.getString("detail_no"));
        info.setDetailId(dynamicObject.getString("detail_id"));
        info.setOfdJson(dynamicObject.getString("ofd_json"));
        info.setMatch_is_defect(dynamicObject.getString("match_is_defect"));
        info.setMatch_defect_desc(dynamicObject.getString("match_defect_desc"));
        info.setMd5(dynamicObject.getString("md5"));
        info.setUploadExpMsg(dynamicObject.getString("upload_exp_msg"));
        info.setExpmsg(dynamicObject.getString("exp_msg"));
        info.setCompleteTime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("complete_time")));
        info.setTransDate(LocalDateUtil.date2LocalDate((Date)dynamicObject.getDate("trans_date")));
        info.setRefid(dynamicObject.getLong("refid"));
        info.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        info.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        String matchFlag = dynamicObject.getString("match_flag");
        if (!EBGStringUtils.isEmpty(matchFlag)) {
            info.setMatchFlag(Integer.parseInt(matchFlag));
        }
        if (!EBGStringUtils.isEmpty(status = dynamicObject.getString("status"))) {
            info.setStatus(Integer.parseInt(status));
        }
        if (!EBGStringUtils.isEmpty(uploadFlag = dynamicObject.getString("upload_flag"))) {
            info.setUploadFlag(Integer.parseInt(uploadFlag));
        }
        if (!EBGStringUtils.isEmpty(redo = dynamicObject.getString("upload_redo"))) {
            info.setUploadRedo(Integer.parseInt(redo));
        }
        return info;
    }

    private DynamicObject packDetailInfo(DynamicObject dynamicObject, DownloadListDetail info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)DETAILINFO_ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("complete_time", (Object)LocalDateUtil.localDateTime2Date((LocalDateTime)info.getCompleteTime()));
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("exp_msg", (Object)info.getExpmsg());
        dynamicObject.set("bank_file_path", (Object)info.getBankFilePath());
        dynamicObject.set("file_name", (Object)info.getFileName());
        dynamicObject.set("upload_file_name", (Object)info.getUploadFileName());
        dynamicObject.set("file_link", (Object)info.getFileLink());
        dynamicObject.set("custom_id", (Object)info.getCustomNo());
        dynamicObject.set("detail_no", (Object)info.getDetailNo());
        dynamicObject.set("match_flag", (Object)info.getMatchFlag().toString());
        dynamicObject.set("detail_id", (Object)info.getDetailId());
        dynamicObject.set("md5", (Object)info.getMd5());
        dynamicObject.set("query_flag", (Object)info.getQueryFlag());
        dynamicObject.set("refid", (Object)info.getRefid().toString());
        dynamicObject.set("upload_flag", (Object)info.getUploadFlag().toString());
        dynamicObject.set("upload_redo", (Object)info.getUploadRedo());
        dynamicObject.set("upload_exp_msg", (Object)info.getUploadExpMsg());
        dynamicObject.set("exp_msg", (Object)info.getExpmsg());
        Date transDate = LocalDateUtil.localDate2Date((LocalDate)info.getTransDate());
        dynamicObject.set("trans_date", (Object)transDate);
        dynamicObject.set("status", (Object)info.getStatus().toString());
        dynamicObject.set("ofd_json", (Object)info.getOfdJson());
        dynamicObject.set("match_is_defect", (Object)info.getMatch_is_defect());
        dynamicObject.set("match_defect_desc", (Object)info.getMatch_defect_desc());
        BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();
        BankLoginKey bankLoginKey = new BankLoginKey();
        bankLoginKey.setBankLoginId(info.getBankLoginId());
        bankLoginKey.setCustomId(info.getCustomNo());
        DynamicObject bankLogin = bankLoginRepository.findDynamicByIdAndCustomId(bankLoginKey);
        dynamicObject.set("bank_login", (Object)bankLogin);
        BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(info.getBankVersionId());
        dynamicObject.set("bank_version", (Object)bankVersion);
        BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
        DynamicObject bankAcct = bankAcntRepository.findDataByAccNoAndCustomId(info.getAccNo(), info.getCustomNo());
        dynamicObject.set("acc_no", (Object)bankAcct);
        return dynamicObject;
    }

    public void update(String accountID, String newAccountID) {
        DynamicObject[] dynamicObject;
        for (DynamicObject dynamicObject1 : dynamicObject = this.findOneById(accountID)) {
            dynamicObject1.set("custom_id", (Object)newAccountID);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObject);
    }

    public DynamicObject[] findOneById(String customID) {
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public DynamicObject selectByReceiptNo(String receiptNo) {
        QFilter filter = new QFilter("detail_no", "=", (Object)receiptNo);
        return BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
    }

    public void deleteBatchByRefIds(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        List deleteRefIds = ids.stream().map(o -> Long.toString(o)).collect(Collectors.toList());
        QFilter filter = new QFilter("refid", "in", deleteRefIds);
        DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
    }

    public DynamicObject[] findBatchByRefIds(List<Long> refIds) {
        if (refIds == null || refIds.size() == 0) {
            return null;
        }
        List deleteRefIds = refIds.stream().map(o -> Long.toString(o)).collect(Collectors.toList());
        QFilter filter = new QFilter("refid", "in", deleteRefIds);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObjects;
    }
}

