/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.reconciliation;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageImpl;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;

@Component
public class ReconciliationDownloadListDetailRepository {
    private static final String DETAILINFO_ENTITY = "reconciliation_detail";
    private static final String SELECT_ALL_PROPERTIES = "id,org,bank_version.number,bank_login.number,acc_no.number,bank_file_path,file_name,upload_file_name,file_link,custom_id,complete_time,upload_time,refid,upload_flag,upload_redo,upload_exp_msg,exp_msg,trans_date,status,modifytime,createtime,reconciliation_no,year_month,protocol_no,feed_result";

    public ReconciliationDetail save(ReconciliationDetail ReconciliationDetail2) {
        DynamicObject dynamicObject = this.packDetailInfo(null, ReconciliationDetail2);
        DynamicObject[] resultArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return this.toReconciliationDetail(resultArray[0]);
    }

    public void update(ReconciliationDetail ReconciliationDetail2) {
        DynamicObject dynamicObject = this.findOneById(ReconciliationDetail2.getId());
        dynamicObject = this.packDetailInfo(dynamicObject, ReconciliationDetail2);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void updateAll(List<ReconciliationDetail> ReconciliationDetails) {
        List<Long> ids = ReconciliationDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
        Map<Long, ReconciliationDetail> listDetailMap = ReconciliationDetails.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        DynamicObject[] dynamicObjects = this.batchFindById(ids);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            Long id = dynamicObject.getLong("id");
            if (!listDetailMap.containsKey(id)) continue;
            ReconciliationDetail detail = listDetailMap.get(id);
            dynamicObjects[i] = dynamicObject = this.packDetailInfo(dynamicObject, detail);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }

    public DynamicObject[] batchFindById(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void deleteAllByIds(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)DETAILINFO_ENTITY);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])ids.toArray());
    }

    public void delete(ReconciliationDetail ReconciliationDetail2) {
    }

    public DynamicObject selectById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
    }

    public DynamicObject[] findByTaskIdAndUploadFlag(long taskId, Long uploadFlag) {
        QFilter filter = QFilter.of((String)"refid=? and upload_flag = ?", (Object[])new Object[]{String.valueOf(taskId), uploadFlag.toString()});
        return BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
    }

    public void saveAll(List<ReconciliationDetail> ReconciliationDetail2) {
        if (ReconciliationDetail2 == null || ReconciliationDetail2.size() == 0) {
            return;
        }
        DynamicObject[] dynamicObjects = new DynamicObject[ReconciliationDetail2.size()];
        for (int i = 0; i < ReconciliationDetail2.size(); ++i) {
            DynamicObject dynamicObject;
            ReconciliationDetail detail = ReconciliationDetail2.get(i);
            dynamicObjects[i] = dynamicObject = this.packDetailInfo(null, detail);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public ReconciliationDetail findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail(dynamicObject);
            return ReconciliationDetail2;
        }
        return null;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public List<ReconciliationDetail> findByRefid(Long refid) {
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter = QFilter.of((String)("refid='" + refid.toString() + "'"), (Object[])new Object[0]);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findByRefidInAndAccNo(List<Long> refid, String accNo) {
        QFilter[] qFilters;
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        if (refid == null || refid.size() == 0) {
            return ReconciliationDetails;
        }
        List<String> refidList = refid.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        QFilter filter = QFilter.of((String)this.packInOfStrByList("refid", refidList), (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((String)accNo)) {
            QFilter filter1 = QFilter.of((String)"acc_no.number=?", (Object[])new Object[]{accNo});
            qFilters = new QFilter[]{filter, filter1};
        } else {
            qFilters = new QFilter[]{filter};
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])qFilters);
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findByRefidsAndProtocolNo(List<Long> refid, String protocolNo) {
        DynamicObjectCollection collection;
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        if (refid == null || refid.size() == 0) {
            return ReconciliationDetails;
        }
        List<String> refidList = refid.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        QFilter filter = QFilter.of((String)this.packInOfStrByList("refid", refidList), (Object[])new Object[0]);
        QFilter[] qFilters = new QFilter[]{filter};
        if (StringUtils.isNotEmpty((String)protocolNo)) {
            QFilter filter1 = QFilter.of((String)"protocol_no=?", (Object[])new Object[]{protocolNo});
            qFilters = new QFilter[]{filter, filter1};
        }
        if ((collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])qFilters)) != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findByRefids(List<Long> refid) {
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        if (refid == null || refid.size() == 0) {
            return ReconciliationDetails;
        }
        List<String> refidList = refid.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        QFilter filter = QFilter.of((String)this.packInOfStrByList("refid", refidList), (Object[])new Object[0]);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public Page<ReconciliationDetail> findByRefidInAndAccNoPage(List<Long> refid, String accNo, Pageable pageRequest) {
        PageImpl ReconciliationDetailPage = new PageImpl();
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        int page = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        StringBuilder orderBy = new StringBuilder();
        Sort sort = pageRequest.getSort();
        List orders = sort.toList();
        if (refid == null || refid.size() == 0) {
            return ReconciliationDetailPage;
        }
        for (int i = 0; i < orders.size(); ++i) {
            if (i == orders.size() - 1) {
                if (((Sort.Order)orders.get(i)).getDirection().isAscending()) {
                    orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" asc");
                    continue;
                }
                orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" desc");
                continue;
            }
            if (((Sort.Order)orders.get(i)).getDirection().isAscending()) {
                orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" asc,");
                continue;
            }
            orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" desc,");
        }
        List<String> refidList = refid.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        QFilter[] qFilters = null;
        QFilter filter = QFilter.of((String)this.packInOfStrByList("refid", refidList), (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((String)accNo)) {
            QFilter filter1 = QFilter.of((String)"acc_no.number=?", (Object[])new Object[]{accNo});
            qFilters = new QFilter[]{filter, filter1};
        } else {
            qFilters = new QFilter[]{filter};
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])qFilters, (String)orderBy.toString(), (int)page, (int)pageSize);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)DETAILINFO_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");){
            if (dynamicObjects != null) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail(dynamicObject);
                    ReconciliationDetails.add(ReconciliationDetail2);
                }
                long total = ds.count("id", false);
                ReconciliationDetailPage = new PageImpl(ReconciliationDetails, pageRequest, total);
            }
        }
        return ReconciliationDetailPage;
    }

    public Page<ReconciliationDetail> findByRefidInAndAccNoAndProtocolNoPage(List<Long> refid, String accNo, String protocolNo, Pageable pageRequest) {
        QFilter filter1;
        PageImpl ReconciliationDetailPage = new PageImpl();
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        int page = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        StringBuilder orderBy = new StringBuilder();
        Sort sort = pageRequest.getSort();
        List orders = sort.toList();
        if (refid == null || refid.size() == 0) {
            return ReconciliationDetailPage;
        }
        for (int i = 0; i < orders.size(); ++i) {
            if (i == orders.size() - 1) {
                if (((Sort.Order)orders.get(i)).getDirection().isAscending()) {
                    orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" asc");
                    continue;
                }
                orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" desc");
                continue;
            }
            if (((Sort.Order)orders.get(i)).getDirection().isAscending()) {
                orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" asc,");
                continue;
            }
            orderBy.append(((Sort.Order)orders.get(i)).getProperty()).append(" desc,");
        }
        List<String> refidList = refid.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        QFilter[] qFilters = null;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        QFilter filter = QFilter.of((String)this.packInOfStrByList("refid", refidList), (Object[])new Object[0]);
        qFilterList.add(filter);
        if (StringUtils.isNotEmpty((String)accNo)) {
            filter1 = QFilter.of((String)"acc_no.number=?", (Object[])new Object[]{accNo});
            qFilterList.add(filter1);
        }
        if (StringUtils.isNotEmpty((String)protocolNo)) {
            filter1 = QFilter.of((String)"protocol_no=?", (Object[])new Object[]{protocolNo});
            qFilterList.add(filter1);
        }
        qFilters = qFilterList.toArray(new QFilter[qFilterList.size()]);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])qFilters, (String)orderBy.toString(), (int)page, (int)pageSize);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)DETAILINFO_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");){
            if (dynamicObjects != null) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail(dynamicObject);
                    ReconciliationDetails.add(ReconciliationDetail2);
                }
                long total = ds.count("id", false);
                ReconciliationDetailPage = new PageImpl(ReconciliationDetails, pageRequest, total);
            }
        }
        return ReconciliationDetailPage;
    }

    public List<ReconciliationDetail> selectByUploadFlag(List<Integer> uploadFlags) {
        List<String> uploads;
        QFilter filter1;
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter = QFilter.of((String)"status=?", (Object[])new Object[]{String.valueOf(TaskStatusEnum.FINISH.getId())});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filter1 = QFilter.of((String)this.packInOfStrByList("upload_flag", uploads = uploadFlags.stream().map(o -> String.valueOf(o)).collect(Collectors.toList())), (Object[])new Object[0])});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public String packInOfStrByList(String filed, List<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(filed).append(" in (");
        for (int i = 0; i < arrayList.size(); ++i) {
            String str = arrayList.get(i);
            stringBuilder.append("'");
            stringBuilder.append(str);
            stringBuilder.append("'");
            if (i >= arrayList.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public List<ReconciliationDetail> selectByRefidAndUploadFlag(String refid, List<Integer> uploadFlags) {
        List<String> uploads;
        QFilter filter1;
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter = QFilter.of((String)"refid=?", (Object[])new Object[]{refid});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filter1 = QFilter.of((String)this.packInOfStrByList("upload_flag", uploads = uploadFlags.stream().map(o -> String.valueOf(o)).collect(Collectors.toList())), (Object[])new Object[0])});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findByRefidAndStatus(String refid, Integer status) {
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter = QFilter.of((String)"refid=? and status=?", (Object[])new Object[]{refid, String.valueOf(status)});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findByCustomIdAndBankVersionAndBankLoginIdAndTransDate(String customId, String bankVersionId, String bankLoginId, LocalDate transDate) {
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=? and bank_login.number=? and trans_date=?", (Object[])new Object[]{customId, bankVersionId, bankLoginId, transDate});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findByRefidInAndStatus(List<Long> refids, Integer status) {
        QFilter filter2;
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        List<String> refidList = refids.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        QFilter filter1 = QFilter.of((String)this.packInOfStrByList("refid", refidList), (Object[])new Object[0]);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("status", "=", (Object)String.valueOf(status))});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findByReconciliationNo(String reconciliationNo) {
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter2 = new QFilter("reconciliation_no", "=", (Object)reconciliationNo);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter2});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public ReconciliationDetail findByRefidAndFileName(Long refid, String file_name) {
        QFilter filter = QFilter.of((String)"refid=? and file_name=?", (Object[])new Object[]{refid.toString(), file_name});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail(dynamicObject);
        return ReconciliationDetail2;
    }

    public List<ReconciliationDetail> findByCustomIdAndBankVersionAndTransDate(String customId, String bankVersion, LocalDate transDate) {
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=? and trans_date=?", (Object[])new Object[]{customId, bankVersion, transDate});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findBybankVersionAndCustomNoAndQueryDateBetweenOrderByFileNumDesc(String customId, String bankVersion, LocalDate startDate, LocalDate endDate) {
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and bank_version.number=? and trans_date>=? and trans_date<= ", (Object[])new Object[]{customId, bankVersion, startDate, endDate});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findByRefidAndFileNameAndStatus(Long refid, String file_name, Integer t_status) {
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter = QFilter.of((String)"refid=? and file_name=? and status=?", (Object[])new Object[]{refid.toString(), file_name, t_status.toString()});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    public List<ReconciliationDetail> findByFileNameAndStatus(String file_name, Integer t_status) {
        ArrayList<ReconciliationDetail> ReconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        QFilter filter = QFilter.of((String)"file_name=? and status=?", (Object[])new Object[]{file_name, t_status.toString()});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                ReconciliationDetail ReconciliationDetail2 = this.toReconciliationDetail((DynamicObject)collection.get(i));
                ReconciliationDetails.add(ReconciliationDetail2);
            }
        }
        return ReconciliationDetails;
    }

    private ReconciliationDetail toReconciliationDetail(DynamicObject dynamicObject) {
        String redo;
        String uploadFlag;
        if (dynamicObject == null) {
            return null;
        }
        ReconciliationDetail info = new ReconciliationDetail();
        info.setId(dynamicObject.getLong("id"));
        info.setBankLoginId(dynamicObject.getString("bank_login.number"));
        info.setBankVersionId(dynamicObject.getString("bank_version.number"));
        if (RequestContextUtils.isAccNoOfReconciliationByBank(info.getBankVersionId())) {
            info.setAccNo(dynamicObject.getString("acc_no.number"));
        }
        info.setBankFilePath(dynamicObject.getString("bank_file_path"));
        info.setFileName(dynamicObject.getString("file_name"));
        info.setUploadFileName(dynamicObject.getString("upload_file_name"));
        info.setFileLink(dynamicObject.getString("file_link"));
        info.setCustomNo(dynamicObject.getString("custom_id"));
        info.setUploadExpMsg(dynamicObject.getString("upload_exp_msg"));
        info.setExpmsg(dynamicObject.getString("exp_msg"));
        info.setCompleteTime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("complete_time")));
        info.setTransDate(LocalDateUtil.date2LocalDate((Date)dynamicObject.getDate("trans_date")));
        info.setRefid(Long.valueOf(dynamicObject.getLong("refid")));
        info.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        info.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        String status = dynamicObject.getString("status");
        if (!EBGStringUtils.isEmpty(status)) {
            info.setStatus(Integer.valueOf(Integer.parseInt(status)));
        }
        if (!EBGStringUtils.isEmpty(uploadFlag = dynamicObject.getString("upload_flag"))) {
            info.setUploadFlag(Integer.valueOf(Integer.parseInt(uploadFlag)));
        }
        if (!EBGStringUtils.isEmpty(redo = dynamicObject.getString("upload_redo"))) {
            info.setUploadRedo(Integer.parseInt(redo));
        }
        info.setReconciliationNo(dynamicObject.getString("reconciliation_no"));
        info.setYearMonth(dynamicObject.getString("year_month"));
        info.setReconciliationProtocolNo(dynamicObject.getString("protocol_no"));
        info.setFeedResult(dynamicObject.getString("feed_result"));
        return info;
    }

    private DynamicObject packDetailInfo(DynamicObject dynamicObject, ReconciliationDetail info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)DETAILINFO_ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("complete_time", (Object)LocalDateUtil.localDateTime2Date((LocalDateTime)info.getCompleteTime()));
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("exp_msg", (Object)info.getExpmsg());
        dynamicObject.set("bank_file_path", (Object)info.getBankFilePath());
        dynamicObject.set("file_name", (Object)info.getFileName());
        dynamicObject.set("upload_file_name", (Object)info.getUploadFileName());
        dynamicObject.set("file_link", (Object)info.getFileLink());
        dynamicObject.set("custom_id", (Object)info.getCustomNo());
        dynamicObject.set("refid", (Object)info.getRefid().toString());
        dynamicObject.set("upload_flag", (Object)info.getUploadFlag().toString());
        dynamicObject.set("upload_redo", (Object)info.getUploadRedo());
        dynamicObject.set("upload_exp_msg", (Object)info.getUploadExpMsg());
        dynamicObject.set("exp_msg", (Object)info.getExpmsg());
        Date transDate = LocalDateUtil.localDate2Date((LocalDate)info.getTransDate());
        dynamicObject.set("trans_date", (Object)transDate);
        dynamicObject.set("status", (Object)info.getStatus().toString());
        dynamicObject.set("org", (Object)RequestContext.get().getOrgId());
        if (info.getTransDate() != null) {
            String yearMonth = LocalDateUtil.formatDate((LocalDate)info.getTransDate(), (String)"yyyyMM");
            dynamicObject.set("year_month", (Object)yearMonth);
        }
        dynamicObject.set("reconciliation_no", (Object)info.getReconciliationNo());
        dynamicObject.set("protocol_no", (Object)info.getReconciliationProtocolNo());
        dynamicObject.set("feed_result", (Object)info.getFeedResult());
        BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();
        BankLoginKey bankLoginKey = new BankLoginKey();
        bankLoginKey.setBankLoginId(info.getBankLoginId());
        bankLoginKey.setCustomId(info.getCustomNo());
        DynamicObject bankLogin = bankLoginRepository.findDynamicByIdAndCustomId(bankLoginKey);
        dynamicObject.set("bank_login", (Object)bankLogin);
        BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(info.getBankVersionId());
        dynamicObject.set("bank_version", (Object)bankVersion);
        if (RequestContextUtils.isAccNoOfReconciliationByBank(info.getBankVersionId())) {
            BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
            DynamicObject bankAcct = bankAcntRepository.findDataByAccNoAndCustomId(info.getAccNo(), info.getCustomNo());
            dynamicObject.set("acc_no", (Object)bankAcct);
        }
        return dynamicObject;
    }

    public void update(String accountID, String newAccountID) {
        DynamicObject[] dynamicObject;
        for (DynamicObject dynamicObject1 : dynamicObject = this.findOneById(accountID)) {
            dynamicObject1.set("custom_id", (Object)newAccountID);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObject);
    }

    public DynamicObject[] findOneById(String customID) {
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }
}

