/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.sdk.annotation.SdkDeprecated;

public class DownloadUtils {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DownloadUtils.class);

    public static void download(String urlStr, String fileName, String savePath) {
        DownloadUtils.download(urlStr, fileName, savePath, null);
    }

    @SdkDeprecated
    public static void download(String urlStr, String fileName, String savePath, Map<String, String> httpHeaders) {
        try {
            HttpURLConnection conn;
            HttpURLConnection connection;
            URL url = new URL(urlStr);
            String protocol = RequestContextUtils.getRunningParam("exchangeProtocol");
            if (Objects.equals("HTTPS", protocol)) {
                connection = (HttpsURLConnection)url.openConnection();
                SSLContext sc = null;
                sc = SSLContext.getInstance("TLS");
                sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
                ((HttpsURLConnection)connection).setSSLSocketFactory(sc.getSocketFactory());
                ((HttpsURLConnection)connection).setHostnameVerifier(new TrustAnyHostnameVerifier());
                conn = connection;
            } else {
                conn = connection = (HttpURLConnection)url.openConnection();
            }
            conn.setReadTimeout(180000);
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            if (Objects.nonNull(httpHeaders) && !httpHeaders.isEmpty()) {
                httpHeaders.forEach(conn::setRequestProperty);
            }
            try (InputStream inputStream = conn.getInputStream();){
                byte[] getData = DownloadUtils.readInputStream(inputStream);
                try {
                    int responseCode = conn.getResponseCode();
                    if (getData != null && getData.length < 4096 || responseCode != 200) {
                        log.error("\u54cd\u5e94\u7801\uff1a{}-\u54cd\u5e94\u62a5\u6587:{}", new Object[]{responseCode, new String(getData)});
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                DownloadUtils.saveFileByBytesInPath(savePath, fileName, getData);
            }
        }
        catch (Exception e) {
            throw new ReceiptException(e);
        }
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static void saveFileByBytesInPath(String savePath, String fileName, byte[] bytes) {
        File saveDir = FileCommonUtils.getFileByPath(savePath);
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        File file = FileCommonUtils.getFileByPath(saveDir + File.separator + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(bytes);
        }
        catch (Throwable e) {
            throw new ReceiptException(e);
        }
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return s.equalsIgnoreCase(sslSession.getPeerHost());
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

