/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import kd.bos.context.RequestContext;
import kd.bos.util.ConfigurationUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.CertInfo;
import kd.ebg.receipt.common.model.repository.UserCertRepository;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.commons.codec.binary.Base64;

public class PrivateCertUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PrivateCertUtils.class);

    public static String getPrivateKey(String configId, String bankLoginId) {
        UserCertRepository userCertRepository = SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(configId, bankLoginId, RequestContext.get().getTenantId());
        if (certInfo == null) {
            return null;
        }
        AESCipherSecurity cipherSecurity = SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = PrivateCertUtils.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = cipherSecurity.decryptToBytes(cipherInfo.getFileBytes(), cipherInfo.getCipherVersion());
        return PrivateCertUtils.getKey(fileContent);
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        return cipherInfo;
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }

    public static String getPrivatePath(String configId, String bankLoginId, String privateFilePath, String fileName) {
        if (StringUtils.isEmpty((String)privateFilePath)) {
            return privateFilePath;
        }
        if (privateFilePath.startsWith("/")) {
            return privateFilePath;
        }
        String privateKey = PrivateCertUtils.getPrivateKey(configId, bankLoginId);
        StringBuilder filePath = new StringBuilder();
        String storageRootPath = FileCommonUtils.checkPath(ConfigurationUtil.getString((String)"user.dir"));
        filePath.append(storageRootPath).append(File.separator).append("receipt").append(File.separator).append(RequestContext.get().getAccountId());
        filePath.append(File.separator).append(bankLoginId);
        filePath.append(File.separator).append("private");
        String filePathPre = filePath.toString();
        StringBuilder fullPrivateFilePathBuilder = new StringBuilder(filePathPre).append(File.separator).append(fileName);
        String fullPrivateFilePath = fullPrivateFilePathBuilder.toString();
        File decodeFile = FileCommonUtils.getFileByPath(fullPrivateFilePath);
        if (System.currentTimeMillis() - decodeFile.lastModified() > 43200000L) {
            boolean isDelete = decodeFile.delete();
            logger.info("\u5220\u9664\u79c1\u94a5\u6587\u4ef6\u662f\u5426\u6210\u529f-{}", isDelete);
        }
        if (!decodeFile.exists() && PrivateCertUtils.createFile(privateKey, filePathPre, fileName)) {
            logger.info("\u521b\u5efa\u79c1\u94a5\u6587\u4ef6\u6210\u529f-{}", fullPrivateFilePath);
        }
        return fullPrivateFilePath;
    }

    public static boolean createFile(String context, String filePath, String fileName) {
        String fullPath = filePath + File.separator + fileName;
        try {
            File file = FileCommonUtils.getFileByPath(fullPath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                boolean isDelete = file.delete();
                logger.info("\u6587\u4ef6-{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
            }
            boolean isCreate = file.createNewFile();
            logger.info("\u6587\u4ef6-{}-\u662f\u5426\u521b\u5efa\uff1a{}", new Object[]{file.getName(), isCreate});
            try (OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
                write.write(context);
                ((Writer)write).flush();
            }
            return true;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

