/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ncb.dc.service.receipt.api;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.ncb.dc.service.receipt.api.helper.DetailPacker;
import kd.ebg.receipt.banks.ncb.dc.service.receipt.api.helper.Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "0003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3", (String)"DetailImpl_0", (String)"ebg-receipt-banks-ncb-dc", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest request) {
        return new DetailPacker().packHisDetail(request, this.getCurrentPage());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserCommonInfo(root);
        if (!this.isLastPage(bankResponse, root)) {
            int nextPageTag = Integer.parseInt(this.getCurrentPage()) + 10;
            this.setCurrentPage(nextPageTag);
            this.setLastPage(false);
        } else {
            this.setLastPage(true);
        }
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element resBody = JDomUtils.getChildElement((Element)root, (String)"body");
            Element list = JDomUtils.getChildElement((Element)resBody, (String)"tran_record_list");
            List records = list.getChildren("record");
            for (int i = 0; i < records.size(); ++i) {
                Element record = (Element)records.get(i);
                DetailInfo detail = new DetailInfo();
                detail.setOppAccNo(JDomUtils.getChildText((Element)record, (String)"payee_account_no"));
                String core_seq_no = JDomUtils.getChildText((Element)record, (String)"core_seq_no");
                String amount = JDomUtils.getChildText((Element)record, (String)"tran_amount");
                String CDFlag = record.getChildTextTrim("cd_flag");
                String sub_core_seq_no = record.getChildTextTrim("sub_core_seq_no");
                String acdt = record.getChildTextTrim("acdt");
                detail.setReceiptNo(core_seq_no);
                detail.setReversed1(amount);
                detail.setReversed2(CDFlag);
                detail.setBizRefNo(sub_core_seq_no);
                detail.setReversed3(acdt);
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
                detail.setJson(jsonStr);
                detailList.add(detail);
            }
        }
        EBBankDetailResponse response = new EBBankDetailResponse();
        response.setDetails(detailList);
        return response;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/i2sc-client/ClientServlet/client.do");
    }

    public int getFirstPage() {
        return 1;
    }

    public boolean isSupportPage() {
        return true;
    }

    public boolean isLastPage(BankResponse bankResponse, Element root) {
        if (!"000000".equals(bankResponse.getResponseCode())) {
            this.logger.info("\u6700\u540e\u4e00\u9875\uff1a\u8fd4\u56de\u7801\u4e0d\u662f\u6210\u529f\u7801");
            return true;
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        int currentCount = Integer.parseInt(body.getChildText("current_count"));
        int totalCount = Integer.parseInt(body.getChildText("total_count"));
        Element list = JDomUtils.getChildElement((Element)body, (String)"tran_record_list");
        if (list == null) {
            return true;
        }
        List records = list.getChildren("record");
        if (records == null) {
            return true;
        }
        if (records.size() < 10) {
            this.logger.info("\u5f53\u524d\u7b14\u6570\u5c0f\u4e8e10\uff0c\u4e3a\u6700\u540e\u4e00\u9875");
            return true;
        }
        int currentTotalCount = currentCount - 1 + 10;
        if (currentTotalCount >= totalCount) {
            return true;
        }
        this.logger.info("*****\u5b58\u5728\u4e0b\u4e00\u9875******");
        return false;
    }
}

