/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ncb.dc.service.receipt.download;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"NCB_DC", (String)accNo, (String)transDateStr);
        ChannelSftp sftp = null;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, request.getBankLoginId());
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp();
        }
        try {
            for (DownloadListDetail detail : downloadListDetails) {
                if (detail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                    result.add(detail);
                    continue;
                }
                boolean isSuccess = this.download(bakFilePath, detail.getFileLink(), request, detail.getFileName(), sftp, bankFtpProperties);
                if (!isSuccess) continue;
                result.add(detail);
            }
        }
        finally {
            SFTPUtils.getInstance().close(sftp);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean download(String bakFilePath, String zipFileName, BankReceiptHandleRequest request, String newFileName, ChannelSftp sftp, BankFtpProperties bankFtpProperties) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            String sftp_path = bankFtpProperties.getFtpPath();
            sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
            try {
                if (sftp == null || !EBGStringUtils.isNotEmpty((String)sftp_path)) return true;
                boolean flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, zipFileName, bakFilePath, sftp);
                if (!flag) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5SFTP\u76ee\u5f55\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-ncb-dc", (Object[])new Object[0]), zipFileName));
                }
                this.listReceiptFile(bakFilePath, zipFileName, newFileName);
                return true;
            }
            catch (Exception e) {
                logger.error("sftp\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u901a\u8fc7sftp\u904d\u5386\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff1a%s\u3002", (String)"BankReceiptDownloadImpl_2", (String)"ebg-receipt-banks-ncb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
        } else {
            if (!bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) return true;
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
            boolean flag = bankReceiptApiUtil.downloadReceiptFile(zipFileName, bakFilePath);
            if (!flag) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u524d\u7f6e\u673a\u76ee\u5f55\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\u3002", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-ncb-dc", (Object[])new Object[0]), zipFileName));
            }
            this.listReceiptFile(bakFilePath, zipFileName, newFileName);
        }
        return true;
    }

    public void listReceiptFile(String bakFilePath, String zipFileName, String newFileName) {
        String batchUnZipPath = bakFilePath + File.separator + "temp";
        if (GZFileUtils.unZipFiles((String)(bakFilePath + File.separator + zipFileName), (String)batchUnZipPath)) {
            File[] files;
            File file = FileCommonUtils.getFileByPath((String)batchUnZipPath);
            for (File receiptFile : files = file.listFiles()) {
                String fileName = receiptFile.getName();
                if (!fileName.contains(".pdf")) continue;
                FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)newFileName);
                FileCommonUtils.deleteFile((File)receiptFile);
            }
            File zipFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + zipFileName));
            if (zipFile.exists()) {
                boolean isDelete = zipFile.delete();
                logger.info("\u5220\u9664\u56de\u5355\u538b\u7f29\u5305:{} {}-\u89e3\u538b\u5230\u7684\u6587\u4ef6\u4e2a\u6570\uff1a{}", new Object[]{zipFileName, isDelete, files.length});
            }
        }
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

