/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cib.dc.services.receipt;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileFilter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cib.dc.services.receipt.CibDcCommConfig;
import kd.ebg.receipt.banks.cib.dc.services.receipt.api.DownloadFileImpl;
import kd.ebg.receipt.banks.cib.dc.services.receipt.util.ZipOrGZFilter;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptDownLoadException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCMatchParamService;
import kd.ebg.receipt.common.framework.services.receipt.EBCMatchRuleService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCMatchRuleService ebcMatchRuleService;
    public EBCMatchParamService ebcMatchParamService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.ebcMatchRuleService = (EBCMatchRuleService)SpringContextUtil.getBean(EBCMatchRuleService.class);
        this.ebcMatchParamService = (EBCMatchParamService)SpringContextUtil.getBean(EBCMatchParamService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.DOWNLOADING.getId()) {
            return false;
        }
        return RequestContextUtils.receiptFormatIsFile() || FileCommonUtils.isTestEnv();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = request.getBankLoginId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLoginId);
        CibDcCommConfig cibDcCommConfig = (CibDcCommConfig)EBConfigBuilder.getInstance().buildConfig(CibDcCommConfig.class, bankLoginId);
        String ip = loginProperties.getIp();
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        int filePort = Integer.parseInt(cibDcCommConfig.getReceiptDownloadPort());
        String fileReceivePath = "/mservice/bin/receipt/cib/" + RequestContext.get().getAccountId();
        long taskId = request.getTaskId();
        List detailList = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList result = new ArrayList(16);
        String finalFileReceivePath = fileReceivePath;
        if (filePort == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u56de\u5355\u524d\u7f6e\u673a\u914d\u7f6e\u754c\u9762\u4e2d\u7684\u63a8\u9001\u6587\u4ef6\u7aef\u53e3\u662f\u5426\u672a\u914d\u7f6e\u3002", (String)"BankReceiptDownloadImpl_9", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]));
        }
        String receiptDownloadIp = ip;
        if (!EBGStringUtils.isEmpty((String)cibDcCommConfig.getReceiptDownloadIp())) {
            receiptDownloadIp = cibDcCommConfig.getReceiptDownloadIp();
        }
        String finalReceiptDownloadIp = receiptDownloadIp;
        detailList.forEach(detail -> {
            String fileId = detail.getFileLink();
            String fileName = detail.getFileName();
            String filePath = null;
            try {
                if (detail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId() && detail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                    return;
                }
                File fileReceiveFile = FileCommonUtils.getFileByPath((String)finalFileReceivePath);
                if (!fileReceiveFile.exists()) {
                    fileReceiveFile.mkdirs();
                }
                if (Objects.equals(protocol.toLowerCase(Locale.ENGLISH), "https")) {
                    RequestContextUtils.setRunningParam((String)"exchangeProtocol", (String)"HTTPS");
                }
                if (RequestContextUtils.isSupportProxyDownload()) {
                    HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
                    paramsMap.put("fileId", fileId);
                    paramsMap.put("fileName", fileName);
                    BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().paramsMap((Map)paramsMap).build();
                    DownloadFileImpl downloadFile = new DownloadFileImpl();
                    String zipName = String.format("%s_%s", fileId, fileName);
                    filePath = File.separator + zipName;
                    RequestContextUtils.setRunningParam((String)"savePath", (String)finalFileReceivePath);
                    RequestContextUtils.setRunningParam((String)"newFileName", (String)zipName);
                    downloadFile.doBiz(bankReceiptRequest);
                } else {
                    if (fileId.contains("+")) {
                        fileId = fileId.replaceAll("\\+", "%2B");
                    }
                    StringBuilder downloadUrl = new StringBuilder();
                    downloadUrl.append(protocol.toLowerCase(Locale.ENGLISH));
                    downloadUrl.append("://");
                    downloadUrl.append(finalReceiptDownloadIp);
                    downloadUrl.append(":");
                    downloadUrl.append(cibDcCommConfig.getReceiptDownloadPort());
                    downloadUrl.append("/download?fileId=");
                    downloadUrl.append(fileId);
                    downloadUrl.append("&fileName=");
                    downloadUrl.append(fileName);
                    String zipName = String.format("%s_%s", fileId, fileName);
                    DownloadUtils.download((String)downloadUrl.toString(), (String)zipName, (String)finalFileReceivePath);
                    filePath = File.separator + zipName;
                }
            }
            catch (Exception e) {
                logger.error("\u5174\u4e1a\u94f6\u884c\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6-ERROR:" + e.getMessage());
                throw new ReceiptException((Throwable)e);
            }
            logger.info("\u4e0b\u8f7d\u6210\u529f!  \u6587\u4ef6\u5b58\u653e\u8def\u5f84\u4e3a\uff1a" + filePath);
            if (EBGStringUtils.isEmpty((String)filePath)) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]));
            }
            result.addAll(BankReceiptDownloadImpl.handleGzOrZipFile(filePath, finalFileReceivePath, accNo, bakFilePath, fileName, fileId, transDate));
        });
        return BankReceiptHandleResponseEB.success(result);
    }

    public static List<DownloadListDetail> handleGzOrZipFile(String filePath, String fileReceivePath, String accNo, String destFolder, String fileName, String fileId, LocalDate transDate) {
        ZipOrGZFilter zipQrGZFilter;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        int gzNameIndex = filePath.lastIndexOf(File.separator);
        String str = filePath.substring(gzNameIndex + 1);
        String zipFileName = str.replaceAll("\\.gz", "").replaceAll("\\.zip", "").replaceAll(" ", "");
        File fileReceivePathFile = FileCommonUtils.getFileByPath((String)fileReceivePath);
        File[] matchFiles = fileReceivePathFile.listFiles((FileFilter)(zipQrGZFilter = new ZipOrGZFilter(fileName = fileName.replaceAll("\\.gz", "").replaceAll("\\.zip", ""), fileId = fileId.replaceAll("\\.gz", "").replaceAll("\\.zip", ""))));
        if (matchFiles.length == 0) {
            logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-{}\u76ee\u5f55\u4e0b\u4e0d\u5b58\u5728\u6587\u4ef6\u540d\u4e3a\uff1a{} \u7684\u6587\u4ef6 ", new Object[]{fileReceivePath, zipFileName});
            throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6587\u4ef6\u540d\u4e3a\uff1a% \u7684\u6587\u4ef6\u3002", (String)"BankReceiptDownloadImpl_6", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]), zipFileName));
        }
        for (File matchFile : matchFiles) {
            if (matchFile.isDirectory()) continue;
            String receiptFileName = matchFile.getName();
            String path = matchFile.getPath();
            logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-{}\u76ee\u5f55\u4e0b\u5339\u914d\u5b58\u5728\u6587\u4ef6\u540d\u4e3a\uff1a{} \u7684\u6587\u4ef6 ", new Object[]{fileReceivePath, receiptFileName});
            if (receiptFileName.contains(".gz")) {
                String zipOutFilePath = path.replaceAll(" ", "").replaceAll("\\.gz", "").replaceAll(" ", "");
                boolean unGzResult = GZFileUtils.unGzFile((String)path, (String)zipOutFilePath);
                logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u89e3\u538bGZ\u6587\u4ef6-\u7ed3\u679c:{} ", result);
                if (!unGzResult) continue;
                String unZipDir = zipOutFilePath.replaceAll("\\.gz", "").replaceAll("\\.zip", "");
                unGzResult = GZFileUtils.unZipFiles((String)zipOutFilePath, (String)unZipDir);
                logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u89e3\u538bZIP\u6587\u4ef6-GZFileUtils--\u7ed3\u679c:{} zipFilePath:{} unZipDir:{}", new Object[]{result, zipOutFilePath, unZipDir});
                if (!unGzResult) continue;
                File accFile = FileCommonUtils.getFileByPath((String)unZipDir);
                boolean isHaveEmptyFile = false;
                if (accFile.exists()) {
                    File[] files = accFile.listFiles();
                    if (files != null && files.length > 0) {
                        logger.info("\u5174\u4e1a\u94f6\u884c-{}-{}-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u76ee\u5f55\uff1a{}-\u626b\u63cf\u5230\u7684\u6587\u4ef6\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, files.length});
                        File[] fileArray = files;
                        int n = fileArray.length;
                        for (int i = 0; i < n; ++i) {
                            File file = fileArray[i];
                            long length = file.length();
                            logger.info("\u5174\u4e1a\u94f6\u884c-{}-{}-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u76ee\u5f55\uff1a{}-\u6587\u4ef6\u5927\u5c0f\uff1a{}", new Object[]{accNo, transDate, file.getPath(), length});
                            if (length > 0L) {
                                String oldName = file.getName();
                                String newName = oldName.substring(0, 8) + "_" + accNo + "_" + oldName;
                                DownloadListDetail downloadListDetail = new DownloadListDetail();
                                downloadListDetail.setFileName(newName);
                                downloadListDetail.setFileLink(file.getName());
                                result.add(downloadListDetail);
                                boolean isSuccess = FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newName);
                                logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u91cd\u547d\u540d\u56de\u5355\u6587\u4ef6-\u76ee\u5f55\uff1a{}-\u6587\u4ef6\u662f\u5426\u79fb\u52a8\u6210\u529f\uff1a{}  newName:{} \u6587\u4ef6\u5927\u5c0f\uff1a{}", new Object[]{isSuccess, destFolder, newName, length});
                                continue;
                            }
                            isHaveEmptyFile = true;
                        }
                    }
                    logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1--\u83b7\u53d6\u8d26\u53f7\u6587\u4ef6\u660e\u7ec6\u5b8c\u6bd5...");
                }
                if (!isHaveEmptyFile) {
                    FileCommonUtils.deleteAllFile((String)path);
                }
                FileCommonUtils.deleteAllFile((String)zipOutFilePath);
                FileCommonUtils.deleteAllFile((String)unZipDir);
                continue;
            }
            if (receiptFileName.contains(".zip")) {
                String outFilePath = path.replaceAll(" ", "").replaceAll("\\.zip", "").replaceAll(" ", "");
                boolean unZipResult = GZFileUtils.unZipFiles((String)path, (String)outFilePath);
                logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u89e3\u538bZIP\u6587\u4ef6-\u7ed3\u679c:{} ", result);
                if (!unZipResult) continue;
                File accFile = FileCommonUtils.getFileByPath((String)outFilePath);
                boolean isHaveEmptyFile = false;
                if (accFile.exists()) {
                    File[] files = accFile.listFiles();
                    if (files != null && files.length > 0) {
                        for (File file : files) {
                            long length = file.length();
                            logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u76ee\u5f55\uff1a{}-\u6587\u4ef6\u5927\u5c0f\uff1a{}  ", new Object[]{file.getPath(), length});
                            if (length > 0L) {
                                String oldName = file.getName();
                                String newName = oldName.substring(0, 8) + "_" + accNo + "_" + oldName;
                                DownloadListDetail downloadListDetail = new DownloadListDetail();
                                downloadListDetail.setFileName(newName);
                                downloadListDetail.setFileLink(file.getName());
                                result.add(downloadListDetail);
                                boolean isSuccess = FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newName);
                                boolean isDelete = file.delete();
                                logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u91cd\u547d\u540d\u56de\u5355\u6587\u4ef6-\u76ee\u5f55\uff1a{}-\u6587\u4ef6\u662f\u5426\u79fb\u52a8\u6210\u529f\uff1a{}  newName:{} \u6e90\u6587\u4ef6\u662f\u5426\u5220\u9664\u6210\u529f\uff1a{}", new Object[]{isSuccess, destFolder, newName, isDelete});
                                continue;
                            }
                            isHaveEmptyFile = true;
                        }
                    }
                    logger.info("\u5174\u4e1a\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1--\u83b7\u53d6\u8d26\u53f7\u6587\u4ef6\u660e\u7ec6\u5b8c\u6bd5...");
                }
                if (!isHaveEmptyFile) {
                    FileCommonUtils.deleteAllFile((String)path);
                }
                FileCommonUtils.deleteAllFile((String)outFilePath);
                continue;
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u56de\u5355\u683c\u5f0f:%s\u3002", (String)"BankReceiptDownloadImpl_7", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]), receiptFileName));
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BOC_NET_DC_DOWNLOAD";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_5", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]);
    }
}

