/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cib.dc.services.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.cib.dc.services.receipt.util.CIBReceiptApiEntity;
import kd.ebg.receipt.business.receipt.atom.AbstractProxyReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class DownloadFileImpl
extends AbstractProxyReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadFileImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Map paramsMap = bankReceiptRequest.getParamsMap();
        String fileId = (String)paramsMap.get("fileId");
        String fileName = (String)paramsMap.get("fileName");
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String receiptDownloadIp = RequestContextUtils.getBankParameterValue((String)"receiptDownloadIp");
        String receiptDownloadPort = RequestContextUtils.getBankParameterValue((String)"receiptDownloadPort");
        CIBReceiptApiEntity cibReceiptApiEntity = new CIBReceiptApiEntity();
        cibReceiptApiEntity.setFileId(fileId);
        cibReceiptApiEntity.setFileName(fileName);
        cibReceiptApiEntity.setFileIp(ip);
        cibReceiptApiEntity.setFilePort(receiptDownloadPort);
        if (EBGStringUtils.isNotEmpty((String)receiptDownloadIp)) {
            cibReceiptApiEntity.setFileIp(receiptDownloadIp);
        }
        String string = JSONObject.toJSONString((Object)cibReceiptApiEntity);
        EBContext.getContext().setRemoveWriteResponseLog(true);
        StringBuilder downloadUrl = new StringBuilder();
        downloadUrl.append("http://");
        downloadUrl.append(cibReceiptApiEntity.getFileIp());
        downloadUrl.append(":");
        downloadUrl.append(cibReceiptApiEntity.getFilePort());
        downloadUrl.append("/download?fileId=");
        downloadUrl.append(fileId);
        downloadUrl.append("&fileName=");
        downloadUrl.append(fileName);
        bankReceiptRequest.setReceiptDownloadURL(downloadUrl.toString());
        return "";
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String rspStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        return BankReceiptResponseEB.success();
    }

    public String recv(InputStream inputStream) {
        Map runningParams = EBContext.getContext().getRunningParams();
        String savePath = (String)runningParams.get("savePath");
        String fileName = (String)runningParams.get("newFileName");
        try {
            byte[] getData = this.readInputStream(inputStream);
            String string = new String(getData);
            if (string.length() < 1000) {
                logger.info("\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)string);
            }
            if (EBGStringUtils.isEmpty((String)string)) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"DownloadFileImpl_1", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]));
            }
            File saveDir = FileCommonUtils.getFileByPath((String)savePath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File file = FileCommonUtils.getFileByPath((String)(saveDir + File.separator + fileName));
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(getData);
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        return "";
    }

    private byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setProtocol("HTTP");
    }

    public String setFileType() {
        return ".zip";
    }
}

