/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.spdb.dc.service.receipt.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.SSLConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.Packer;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.SPDBDCCommConfig;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.Signature;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.WJ12ProxyImpl;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.jdom2.Element;

public class WJ12Impl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(WJ12Impl.class);
    private static WJ12Impl instance;

    WJ12Impl() {
    }

    public static synchronized WJ12Impl getInstance() {
        if (instance == null) {
            instance = new WJ12Impl();
        }
        return instance;
    }

    public void postRequest(String accNo, String transDateStr, String bakFilePath, String recNo, String fileName) throws Exception {
        boolean receiptProxyDownloadSwitch = Objects.equals("true", RequestContextUtils.getBankParameterValue((String)"receipt_proxy_download_switch"));
        if (receiptProxyDownloadSwitch) {
            RequestContextUtils.setRunningParam((String)"savePath", (String)bakFilePath);
            RequestContextUtils.setRunningParam((String)"fileName", (String)fileName);
            WJ12ProxyImpl wj12Proxy = new WJ12ProxyImpl();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(LocalDateUtil.parserDate((String)transDateStr)).accNo(accNo).requestStr(recNo).receiptFileName(fileName).build();
            BankReceiptResponseEB receiptResponseEB = wj12Proxy.doBiz(bankReceiptRequest);
            if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
                return;
            }
            return;
        }
        Element packet = new Element("packet");
        Element body = Packer.buildWJ12Body((String)accNo, (String)transDateStr, (String)recNo);
        Element head = Packer.buildHeadMessage((String)"WJ12");
        JDomUtils.addChild((Element)packet, (Element)head);
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)"GBK");
        Signature sign = Signature.getInstance();
        String signMsg = sign.sign(srcSign);
        Element bodySign = new Element("body");
        JDomUtils.addChild((Element)bodySign, (String)"signature", (String)signMsg);
        JDomUtils.addChild((Element)packet, (Element)bodySign);
        String msg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)packet, (String)"GBK");
        String encoding = "GBK";
        String length = "" + (StringLength.getLength4DataWithEncoding((String)msg, (String)encoding) + 6);
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringLength.fixedLength((String)length, (String)" ", (int)6));
        buffer.append(msg);
        this.sendFileByDownload(buffer.toString(), bakFilePath, fileName);
    }

    private void sendFileByDownload(String rqstStr, String bakFilePath, String fileName) {
        try {
            EBContext.getContext().setRemoveWriteResponseLog(true);
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            String bankLogin = EBContext.getContext().getBankLoginID();
            SPDBDCCommConfig config = (SPDBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(SPDBDCCommConfig.class, bankLogin);
            factory.setIp(config.getBiSafeIP());
            factory.setPort(config.getBiSafeFilePort().toString());
            factory.setUri("/fileTransfer/");
            this.commumication(factory, rqstStr, bakFilePath, fileName);
            EBContext.getContext().setRemoveWriteResponseLog(false);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42WJ12\u63a5\u53e3\u53d1\u751f\u5f02\u5e38", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private void commumication(ConnectionFactory factory, String requestStr, String bakFilePath, String fileName) {
        try {
            IConnection conn = factory.createExchangeConnection();
            this.openConnection(conn);
            try (OutputStream os = conn.getOutputStream();){
                this.send(os, requestStr);
                try (InputStream is = conn.getInputStream();){
                    this.recv(is, bakFilePath, fileName);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42WJ12\u63a5\u53e3-\u5f02\u5e38:{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public void recv(InputStream in, String bakFilePath, String fileName) throws IOException {
        boolean flag;
        File bakFile;
        byte[] rcvtmp;
        byte[] lengthdata = new byte[6];
        in.read(lengthdata);
        String lengthstr = new String(lengthdata).trim();
        int length = Integer.parseInt(lengthstr);
        byte[] rcv = new byte[length];
        int j = 0;
        int srcindex = 0;
        int readLength = length - 6;
        while (j >= 0 && (j = in.read(rcvtmp = new byte[readLength])) >= 0) {
            readLength -= j;
            System.arraycopy(rcvtmp, 0, rcv, srcindex, j);
            if ((srcindex += j) != length - 6) continue;
            break;
        }
        EBContext.getContext().setRemoveWriteResponseLog(true);
        String contentstr = new String(rcv, "GBK");
        logger.infoFilerLog(contentstr);
        String rspData = Signature.getInstance().validateSignedData(contentstr);
        Element body = JDomUtils.string2Root((String)rspData, (String)"GBK");
        String retfileLengthStr = body.getChildText("fileLength");
        int fileLength = Integer.parseInt(retfileLengthStr);
        File tempFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
        logger.info("SPDC-DC-WJ12Impl \u6587\u4ef6\u540d :{} ", (Object)fileName);
        if (tempFile.exists()) {
            boolean isDelete = tempFile.delete();
            logger.info("\u6587\u4ef6\u540d:{}-\u662f\u5426\u5220\u9664\uff1a{} ", new Object[]{tempFile.getName(), isDelete});
        }
        if (!(bakFile = FileCommonUtils.getFileByPath((String)bakFilePath)).exists()) {
            flag = bakFile.mkdirs();
            logger.info("SPDC-DC-WJ12Impl \u76ee\u5f55\u4e0d\u5b58\u5728 :{} \u521b\u5efa\u7ed3\u679c{} ", new Object[]{bakFilePath, flag});
        }
        flag = tempFile.createNewFile();
        logger.info("SPDC-DC-WJ12Impl \u521b\u5efa\u6587\u4ef6 :{} \u521b\u5efa\u7ed3\u679c{} ", new Object[]{fileName, flag});
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(tempFile.toURI()), new OpenOption[0]);){
            byte[] readTemp = new byte[8096];
            int k = 0;
            for (int byteCounts = 0; (k >= 0 || byteCounts < fileLength) && (k = in.read(readTemp)) >= 0; byteCounts += k) {
                outputStream.write(readTemp, 0, k);
            }
            outputStream.close();
            EBContext.getContext().setRemoveWriteResponseLog(false);
        }
    }

    public void openConnection(IConnection connection) {
        try {
            EBContext.getContext().setConnection(connection);
            connection.openConnection();
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6253\u5f00\u8fde\u63a5\u5f02\u5e38\uff1a%s\u3002", (String)"WJ12Impl_1", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }

    public void send(OutputStream outputStream, String requestStr) {
        if (this.isSSLProxyConnection()) {
            SSLConnection connection = (SSLConnection)EBContext.getContext().getConnection();
            connection.sendMsg(outputStream, requestStr);
        } else {
            IOUtils.sendFully((OutputStream)outputStream, (String)requestStr);
        }
    }
}

