/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.reconciliation;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.cmb.opa.service.reconciliation.api.QueryBillOfd;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationDownloadHandleImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.utils.DownloadUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReconciliationDownloadImpl
extends AbstractBankReconciliationDownloadHandleImpl
implements IBankReconciliationHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationDownloadImpl.class);

    public boolean match(BankReconciliationHandleRequest request) {
        if (request == null) {
            return false;
        }
        if (!RequestContextUtils.isSupportReconciliation((String)EBContext.getContext().getBankLoginID())) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u4e0d\u652f\u6301\u5bf9\u8d26\u5355\u3002", (String)"", (String)"ebg-receipt-banks-ceb-dc", (Object[])new Object[0]));
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReconciliationHandleResponseEB doBiz(BankReconciliationHandleRequest request) {
        String zipName;
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String accNo = request.getAccNo();
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getReconciliationFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        ArrayList<ReconciliationDetail> downloadListDetails = request.getDetails();
        ArrayList result = new ArrayList(16);
        String bankLogin = EBContext.getContext().getBankLoginID();
        String bakPathParentPath = FileStorageUtil.getReconciliationFileBakPath((String)bankLogin) + File.separator + transDateStr;
        ReconciliationInfo task = request.getTask();
        ReconciliationDetail reconciliationDetail = (ReconciliationDetail)downloadListDetails.get(0);
        String issueKey = reconciliationDetail.getFileLink();
        BankReconciliationRequest queryBillOfdRequest = BankReconciliationRequest.builder().accNo(accNo).transDate(transDate).build();
        queryBillOfdRequest.setRequestStr(issueKey);
        QueryBillOfd queryBillOfd = new QueryBillOfd();
        BankReconciliationResponseEB qboResp = queryBillOfd.doBiz(queryBillOfdRequest);
        List queryBillOfdList = (List)qboResp.getData();
        downloadListDetails = new ArrayList<ReconciliationDetail>(queryBillOfdList.size());
        for (JSONObject jSONObject : queryBillOfdList) {
            String fileUrl = jSONObject.getString("fileUrl");
            String fileKey = jSONObject.getString("fileKey");
            logger.info("fileUrl -> {}", (Object)fileUrl);
            if (StringUtils.isEmpty((String)fileUrl)) continue;
            if (StringUtils.isEmpty((String)fileKey)) {
                fileKey = Sequence.genSequence() + "_reconciliation_ofd.tar.gz";
            }
            ReconciliationDetail detail = new ReconciliationDetail();
            detail.setFileLink(fileUrl);
            detail.setFileName(fileKey);
            downloadListDetails.add(detail);
        }
        for (ReconciliationDetail reconciliationDetail2 : downloadListDetails) {
            String downloadURL = reconciliationDetail2.getFileLink();
            zipName = reconciliationDetail2.getFileName();
            DownloadUtils.download((String)downloadURL, (String)zipName, (String)bakPathParentPath);
        }
        String destDir = bakFilePath + File.separator + issueKey;
        for (ReconciliationDetail downloadListDetail : downloadListDetails) {
            zipName = downloadListDetail.getFileName();
            BankReconciliationDownloadImpl.readAndExtractTar(bakPathParentPath + File.separator + zipName, destDir);
        }
        try (Stream<Path> stream = Files.walk(Paths.get(destDir, new String[0]), new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(f -> {
                if (FileCommonUtils.moveFile((File)f, (String)bakFilePath, (String)f.getName())) {
                    logger.info("\u6210\u529f\u4e0b\u8f7d \u2014> {}", (Object)f.getName());
                    ReconciliationDetail detail = new ReconciliationDetail();
                    detail.setFileLink(f.getName());
                    detail.setFileName(f.getName());
                    detail.setTransDate(task.getTransDate());
                    result.add(detail);
                }
            });
        }
        catch (IOException iOException) {
            logger.info("\u626b\u63cf\u6587\u4ef6\u5939{}\u5f02\u5e38", (Object)destDir);
            logger.error(iOException.getMessage(), (Throwable)iOException);
        }
        return BankReconciliationHandleResponseEB.success(result);
    }

    public static void readAndExtractTar(String filePath, String destPath) {
        File tarFile;
        String tarFilePath = filePath.replace(" ", "").replace(".gz", "").replaceAll(" ", "");
        if (GZFileUtils.unGzFile((String)filePath, (String)tarFilePath)) {
            logger.info("gz {}\u89e3\u538b\u6210\u529f", (Object)filePath);
            if (GZFileUtils.unTarFiles((String)tarFilePath, (String)destPath)) {
                logger.info("tar {}\u89e3\u538b\u6210\u529f", (Object)tarFilePath);
            }
        }
        if ((tarFile = FileCommonUtils.getFileByPath((String)tarFilePath)).exists()) {
            FileCommonUtils.deleteFile((String)tarFilePath);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

