/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.opa.service.reconciliation.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.JsonUtil;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.MsgPacker;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.MsgParser;
import kd.ebg.receipt.banks.cmb.opa.service.receipt.util.gm.PostUtil;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliation;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class QueryBillOfd
extends AbstractBankReconciliationImpl
implements IBankReconciliation {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBillOfd.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankReconciliationRequest bankReconciliationRequest) {
        String accNo = bankReconciliationRequest.getAccNo();
        String transDate = LocalDateUtil.formatDate((LocalDate)bankReconciliationRequest.getTransDate(), (String)"yyyyMMdd");
        JSONObject body = new JSONObject();
        JSONArray issueKeyArray = new JSONArray();
        JSONObject issueKeyObj = new JSONObject();
        issueKeyObj.put("issueKey", (Object)bankReconciliationRequest.getRequestStr());
        issueKeyArray.add((Object)issueKeyObj);
        body.put("CprDirectQueryBillOfdX1", (Object)issueKeyArray);
        JSONObject head = JsonUtil.getHead((String)"queryBillOfd", (String)Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest((JSONObject)head, (JSONObject)body);
        logger.info("QueryBillOfd\u8bf7\u6c42-\u660e\u6587-{}-{}-\uff1a\n{}", new Object[]{accNo, transDate, request.toJSONString()});
        return MsgPacker.getSendMsg((JSONObject)request, (EBGLogger)logger, (String)"queryBillOfd");
    }

    public BankReconciliationResponseEB parse(BankReconciliationRequest bankReconciliationRequest, String s) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>(4);
        String accNo = bankReconciliationRequest.getAccNo();
        String transDate = LocalDateUtil.formatDate((LocalDate)bankReconciliationRequest.getTransDate(), (String)"yyyyMMdd");
        String res = MsgParser.getReceMsg((String)s, (EBGLogger)logger);
        logger.info("QueryBillOfd\u54cd\u5e94-\u89e3\u5bc6-{}-{}\uff1a{}", new Object[]{accNo, transDate, res});
        JSONObject request = JSON.parseObject((String)res);
        JSONObject response = request.getJSONObject("response");
        JSONObject head = response.getJSONObject("head");
        String resultcode = head.getString("resultcode");
        String resultmsg = head.getString("resultmsg");
        if (!"SUC0000".equals(resultcode)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff0c\u9519\u8bef\u4ee3\u7801\uff1a%1$s\uff0c\u9519\u8bef\u63cf\u8ff0\uff1a%2$s\u3002", (String)"", (String)"ebg-receipt-banks-cmb-opa", (Object[])new Object[0]), resultcode, resultmsg));
        }
        JSONObject body = response.getJSONObject("body");
        JSONArray queryBillOfdZ2Arr = body.getJSONArray("CprDirectQueryBillOfdZ2");
        if (queryBillOfdZ2Arr != null && !queryBillOfdZ2Arr.isEmpty()) {
            for (int i = 0; i < queryBillOfdZ2Arr.size(); ++i) {
                JSONObject queryBillOfdZ2 = queryBillOfdZ2Arr.getJSONObject(i);
                result.add(queryBillOfdZ2);
            }
        }
        return BankReconciliationResponseEB.success(result);
    }

    public BankReconciliationResponseEB doBiz(BankReconciliationRequest request) {
        try {
            String rqstStr = this.pack(request);
            String rspStr = PostUtil.sendMsg((String)rqstStr);
            return this.parse(request, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

