/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bcs.cmp.service;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> responseResult = new ArrayList<DownloadListDetail>(8);
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)transDateStr);
        String bankLogin = request.getBankLoginId();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                responseResult.add(downloadListDetail);
                continue;
            }
            if (this.download(downloadListDetail, bakFilePath, accNo, transDate, bankFtpProperties, sftp)) {
                logger.info("\u4e0b\u8f7d\u6210\u529f\uff0c\u6587\u4ef6\u540d\u4e3a{}", (Object)downloadListDetail.getFileName());
                responseResult.add(downloadListDetail);
                continue;
            }
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-bcs-cmp", (Object[])new Object[0]));
        }
        logger.info(">>>>>>>>>\u957f\u6c99\u94f6\u884c-{}-{}-\u672c\u6b21\u8fd4\u56de\u7684\u56de\u5355\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, responseResult.size()});
        return BankReceiptHandleResponseEB.success(responseResult);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean download(DownloadListDetail detail, String bakFilePath, String accNo, LocalDate transDate, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        fileName = detail.getFileLink();
        BankReceiptDownloadImpl.logger.info("\u4e0b\u8f7d\u7684\u539f\u6587\u4ef6\u540d{}", (Object)fileName);
        fileNameSplit = fileName.split("/");
        fn = fileNameSplit[fileNameSplit.length - 1];
        BankReceiptDownloadImpl.logger.info("\u4e0b\u8f7d\u7684\u6587\u4ef6\u540d{}", (Object)fn);
        localDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        sftpPath = bankFtpProperties.getFtpPath();
        sftpPath = StringUtils.isEmpty((String)sftpPath) != false ? "/" + localDate : sftpPath + "/" + localDate;
        try {
            flag = false;
            if (!bankFtpProperties.getReceiptAchieveWay().equals("sftp")) ** GOTO lbl33
            try {
                flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath, fn, bakFilePath, sftp);
            }
            catch (ReceiptException e) {
                try {
                    localDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                    sftpPath = bankFtpProperties.getFtpPath();
                    sftpPath = StringUtils.isEmpty((String)sftpPath) != false ? "/" + localDate : sftpPath + "/" + localDate;
                    flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath, fn, bakFilePath, sftp);
                }
                catch (ReceiptException ee) {
                    try {
                        sftpPath = bankFtpProperties.getFtpPath();
                        flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath, fn, bakFilePath, sftp);
                    }
                    catch (ReceiptException eee) {
                        BankReceiptDownloadImpl.logger.info("\u4e0b\u8f7d\u5931\u8d25{}", (Object)eee.getMessage());
                        var16_21 = false;
                        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp") == false) return var16_21;
                        SFTPUtils.getInstance().close(sftp);
                        return var16_21;
                    }
                }
lbl33:
                // 1 sources

                if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                    bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                    frontProxyPath = bankFtpProperties.getFrontProxyPath() + File.separator + localDate;
                    tempFiles = this.getFileByName(fn, accNo, transDate, frontProxyPath);
                    if (tempFiles.isEmpty()) {
                        localDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                        frontProxyPath = bankFtpProperties.getFrontProxyPath() + File.separator + localDate;
                        tempFiles = this.getFileByName(fn, accNo, LocalDate.now(), frontProxyPath);
                        if (tempFiles.isEmpty()) {
                            frontProxyPath = bankFtpProperties.getFrontProxyPath();
                            tempFiles = this.getFileByName(fn, accNo, LocalDate.now(), frontProxyPath);
                        }
                    }
                    if (CollectionUtil.isNotEmpty(tempFiles)) {
                        for (String tempFileName : tempFiles) {
                            if (!tempFileName.contains(fn)) continue;
                            flag = bankReceiptApiUtil.downloadReceiptFileWithPath(frontProxyPath, fn, bakFilePath);
                        }
                    }
                }
                if (flag) {
                    BankReceiptDownloadImpl.logger.info("\u4e0b\u8f7d\u6210\u529f");
                    file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fn));
                    if (file.exists()) {
                        BankReceiptDownloadImpl.logger.info("\u6587\u4ef6\u5b58\u5728");
                        FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)detail.getFileName());
                    }
                }
                var13_16 = flag;
                return var13_16;
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        finally {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate, String frontProxyPath) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString, "", frontProxyPath);
    }
}

