/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gsb.dc.service.api;

import com.google.common.collect.Lists;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gsb.dc.utils.Packer;
import kd.ebg.receipt.banks.gsb.dc.utils.Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory((ConnectionFactory)factory, (String)"B2EBillQry");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        Element root = Packer.buildHead((String)"B2EBillQry", null);
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"Currency", (String)bankDetailRequest.getAcnt().getCurrency());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String s) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        this.setLastPage(true);
        BankAcnt acnt = request.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankResponse = Parser.parser((Element)root);
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element map = DetailImpl.getTarget(root, Lists.newArrayList((Object[])new String[]{"Body", "List", "Map"}));
            if (map == null) {
                return new EBBankDetailResponse(detailList);
            }
            if (!"000000".equals(map.getChildTextTrim("ReturnCode"))) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s", (String)"DetailImpl_0", (String)"ebg-receipt-banks-gsb-dc", (Object[])new Object[0]), map.getChildTextTrim("ReturnMsg")));
            }
            Element list = map.getChild("List");
            if (list == null) {
                return new EBBankDetailResponse(detailList);
            }
            List records = list.getChildren("Map");
            if (CollectionUtil.isEmpty((Collection)records)) {
                return new EBBankDetailResponse(detailList);
            }
            HashSet<String> trsJnlNoSet = new HashSet<String>(2);
            for (Element element : records) {
                DetailInfo detail = new DetailInfo();
                String transDate = request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE);
                String trsJnlNo = element.getChildTextTrim("TrsJnlNo");
                if (StringUtils.isEmpty((String)trsJnlNo) || trsJnlNoSet.contains(trsJnlNo)) continue;
                trsJnlNoSet.add(trsJnlNo);
                detail.setUniqueSeq(trsJnlNo);
                detail.setReceiptNo(String.join((CharSequence)"_", Lists.newArrayList((Object[])new String[]{acnt.getAccNo(), transDate, trsJnlNo})) + ".pdf");
                detailList.add(detail);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s", (String)"DetailImpl_0", (String)"ebg-receipt-banks-gsb-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EBillQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-receipt-banks-gsb-dc", (Object[])new Object[0]);
    }

    public static Element getTarget(Element root, List<String> paths) {
        if (root == null || paths.isEmpty()) {
            return root;
        }
        String path = paths.remove(0);
        return DetailImpl.getTarget(root.getChild(path), paths);
    }
}

