/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.czccb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.api.DetailImpl;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.api.ReceiptQueryImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"CZCCB_DC", (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        ArrayList<Object> result = new ArrayList<Object>(16);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        List detailInfos = DetailImpl.queryReceiptList((String)accNo, (LocalDate)transDate);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)detailInfos.size());
        for (DetailInfo detailInfo : detailInfos) {
            String fileName;
            String loanFlag = detailInfo.getReversed1();
            String transferSum = detailInfo.getExplanation();
            String seqNo = detailInfo.getReversed2();
            String transferFlowNo = detailInfo.getReceiptNo();
            String newLoanFlag = "D";
            if (loanFlag.equals("D")) {
                newLoanFlag = "1";
            }
            if (loanFlag.equals("C")) {
                newLoanFlag = "2";
            }
            if (existMap.containsKey(fileName = this.packFileName(accNo, transDateStr, transferFlowNo, transferSum, loanFlag, seqNo, countMap))) {
                result.add(existMap.get(fileName));
                continue;
            }
            ReceiptQueryImpl receiptQuery = new ReceiptQueryImpl();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
            RequestContextUtils.setRunningParam((String)"loanFlag", (String)newLoanFlag);
            RequestContextUtils.setRunningParam((String)"transferSum", (String)transferSum);
            RequestContextUtils.setRunningParam((String)"seqNo", (String)seqNo);
            RequestContextUtils.setRunningParam((String)"transferFlowNo", (String)transferFlowNo);
            BankReceiptResponseEB receiptResponseEB = receiptQuery.doBiz(bankReceiptRequest);
            String base64Str = (String)receiptResponseEB.getData();
            FileCommonUtils.base64ToFile((String)base64Str, (String)(bakFilePath + File.separator + fileName));
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileLink(fileName);
            downloadListDetail.setFileName(fileName);
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-czccb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String packFileName(String accNo, String transDateStr, String transferFlowNo, String transferSum, String loanFlag, String seqNo, Map<String, Integer> countMap) {
        StringBuilder fileNameBuilder = new StringBuilder();
        fileNameBuilder.append(accNo).append("_");
        fileNameBuilder.append(transDateStr).append("_");
        fileNameBuilder.append(transferFlowNo).append("_");
        fileNameBuilder.append(transferSum).append("_");
        fileNameBuilder.append(loanFlag).append("_");
        fileNameBuilder.append(seqNo);
        if (countMap.containsKey(fileNameBuilder.toString())) {
            int recount = countMap.get(fileNameBuilder.toString());
            countMap.put(fileNameBuilder.toString(), recount + 1);
            fileNameBuilder.append("_").append(String.format("%04d", recount));
        } else {
            countMap.put(fileNameBuilder.toString(), 0);
        }
        fileNameBuilder.append(".pdf");
        return fileNameBuilder.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CZCCB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u6ca7\u5dde\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-czccb-dc", (Object[])new Object[0]);
    }
}

