/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.czccb.dc.service.receipt.api;

import java.util.Objects;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.api.SignService;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.util.Packer;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.util.RequestPacker;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.util.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;

public class ReceiptQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptQueryImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        String receiptCode = RequestContextUtils.getBankParameterValue((String)"czccb_dc_receipt_code");
        if (Objects.equals(receiptCode, "CBE030106")) {
            return "CBE030106";
        }
        return "CBE030108";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        String loanFlag = RequestContextUtils.getRunningParam((String)"loanFlag");
        String transferFlowNo = RequestContextUtils.getRunningParam((String)"transferFlowNo");
        String seqNo = RequestContextUtils.getRunningParam((String)"seqNo");
        String body = RequestPacker.receiptPackerBody((String)accNo, (String)loanFlag, (String)transferFlowNo, (String)seqNo);
        String header = RequestPacker.createHeadMessage((String)"CBE030108");
        String reqMsg = header + body;
        String signData = SignService.getSignData(reqMsg, "UTF-8");
        reqMsg = header + body + signData;
        String strLen = Packer.getLength((String)reqMsg);
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return strLen + reqMsg;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        if (responseStr.length() < 500) {
            logger.info("\u54cd\u5e94\u62a5\u6587\uff1a\n" + responseStr);
        }
        return BankReceiptResponseEB.success((Object)ResponseParser.receiptParser((String)responseStr));
    }
}

