/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cexim.dc.service.receipt.download;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.api.GetOneReceiptFileImpl;
import kd.ebg.receipt.banks.cexim.dc.service.receipt.utils.CommonParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        long taskId = request.getTaskId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        List downloadListDetailList = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        for (DownloadListDetail downloadListDetail : downloadListDetailList) {
            if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                result.add(downloadListDetail);
                continue;
            }
            String fileName = downloadListDetail.getFileName();
            String fileLink = downloadListDetail.getFileLink();
            GetOneReceiptFileImpl getOneReceiptFile = new GetOneReceiptFileImpl();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(fileLink).build();
            BankReceiptResponseEB receiptResponseEB = getOneReceiptFile.doBiz(bankReceiptRequest);
            String fileContext = (String)receiptResponseEB.getData();
            boolean flag = FileCommonUtils.write2File((byte[])CommonParser.hexStr2Byte(fileContext), (String)(bakFilePath + File.separator + fileName));
            if (!flag) continue;
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

